/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.displays.metrics;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.stage.Screen;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerEditor;
import oracle.ide.Context;

public abstract class MetricsViewer
extends AsynchronousViewerEditor {
    private volatile JPanel swingPanel;
    private volatile JFXPanel fxPanel;
    private Scene scene;
    private boolean panning;
    private double panInitialX;
    private double panInitialY;
    private double translateX;
    private double translateY;
    private boolean zooming;
    private double currentZoom;
    private double dragZoomInitial;
    private int dragInitial;
    private int deltaDrag;
    private int deltaDragThreshold;
    private double scale = 1.0;
    private boolean panAndZoom;

    protected MetricsViewer() {
        this(false);
    }

    protected MetricsViewer(boolean bl) {
        this.panAndZoom = bl;
        if (bl) {
            this.setEditorAttribute("scrollable", false);
        }
    }

    protected void getEditorContentImpl(Context context, AsynchronousViewerEditor.LoaderTaskManager loaderTaskManager) {
        this.onSetContext(context);
        super.getEditorContentImpl(context, loaderTaskManager);
    }

    protected JComponent createViewerUI() {
        if (this.swingPanel == null) {
            this.swingPanel = new JPanel(new BorderLayout());
            this.fxPanel = new JFXPanel();
            this.swingPanel.add((Component)this.fxPanel, "Center");
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        MetricsViewer.this.createFXViewerUI();
                    }
                    catch (RuntimeException runtimeException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "error creating FX viewer UI", runtimeException);
                    }
                }
            });
        }
        return this.swingPanel;
    }

    private void createFXViewerUI() {
        this.scene = this.createScene();
        if (this.panAndZoom) {
            this.setupPanAndZoomHandlers();
        }
        this.fxPanel.setScene(this.scene);
    }

    protected abstract void onSetContext(Context var1);

    protected abstract Scene createScene();

    protected abstract void closeScene();

    public void closeImpl(boolean bl) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MetricsViewer.this.closeScene();
            }
        });
        super.closeImpl(bl);
    }

    public Object getPrintable() {
        return this.swingPanel;
    }

    protected void updateContent(boolean bl) {
    }

    protected void cleanUp() {
    }

    private void setupPanAndZoomHandlers() {
        this.scene.addEventHandler(MouseEvent.DRAG_DETECTED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.isControlDown()) {
                    MetricsViewer.this.zooming = true;
                    MetricsViewer.this.beginZoom((int)mouseEvent.getScreenX());
                } else {
                    MetricsViewer.this.panning = true;
                    MetricsViewer.this.beginPan((int)mouseEvent.getScreenX(), (int)mouseEvent.getScreenY());
                }
                mouseEvent.consume();
            }
        });
        this.scene.addEventHandler(MouseEvent.MOUSE_DRAGGED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (MetricsViewer.this.zooming) {
                    MetricsViewer.this.zoom((int)mouseEvent.getScreenX());
                } else if (MetricsViewer.this.panning) {
                    MetricsViewer.this.pan((int)mouseEvent.getScreenX(), (int)mouseEvent.getScreenY());
                }
                mouseEvent.consume();
            }
        });
        this.scene.addEventHandler(MouseEvent.MOUSE_RELEASED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (MetricsViewer.this.zooming) {
                    MetricsViewer.this.zooming = false;
                } else if (MetricsViewer.this.panning) {
                    MetricsViewer.this.panning = false;
                }
                mouseEvent.consume();
            }
        });
    }

    private void applyTransforms() {
        Translate translate = Transform.translate((double)this.translateX, (double)this.translateY);
        Scale scale = Transform.scale((double)this.scale, (double)this.scale, (double)0.0, (double)0.0);
        this.scene.getRoot().getTransforms().setAll((Object[])new Transform[]{translate, scale});
    }

    private void beginPan(int n, int n2) {
        this.panInitialX = n;
        this.panInitialY = n2;
    }

    private void pan(int n, int n2) {
        this.translateX = this.translateX + (double)n - this.panInitialX;
        this.translateY = this.translateY + (double)n2 - this.panInitialY;
        this.panInitialX = n;
        this.panInitialY = n2;
        this.applyTransforms();
    }

    private void beginZoom(int n) {
        if (this.deltaDragThreshold == 0) {
            this.deltaDragThreshold = (int)Screen.getPrimary().getVisualBounds().getWidth() / 2;
        }
        this.dragInitial = n;
        this.dragZoomInitial = this.currentZoom;
    }

    private void zoom(int n) {
        int n2 = n - this.dragInitial;
        if (n2 != this.deltaDrag) {
            this.deltaDrag = n2;
            this.currentZoom = this.dragZoomInitial + (double)this.deltaDrag / (double)this.deltaDragThreshold;
            this.scale = Math.pow(10.0, this.currentZoom);
            this.applyTransforms();
        }
    }
}

