/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.tablespacesets;

import java.beans.PropertyChangeEvent;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.tablespacesets.Keyword;
import oracle.dbtools.raptor.dba.navigator.actions.tablespacesets.KeywordClause;
import oracle.dbtools.raptor.dba.navigator.actions.tablespacesets.Operation;
import oracle.dbtools.raptor.dba.navigator.actions.tablespacesets.TablespaceSetValues;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.FileSizeActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class AdvancedPropertiesTab
extends ActionDialogTab {
    private final TablespaceSetValues tablespaceSetValues;

    public AdvancedPropertiesTab(String string, TablespaceSetValues tablespaceSetValues) {
        super(string, DbaNavigatorResources.getString("ADVANCED_PROPERTIES_TAB"));
        this.tablespaceSetValues = tablespaceSetValues;
    }

    public List<ActionControl> createControls(Connection connection) {
        TextBoxActionControl textBoxActionControl;
        ComboBoxActionControl comboBoxActionControl;
        TextBoxActionControl textBoxActionControl2;
        Operation operation = this.tablespaceSetValues.getOperation();
        boolean bl = operation != Operation.EDIT;
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        if (bl) {
            textBoxActionControl2 = new TextBoxActionControl("BlockSize", DbaNavigatorResources.getString("BLOCK_SIZE_LABEL"), this.tablespaceSetValues.getBlockSize());
            arrayList.add((ActionControl)textBoxActionControl2);
        }
        textBoxActionControl2 = new ComboBoxActionControl("Logging", DbaNavigatorResources.getString("LOGGING_LABEL"), KeywordClause.LOGGING.getUserSelectables(operation), Keyword.dbRepToNls(this.tablespaceSetValues.getLogging()));
        arrayList.add((ActionControl)textBoxActionControl2);
        ComboBoxActionControl comboBoxActionControl2 = new ComboBoxActionControl("ForceLogging", DbaNavigatorResources.getString("FORCE_LOGGING_LABEL"), KeywordClause.FORCE_LOGGING.getUserSelectables(operation), Keyword.dbRepToNls(this.tablespaceSetValues.getForceLogging()));
        arrayList.add((ActionControl)comboBoxActionControl2);
        if (bl) {
            comboBoxActionControl = new ComboBoxActionControl("Encryption", DbaNavigatorResources.getString("ENCRYPTION_LABEL"), KeywordClause.ENCRYPTION.getUserSelectables(operation), Keyword.dbRepToNls(this.tablespaceSetValues.getEncryption()));
            arrayList.add((ActionControl)comboBoxActionControl);
            textBoxActionControl = new TextBoxActionControl("Algorithm", DbaNavigatorResources.getString("ALGORITHM_LABEL"), this.tablespaceSetValues.getEncryptionAlgorith());
            arrayList.add((ActionControl)textBoxActionControl);
        } else {
            comboBoxActionControl = null;
            textBoxActionControl = null;
        }
        ComboBoxActionControl comboBoxActionControl3 = new ComboBoxActionControl("OnlineStatus", DbaNavigatorResources.getString("ONLINE_STATUS_LABEL"), KeywordClause.ONLINE_STATUS.getUserSelectables(operation), Keyword.dbRepToNls(this.tablespaceSetValues.getOnlineStatus()));
        arrayList.add((ActionControl)comboBoxActionControl3);
        if (bl) {
            ComboBoxActionControl comboBoxActionControl4 = new ComboBoxActionControl("SegmentManagement", DbaNavigatorResources.getString("SEGMENT_MANAGEMENT_LABEL"), KeywordClause.SEGMENT_MANAGEMENT.getUserSelectables(operation), Keyword.dbRepToNls(this.tablespaceSetValues.getSegmentSpaceManagement()));
            arrayList.add((ActionControl)comboBoxActionControl4);
            ComboBoxActionControl comboBoxActionControl5 = new ComboBoxActionControl("ExtentManagement", DbaNavigatorResources.getString("EXTENT_MANAGEMENT_LABEL"), KeywordClause.EXTENT_MANAGEMENT.getUserSelectables(operation), Keyword.dbRepToNls(this.tablespaceSetValues.getExtentManagement()));
            arrayList.add((ActionControl)comboBoxActionControl5);
            FileSizeActionControl fileSizeActionControl = new FileSizeActionControl("ExtentSize", DbaNavigatorResources.getString("EXTENT_SIZE_LABEL"), (long)this.tablespaceSetValues.getMinExtlen());
            arrayList.add((ActionControl)fileSizeActionControl);
            ComboBoxActionControl comboBoxActionControl6 = new ComboBoxActionControl("Flashback", DbaNavigatorResources.getString("FLASHBACK_LABEL"), KeywordClause.FLASHBACK.getUserSelectables(operation), Keyword.dbRepToNls(this.tablespaceSetValues.getFlashback()));
            arrayList.add((ActionControl)comboBoxActionControl6);
            this.resetControlEnablement((ActionControl)comboBoxActionControl, (ActionControl)textBoxActionControl, (ActionControl)comboBoxActionControl5, (ActionControl)fileSizeActionControl);
            assert (comboBoxActionControl != null);
            comboBoxActionControl.addPropertyChangeListener(arg_0 -> this.lambda$createControls$0((ActionControl)comboBoxActionControl, (ActionControl)textBoxActionControl, (ActionControl)comboBoxActionControl5, (ActionControl)fileSizeActionControl, arg_0));
            comboBoxActionControl5.addPropertyChangeListener(arg_0 -> this.lambda$createControls$1((ActionControl)comboBoxActionControl, (ActionControl)textBoxActionControl, (ActionControl)comboBoxActionControl5, (ActionControl)fileSizeActionControl, arg_0));
        }
        return arrayList;
    }

    private void resetControlEnablement(ActionControl actionControl, ActionControl actionControl2, ActionControl actionControl3, ActionControl actionControl4) {
        boolean bl = actionControl.getValue().get().equals(DbaNavigatorResources.getString("YES_LABEL"));
        boolean bl2 = actionControl3.getValue().get().equals(DbaNavigatorResources.getString("UNIFORM_LABEL"));
        actionControl2.enableUI(bl);
        actionControl4.enableUI(bl2);
    }

    private /* synthetic */ void lambda$createControls$1(ActionControl actionControl, ActionControl actionControl2, ActionControl actionControl3, ActionControl actionControl4, PropertyChangeEvent propertyChangeEvent) {
        this.resetControlEnablement(actionControl, actionControl2, actionControl3, actionControl4);
    }

    private /* synthetic */ void lambda$createControls$0(ActionControl actionControl, ActionControl actionControl2, ActionControl actionControl3, ActionControl actionControl4, PropertyChangeEvent propertyChangeEvent) {
        this.resetControlEnablement(actionControl, actionControl2, actionControl3, actionControl4);
    }
}

