/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.tablespace;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class StorageManagementAction
extends ActionDialog {
    private static final String TABLESPACE = "Tablespace";
    private static final String UNIT_SIZE = "UnitSize";
    private static final String FILE_NUMBER = "FileNumber";
    private String _type = null;

    protected String getTitle() {
        if (this._type.equals("DICTIONARY")) {
            return DbaNavigatorResources.getString("TO_LOCAL_TITLE");
        }
        if (this._type.equals("LOCAL")) {
            return DbaNavigatorResources.getString("TO_DML_TITLE");
        }
        return null;
    }

    private List<ActionControl> toLmtControls(Connection connection) {
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(TABLESPACE, DbaNavigatorResources.getString("TABLESPACE_LABEL"), this.getDBObject().getObjectName());
        TextBoxActionControl textBoxActionControl2 = new TextBoxActionControl(UNIT_SIZE, DbaNavigatorResources.getString("UNIT_SIZE_LABEL"), null);
        TextBoxActionControl textBoxActionControl3 = new TextBoxActionControl(FILE_NUMBER, DbaNavigatorResources.getString("FILE_NUMBER_LABEL"), null);
        textBoxActionControl.enableUI(false);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)textBoxActionControl2);
        arrayList.add((ActionControl)textBoxActionControl3);
        return arrayList;
    }

    private List<ActionControl> toDmtControls(Connection connection) {
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(TABLESPACE, DbaNavigatorResources.getString("TABLESPACE_LABEL"), this.getDBObject().getObjectName());
        textBoxActionControl.enableUI(false);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl);
        return arrayList;
    }

    protected List<ActionControl> createControls(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TNAME", this.getDBObject().getObjectName());
        this._type = DBUtil.getInstance((Connection)connection).executeOracleReturnOneCol("select extent_management from dba_tablespaces where tablespace_name = :TNAME", hashMap);
        if (this._type.equals("DICTIONARY")) {
            return this.toLmtControls(connection);
        }
        if (this._type.equals("LOCAL")) {
            return this.toDmtControls(connection);
        }
        return null;
    }

    private String toLmtSql(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("exec dbms_space_admin.tablespace_migrate_to_local(");
        stringBuffer.append("tablespace_name=>'" + values.get(TABLESPACE) + "'");
        if (values.get(UNIT_SIZE) != null) {
            stringBuffer.append(",allocation_unit=>" + values.get(UNIT_SIZE));
        }
        if (values.get(FILE_NUMBER) != null) {
            stringBuffer.append(",relative_fno=>" + values.get(FILE_NUMBER));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String toDmtSql(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("begin");
        stringBuffer.append("\n dbms_space_admin.tablespace_migrate_from_local(");
        stringBuffer.append("tablespace_name=>'" + values.get(TABLESPACE) + "'");
        stringBuffer.append("); ");
        stringBuffer.append("\nend;");
        return stringBuffer.toString();
    }

    protected String getScript(ActionDialog.Values values) {
        if (this._type.equals("DICTIONARY")) {
            return this.toLmtSql(values);
        }
        if (this._type.equals("LOCAL")) {
            return this.toDmtSql(values);
        }
        return null;
    }
}

