/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.redologgroups;

import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class CreateEditMemberAction
extends ActionDialog {
    private static final String FILE_NAME = "FileName";
    private static final String DIRECTORY = "FileDirectory";
    private String _groupNo;

    protected String getTitle() {
        String string = null;
        Operation operation = this.getOperation();
        string = operation == Operation.EDIT ? DbaNavigatorResources.getString("EDIT_MEMBER_TITLE") : DbaNavigatorResources.getString("CREATE_MEMBER_TITLE");
        return string;
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        Object object2;
        if (DbaUtil.isPDB(connection)) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbaNavigatorResources.getString("NOT_SUPPORTED_FOR_PDB"), (String)DbaNavigatorResources.getString("ERROR_TITLE"), null);
            throw new RuntimeException("not supported for pluggable database");
        }
        Operation operation = this.getOperation();
        String string = DbaNavigatorResources.getString("ENTER_VALUE_PROMPT");
        Object object3 = DbaNavigatorResources.getString("ENTER_VALUE_PROMPT") + "/";
        if (operation == Operation.CREATE_NEW) {
            this._groupNo = this.getObjectName().substring(1);
        } else if (Connections.getInstance().lock(connection)) {
            object2 = null;
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("MEMBER", this.getObjectName());
                object = DBUtil.getInstance((Connection)connection);
                object.setRaiseError(true);
                object2 = object.executeOracleQuery(this.getQuery(connection, "getMemberGroup"), hashMap);
                if (object2 != null) {
                    while (object2.next()) {
                        this._groupNo = object2.getString("GROUP#");
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                DBUtil.closeResultSet((ResultSet)object2);
                Connections.getInstance().unlock(connection);
            }
        }
        if (operation != Operation.CREATE_NEW) {
            object2 = this.getObjectName();
            int n = ((String)object2).lastIndexOf(47);
            if (n < 0) {
                n = ((String)object2).lastIndexOf(92);
            }
            n = n < 0 ? 0 : ++n;
            object3 = ((String)object2).substring(0, n);
            if (operation == Operation.EDIT) {
                string = ((String)object2).substring(n);
            }
        }
        object2 = new TextBoxActionControl(FILE_NAME, DbaNavigatorResources.getString("FILE_NAME_LABEL"), string);
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(DIRECTORY, DbaNavigatorResources.getString("DIRECTORY_LABEL"), (String)object3);
        object = new ArrayList();
        ((ArrayList)object).add(object2);
        ((ArrayList)object).add(textBoxActionControl);
        return object;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getOperation() != Operation.EDIT) {
            stringBuffer.append("ALTER DATABASE\nADD LOGFILE MEMBER '");
            stringBuffer.append(values.get(DIRECTORY));
            stringBuffer.append(values.get(FILE_NAME));
            stringBuffer.append("'\nTO GROUP ");
            stringBuffer.append(this._groupNo);
        } else {
            stringBuffer.append("ALTER DATABASE RENAME ");
            stringBuffer.append("\nFILE '");
            stringBuffer.append(this.getObjectName());
            stringBuffer.append("'\nTO '");
            stringBuffer.append(values.get(DIRECTORY));
            stringBuffer.append(values.get(FILE_NAME));
            stringBuffer.append("'");
        }
        return stringBuffer.toString();
    }

    private static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        EDIT;

    }
}

