/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.recovery;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.dba.navigator.actions.recovery.RecoverControlGroup;
import oracle.dbtools.raptor.dba.navigator.actions.recovery.RecoverDatafilesAction;
import oracle.dbtools.raptor.dba.navigator.actions.recovery.RecoverTablespacesAction;
import oracle.dbtools.raptor.dba.navigator.actions.recovery.RecoverWholeDatabaseAction;
import oracle.dbtools.raptor.dba.navigator.actions.recovery.RestoreControlGroup;
import oracle.dbtools.raptor.dba.navigator.actions.recovery.RestoreDatafilesAction;
import oracle.dbtools.raptor.dba.navigator.actions.recovery.RestoreTablespacesAction;
import oracle.dbtools.raptor.dba.navigator.actions.recovery.RestoreWholeDatabaseAction;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;

class RecoveryScriptGenerator {
    private boolean restoreOnly;
    private WholeDatabaseData wholeDatabaseData;
    private List<TargetDatafileData> targetDatafilesData;
    private List<TargetTablespaceData> targetTablespacesData;
    private String restoreTo;
    private boolean validateOnly;
    private boolean restoreToNewLoc;
    private String recoverTo;
    private boolean restoreAndRecover;
    private String date;
    private int scn;
    private int sequence;
    private String tag;
    private String restorePoint;
    private String restoreLoc;
    private boolean updateControlFile;
    private String jobName;

    RecoveryScriptGenerator(ActionDialog actionDialog, ActionDialog.Lookup lookup, WholeDatabaseData wholeDatabaseData, List<TargetDatafileData> list, List<TargetTablespaceData> list2) {
        this.wholeDatabaseData = wholeDatabaseData;
        this.targetDatafilesData = list;
        this.targetTablespacesData = list2;
        if (actionDialog instanceof RecoverWholeDatabaseAction) {
            this.restoreOnly = false;
        } else if (actionDialog instanceof RestoreWholeDatabaseAction) {
            this.restoreOnly = true;
        } else if (actionDialog instanceof RecoverTablespacesAction) {
            this.restoreOnly = false;
        } else if (actionDialog instanceof RestoreTablespacesAction) {
            this.restoreOnly = true;
        } else if (actionDialog instanceof RecoverDatafilesAction) {
            this.restoreOnly = false;
        } else if (actionDialog instanceof RestoreDatafilesAction) {
            this.restoreOnly = true;
        }
        this.jobName = RMANScriptProcessorActionControl.getJobName(lookup);
        if (this.restoreOnly) {
            this.restoreTo = lookup.get("RESTORE_TO");
            this.date = lookup.get("DATE");
            this.scn = Integer.parseInt(lookup.get("SCN"));
            this.sequence = Integer.parseInt(lookup.get("SEQUENCE"));
            this.tag = lookup.get("TAG");
            this.validateOnly = Boolean.parseBoolean(lookup.get("VALIDATE_ONLY"));
            this.restoreToNewLoc = Boolean.parseBoolean(lookup.get("RESTORE_TO_NEW_LOC"));
            this.restoreLoc = lookup.get("RESTORE_LOC");
            this.updateControlFile = Boolean.parseBoolean(lookup.get("UPDATE_CONTROL_FILE"));
        } else {
            this.recoverTo = lookup.get("RECOVER_TO");
            this.date = lookup.get("DATE");
            this.restorePoint = lookup.get("RESTORE_POINT");
            this.scn = Integer.parseInt(lookup.get("SCN"));
            this.sequence = Integer.parseInt(lookup.get("SEQUENCE"));
            this.restoreAndRecover = Boolean.parseBoolean(lookup.get("RESTORE"));
            this.restoreToNewLoc = Boolean.parseBoolean(lookup.get("RESTORE_TO_NEW_LOC"));
            this.restoreLoc = lookup.get("RESTORE_LOC");
            this.restoreToNewLoc = Boolean.parseBoolean(lookup.get("RESTORE_TO_NEW_LOC"));
            this.restoreLoc = lookup.get("RESTORE_LOC");
        }
    }

    private void addUntilTime(StringBuffer stringBuffer) {
        stringBuffer.append("UNTIL TIME \"TO_DATE('");
        stringBuffer.append(this.date);
        stringBuffer.append("', 'YYYY-MM-DD HH24:MI:SS')\"");
    }

    private void addUntilRestorePoint(StringBuffer stringBuffer) {
        stringBuffer.append("UNTIL RESTORE POINT '");
        stringBuffer.append(this.restorePoint);
        stringBuffer.append("'");
    }

    private void addUntilScn(StringBuffer stringBuffer) {
        stringBuffer.append("UNTIL SCN ");
        stringBuffer.append(this.scn);
    }

    private void addUntilSequence(StringBuffer stringBuffer) {
        stringBuffer.append("UNTIL LOGSEQ ");
        stringBuffer.append(this.sequence);
        stringBuffer.append(" THREAD 1");
    }

    private void addFromTag(StringBuffer stringBuffer) {
        stringBuffer.append("FROM TAG ");
        stringBuffer.append(this.tag);
    }

    private void addWholeDatabasePreamble(StringBuffer stringBuffer) {
        stringBuffer.append("SHUTDOWN IMMEDIATE;\n");
        stringBuffer.append("STARTUP MOUNT;\n");
    }

    private void addWholeDatabasePostamble(StringBuffer stringBuffer) {
        if (!this.restoreOnly && this.recoverTo.equals(RecoverControlGroup.RECOVER_TO_CURRENT_TIME)) {
            stringBuffer.append("ALTER DATABASE OPEN;\n");
        } else {
            stringBuffer.append("ALTER DATABASE OPEN RESETLOGS;\n");
        }
    }

    private void addSetTablespacesOffline(StringBuffer stringBuffer, boolean bl) {
        for (TargetTablespaceData targetTablespaceData : this.targetTablespacesData) {
            stringBuffer.append("SQL 'ALTER TABLESPACE \"");
            stringBuffer.append(targetTablespaceData.tablespace);
            stringBuffer.append("\" ");
            if (bl) {
                stringBuffer.append("OFFLINE IMMEDIATE");
            } else {
                stringBuffer.append("ONLINE");
            }
            stringBuffer.append("';\n");
        }
    }

    private void addSetDatafilesOffline(StringBuffer stringBuffer, boolean bl) {
        for (TargetDatafileData targetDatafileData : this.targetDatafilesData) {
            stringBuffer.append("SQL 'ALTER DATABASE DATAFILE ");
            stringBuffer.append(targetDatafileData.datafileNumber);
            stringBuffer.append(' ');
            if (bl) {
                stringBuffer.append("OFFLINE");
            } else {
                stringBuffer.append("ONLINE");
            }
            stringBuffer.append("';\n");
        }
    }

    private void addSetNewNameStatements(StringBuffer stringBuffer) {
        List<String> list = null;
        if (this.wholeDatabaseData != null) {
            list = this.wholeDatabaseData.datafileNames;
        } else if (this.targetDatafilesData != null) {
            list = new ArrayList<String>();
            for (TargetDatafileData object : this.targetDatafilesData) {
                list.add(object.datafile);
            }
        } else {
            list = new ArrayList<String>();
            for (TargetTablespaceData targetTablespaceData : this.targetTablespacesData) {
                list.addAll(targetTablespaceData.datafileNames);
            }
        }
        if (!this.restoreLoc.endsWith("/") && !this.restoreLoc.endsWith("\\")) {
            this.restoreLoc = this.restoreLoc.contains("/") ? this.restoreLoc + "/" : (this.restoreLoc.contains("\\") ? this.restoreLoc + "\\" : this.restoreLoc + "/");
        }
        for (String string : list) {
            stringBuffer.append("SET NEWNAME FOR DATAFILE '");
            stringBuffer.append(string);
            stringBuffer.append("' TO '");
            File file = new File(string);
            String string2 = this.restoreLoc + file.getName();
            stringBuffer.append(string2);
            stringBuffer.append("';\n");
        }
    }

    private void addSwitchDatafileStatement(StringBuffer stringBuffer) {
        stringBuffer.append("SWITCH DATAFILE ALL;\n");
    }

    private void addRestoreOrRecoverStatement(StringBuffer stringBuffer, boolean bl) {
        if (bl) {
            stringBuffer.append("RESTORE ");
        } else {
            stringBuffer.append("RECOVER ");
        }
        if (this.wholeDatabaseData != null) {
            stringBuffer.append("DATABASE");
        } else if (this.targetDatafilesData != null) {
            stringBuffer.append("DATAFILE ");
            boolean bl2 = true;
            for (TargetDatafileData targetDatafileData : this.targetDatafilesData) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(targetDatafileData.datafileNumber);
            }
        } else {
            stringBuffer.append("TABLESPACE ");
            boolean bl3 = true;
            for (TargetTablespaceData targetTablespaceData : this.targetTablespacesData) {
                if (bl3) {
                    bl3 = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append('\'');
                stringBuffer.append(targetTablespaceData.tablespace);
                stringBuffer.append('\'');
            }
        }
        if (this.restoreOnly) {
            if (this.restoreTo.equals(RestoreControlGroup.RESTORE_TO_DATE)) {
                stringBuffer.append(' ');
                this.addUntilTime(stringBuffer);
            } else if (this.restoreTo.equals(RestoreControlGroup.RESTORE_TO_SCN)) {
                stringBuffer.append(' ');
                this.addUntilScn(stringBuffer);
            } else if (this.restoreTo.equals(RestoreControlGroup.RESTORE_TO_SEQUENCE)) {
                stringBuffer.append(' ');
                this.addUntilSequence(stringBuffer);
            } else if (this.restoreTo.equals(RestoreControlGroup.RESTORE_TO_TAG)) {
                stringBuffer.append(' ');
                this.addFromTag(stringBuffer);
            }
        } else if (this.recoverTo.equals(RecoverControlGroup.RECOVER_TO_DATE)) {
            stringBuffer.append(' ');
            this.addUntilTime(stringBuffer);
        } else if (this.recoverTo.equals(RecoverControlGroup.RECOVER_TO_RESTORE_POINT)) {
            stringBuffer.append(' ');
            this.addUntilRestorePoint(stringBuffer);
        } else if (this.recoverTo.equals(RecoverControlGroup.RECOVER_TO_SCN)) {
            stringBuffer.append(' ');
            this.addUntilScn(stringBuffer);
        } else if (this.recoverTo.equals(RecoverControlGroup.RECOVER_TO_SEQUENCE)) {
            stringBuffer.append(' ');
            this.addUntilSequence(stringBuffer);
        }
        if (this.restoreOnly && this.validateOnly) {
            stringBuffer.append(" VALIDATE");
        }
        stringBuffer.append(";\n");
    }

    String generateScript() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.wholeDatabaseData != null) {
            this.addWholeDatabasePreamble(stringBuffer);
        }
        stringBuffer.append("RUN {\n");
        if (!this.restoreOnly || !this.validateOnly) {
            if (this.targetTablespacesData != null) {
                this.addSetTablespacesOffline(stringBuffer, true);
            } else if (this.targetDatafilesData != null) {
                this.addSetDatafilesOffline(stringBuffer, true);
            }
        }
        if (this.restoreOnly || this.restoreAndRecover) {
            if (!(this.restoreOnly && this.validateOnly || !this.restoreToNewLoc)) {
                this.addSetNewNameStatements(stringBuffer);
            }
            this.addRestoreOrRecoverStatement(stringBuffer, true);
            if (!(this.restoreOnly && this.validateOnly || !this.restoreToNewLoc)) {
                this.addSwitchDatafileStatement(stringBuffer);
            }
        }
        if (!this.restoreOnly) {
            this.addRestoreOrRecoverStatement(stringBuffer, false);
            if (!this.restoreOnly || !this.validateOnly) {
                if (this.targetTablespacesData != null) {
                    this.addSetTablespacesOffline(stringBuffer, false);
                } else if (this.targetDatafilesData != null) {
                    this.addSetDatafilesOffline(stringBuffer, false);
                }
            }
        }
        stringBuffer.append("}\n");
        if (this.wholeDatabaseData != null) {
            this.addWholeDatabasePostamble(stringBuffer);
        }
        return stringBuffer.toString();
    }

    static class TargetDatafileData {
        String datafile;
        int datafileNumber;

        TargetDatafileData(String string, int n) {
            this.datafile = string;
            this.datafileNumber = n;
        }
    }

    static class TargetTablespaceData {
        String tablespace;
        List<String> datafileNames;

        TargetTablespaceData(String string, List<String> list) {
            this.tablespace = string;
            this.datafileNames = list;
        }
    }

    static class WholeDatabaseData {
        List<String> datafileNames;

        WholeDatabaseData(List<String> list) {
            this.datafileNames = list;
        }
    }
}

