/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.pdbs;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.dba.navigator.actions.pdbs.FileObject;
import oracle.dbtools.raptor.utils.Connections;
import oracle.jdeveloper.db.ConnectionException;

public class TransferProgress {
    private double _count = 0.0;
    private int _percentage = 0;
    private double _totalSize = -1.0;
    private int _lastPercentage = 0;
    private RaptorTask<Boolean> _task;
    private String _dest;
    private Connection _con;
    private FileObject _fo;
    private int _jobid = -1;

    public TransferProgress(String string, FileObject fileObject) throws ConnectionException {
        this._dest = string;
        this._fo = fileObject;
        if (string != null) {
            this._con = Connections.getInstance().getUniqueConnection(this._dest);
        }
    }

    public boolean count(long l) {
        if (this._task != null && this._task.getDescriptor().isCancelled()) {
            return false;
        }
        this._count += (double)l;
        this._percentage = (int)(this._count / this._totalSize * 100.0);
        if (this._percentage >= this._lastPercentage + 1) {
            this._lastPercentage = this._percentage;
            if (this._task != null) {
                this._task.getDescriptor().setProgress(this._percentage);
                this._task.setMessage(String.valueOf(this._percentage) + "% Complete");
            }
            this.updateFilePercent(this._percentage);
        }
        return true;
    }

    public void end() {
        if (this._count >= this._totalSize && this._con != null) {
            this.updateFileStatus("COMPLETE");
            try {
                this._con.close();
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, sQLException.getMessage(), sQLException);
            }
        }
    }

    public void init(int n, String string, String string2, long l) {
        if (this._totalSize <= 0.0) {
            this._totalSize = l;
        }
        if (this._task != null) {
            this._task.getDescriptor().setProgress(0);
            this._task.setMessage("0% Complete");
        }
    }

    public void setTask(RaptorTask<Boolean> raptorTask) {
        this._task = raptorTask;
    }

    public void setJob(int n) {
        this._jobid = n;
    }

    private void updateFilePercent(int n) {
        try {
            if (this._con != null) {
                if (this._jobid == -1) {
                    String string = "UPDATE \"C##DBAAS_MONITOR\".\"SQLDEV_JOB_FILES\" SET PERCENT_MOVED = ? WHERE FILE_NAME = ?";
                    CallableStatement callableStatement = this._con.prepareCall(string);
                    callableStatement.setInt(1, n);
                    callableStatement.setString(2, this._fo.getDestName());
                    callableStatement.executeUpdate();
                    this._con.commit();
                } else {
                    String string = "UPDATE \"C##DBAAS_MONITOR\".\"SQLDEV_JOB_FILES\" SET PERCENT_MOVED = ? WHERE FILE_NAME = ? AND JOB_ID = ?";
                    CallableStatement callableStatement = this._con.prepareCall(string);
                    callableStatement.setInt(1, n);
                    callableStatement.setString(2, this._fo.getDestName());
                    callableStatement.setInt(3, this._jobid);
                    callableStatement.executeUpdate();
                    this._con.commit();
                }
            }
        }
        catch (Exception exception) {
            try {
                this._con.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (exception instanceof SQLSyntaxErrorException) {
                int n2 = ((SQLSyntaxErrorException)exception).getErrorCode();
                if (n2 != 942) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void updateFileStatus(String string) {
        try {
            if (this._con != null) {
                if (this._jobid == -1) {
                    String string2 = "UPDATE \"C##DBAAS_MONITOR\".\"SQLDEV_JOB_FILES\" SET STATUS = ? WHERE FILE_NAME = ?";
                    CallableStatement callableStatement = this._con.prepareCall(string2);
                    callableStatement.setString(1, string);
                    callableStatement.setString(2, this._fo.getDestName());
                    callableStatement.executeUpdate();
                    this._con.commit();
                } else {
                    String string3 = "UPDATE \"C##DBAAS_MONITOR\".\"SQLDEV_JOB_FILES\" SET STATUS = ? WHERE FILE_NAME = ? AND JOB_ID = ?";
                    CallableStatement callableStatement = this._con.prepareCall(string3);
                    callableStatement.setString(1, string);
                    callableStatement.setString(2, this._fo.getDestName());
                    callableStatement.setInt(3, this._jobid);
                    callableStatement.executeUpdate();
                    this._con.commit();
                }
            }
        }
        catch (Exception exception) {
            try {
                this._con.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (exception instanceof SQLSyntaxErrorException) {
                int n = ((SQLSyntaxErrorException)exception).getErrorCode();
                if (n != 942) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getMessage(), exception);
        }
    }
}

