/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.pdbs;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.utils.Connections;

public abstract class PdbsAction
extends ActionDialog {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected State getState(Connection connection, String string) {
        State state;
        block19: {
            ResultSet resultSet;
            String string2;
            String string3;
            block18: {
                state = State.MOUNTED;
                if (!Connections.getInstance().lock(connection)) break block19;
                string3 = null;
                string2 = null;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("NAME", string);
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                resultSet = null;
                try {
                    resultSet = dBUtil.executeOracleQuery(this.getQuery(connection, "getPdbState"), hashMap);
                    if (resultSet == null) break block18;
                    while (resultSet.next()) {
                        string3 = resultSet.getString("OPEN_MODE");
                        string2 = resultSet.getString("RESTRICTED");
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
            if (string3 != null) {
                switch (string3) {
                    case "MOUNTED": {
                        state = State.MOUNTED;
                        break;
                    }
                    case "READ WRITE": {
                        if (!"YES".equals(string2)) {
                            state = State.READ_WRITE;
                            break;
                        }
                        state = State.READ_WRITE_RESTRICTED;
                        break;
                    }
                    case "READ ONLY": {
                        if (!"YES".equals(string2)) {
                            state = State.READ_ONLY;
                            break;
                        }
                        state = State.READ_ONLY_RESTRICTED;
                        break;
                    }
                    default: {
                        state = State.MIGRATE;
                    }
                }
            }
        }
        return state;
    }

    protected void toggleState(StringBuilder stringBuilder, String string, State state, State state2, String string2) {
        if (state != State.MIGRATE && state2 != State.MIGRATE && state != state2) {
            if (state != State.MOUNTED && state2 != State.MOUNTED) {
                this.addStateChange(stringBuilder, string, State.MOUNTED, string2);
            }
            this.addStateChange(stringBuilder, string, state2, string2);
        }
    }

    private void addStateChange(StringBuilder stringBuilder, String string, State state, String string2) {
        stringBuilder.append("\n" + string2);
        stringBuilder.append("EXECUTE IMMEDIATE 'ALTER PLUGGABLE DATABASE ");
        stringBuilder.append("\"" + string + "\"");
        stringBuilder.append(' ');
        stringBuilder.append(state.getCommand());
        stringBuilder.append(" INSTANCES=ALL';");
    }

    protected static enum State {
        MOUNTED("CLOSE IMMEDIATE"),
        READ_WRITE("OPEN READ WRITE"),
        READ_ONLY("OPEN READ ONLY"),
        READ_WRITE_RESTRICTED("OPEN READ WRITE RESTRICTED"),
        READ_ONLY_RESTRICTED("OPEN READ ONLY RESTRICTED"),
        MIGRATE("UPGRADE");

        private final String command;

        private State(String string2) {
            this.command = string2;
        }

        protected String getCommand() {
            return this.command;
        }
    }
}

