/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.pdbs;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.pdbs.PdbsAction;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.DatabaseFeatureRegistry;

public class ModifyStatePdbsAction
extends PdbsAction {
    private static final String PDB_NAME = "PdbName";
    private static final String PDB_STATE = "PdbState";
    private static final String STATE_OPT = "StateOption";
    private boolean rac;

    protected String getTitle() {
        return DbaNavigatorResources.getString("MODIFY_STATE_TITLE");
    }

    protected List<ActionControl> createControls(Connection connection) {
        ComboBoxActionControl comboBoxActionControl;
        TextBoxActionControl textBoxActionControl;
        this.rac = DatabaseFeatureRegistry.isFeatureEnabled((ConnectionIdentifier)DefaultConnectionIdentifier.createIdentifier((Connection)connection), (String)"multi_instance");
        TextBoxActionControl textBoxActionControl2 = new TextBoxActionControl(PDB_NAME, DbaNavigatorResources.getString("PDB_NAME"), this.getObjectName());
        PdbsAction.State state = this.getState(connection, this.getObjectName());
        if (state == PdbsAction.State.MOUNTED) {
            textBoxActionControl = new TextBoxActionControl(PDB_STATE, DbaNavigatorResources.getString("PDB_STATE"), "OPEN");
            comboBoxActionControl = new ComboBoxActionControl(STATE_OPT, DbaNavigatorResources.getString("PDB_STATE_OPT"), new String[]{"READ WRITE", "READ ONLY", "RESTRICTED"}, "READ WRITE");
        } else {
            textBoxActionControl = new TextBoxActionControl(PDB_STATE, DbaNavigatorResources.getString("PDB_STATE"), "CLOSE");
            comboBoxActionControl = new ComboBoxActionControl(STATE_OPT, DbaNavigatorResources.getString("PDB_STATE_OPT"), new String[]{"NORMAL", "IMMEDIATE"}, "IMMEDIATE");
        }
        textBoxActionControl.setEditable(false);
        textBoxActionControl2.setEditable(false);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl2);
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)comboBoxActionControl);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ALTER PLUGGABLE DATABASE " + values.get(PDB_NAME) + " ");
        stringBuffer.append(values.get(PDB_STATE) + " ");
        if (!values.get(STATE_OPT).equals("NORMAL")) {
            stringBuffer.append(values.get(STATE_OPT));
        }
        if (this.rac) {
            stringBuffer.append(" INSTANCES=ALL");
        }
        return stringBuffer.toString();
    }
}

