/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.pdbs;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.dbtools.util.StreamCopy;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;

public class CloneUtils {
    public static void mkdir(ClientSession clientSession, String string) throws IOException {
        SftpClient sftpClient = CloneUtils.getChannelToSftpServer(clientSession);
        if (sftpClient != null) {
            try {
                sftpClient.mkdir(string);
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage(), iOException);
            }
            finally {
                CloneUtils.disconnectChanneltoSftpServer(sftpClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean pathExists(ClientSession clientSession, String string) throws IOException {
        SftpClient sftpClient = CloneUtils.getChannelToSftpServer(clientSession);
        if (sftpClient != null) {
            try {
                sftpClient.lstat(string);
            }
            catch (IOException iOException) {
                boolean bl = false;
                return bl;
            }
            finally {
                CloneUtils.disconnectChanneltoSftpServer(sftpClient);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rmFile(ClientSession clientSession, String string) throws IOException {
        SftpClient sftpClient = CloneUtils.getChannelToSftpServer(clientSession);
        if (sftpClient != null) {
            try {
                sftpClient.remove(string);
            }
            catch (IOException iOException) {
                boolean bl = false;
                return bl;
            }
            finally {
                CloneUtils.disconnectChanneltoSftpServer(sftpClient);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rmDir(ClientSession clientSession, String string) throws IOException {
        SftpClient sftpClient = CloneUtils.getChannelToSftpServer(clientSession);
        if (sftpClient != null) {
            try {
                sftpClient.rmdir(string);
            }
            catch (IOException iOException) {
                boolean bl = false;
                return bl;
            }
            finally {
                CloneUtils.disconnectChanneltoSftpServer(sftpClient);
            }
        }
        return true;
    }

    public static void disconnectChanneltoSftpServer(SftpClient sftpClient) {
        if (sftpClient != null) {
            try {
                sftpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean isSessionConnected(ClientSession clientSession) {
        return clientSession != null && clientSession.isOpen();
    }

    public static SftpClient getChannelToSftpServer(ClientSession clientSession) throws IOException {
        SftpClient sftpClient = null;
        if (CloneUtils.isSessionConnected(clientSession)) {
            try {
                SftpClientFactory sftpClientFactory = SftpClientFactory.instance();
                sftpClient = sftpClientFactory.createSftpClient(clientSession);
            }
            catch (IOException iOException) {
                throw new IOException("Falied to create channel " + iOException.getMessage());
            }
        }
        return sftpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SftpClient upload(ClientSession clientSession, String string, String string2) throws IOException {
        SftpClient sftpClient = CloneUtils.getChannelToSftpServer(clientSession);
        if (sftpClient != null) {
            try (OutputStream outputStream = sftpClient.write(string2);
                 FileInputStream fileInputStream = new FileInputStream(string);){
                StreamCopy.drain((InputStream)fileInputStream, (OutputStream)outputStream);
            }
            finally {
                CloneUtils.disconnectChanneltoSftpServer(sftpClient);
            }
        }
        return sftpClient;
    }
}

