/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.consumergroups;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class CreateEditAction
extends ActionDialog {
    private static final String GROUP_NAME = "GroupName";
    private static final String DESCRIPTION = "Description";
    private static final String POLICY = "Policy";
    private static final String ROUND_ROBIN = "ROUND-ROBIN";
    private static final String RUN_TO_COMPLETION = "RUN-TO-COMPLETION";

    protected String getTitle() {
        String string = null;
        Operation operation = this.getOperation();
        string = operation == Operation.EDIT ? DbaNavigatorResources.getString("EDIT_CONSUMER_GROUP_TITLE") : DbaNavigatorResources.getString("CREATE_CONSUMER_GROUP_TITLE");
        return string;
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        String[] stringArray;
        DBUtil dBUtil;
        TextBoxActionControl textBoxActionControl;
        Object object;
        boolean bl = false;
        try {
            bl = connection.getMetaData().getDatabaseMajorVersion() == 9;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        Operation operation = this.getOperation();
        String string = this.getObjectName();
        String string2 = DbaNavigatorResources.getString("ENTER_VALUE_PROMPT");
        String string3 = "";
        String string4 = ROUND_ROBIN;
        if (operation != Operation.CREATE_NEW && Connections.getInstance().lock(connection)) {
            object = null;
            try {
                textBoxActionControl = new HashMap();
                textBoxActionControl.put("GROUPNAME", string);
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                object = dBUtil.executeOracleQuery(this.getQuery(connection, "getConsumerGroup"), (Map)textBoxActionControl);
                if (object != null) {
                    while (object.next()) {
                        string3 = object.getString("COMMENTS");
                        string4 = object.getString("CPU_METHOD");
                        if (operation != Operation.EDIT) continue;
                        string2 = string;
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                DBUtil.closeResultSet((ResultSet)object);
                Connections.getInstance().unlock(connection);
            }
        }
        object = new TextBoxActionControl(GROUP_NAME, DbaNavigatorResources.getString("GROUP_NAME_LABEL"), string2);
        textBoxActionControl = new TextBoxActionControl(DESCRIPTION, DbaNavigatorResources.getString("DESCRIPTION_LABEL"), string3);
        String string5 = DbaNavigatorResources.getString("POLICY_LABEL");
        if (bl) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = ROUND_ROBIN;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = ROUND_ROBIN;
            stringArray = stringArray3;
            stringArray3[1] = RUN_TO_COMPLETION;
        }
        dBUtil = new ComboBoxActionControl(POLICY, string5, stringArray, string4);
        if (operation == Operation.EDIT) {
            object.setEditable(false);
        }
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)object);
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)dBUtil);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BEGIN\n");
        stringBuffer.append("    DBMS_RESOURCE_MANAGER.CLEAR_PENDING_AREA();\n");
        stringBuffer.append("    DBMS_RESOURCE_MANAGER.CREATE_PENDING_AREA();\n");
        if (this.getOperation() != Operation.EDIT) {
            stringBuffer.append("    DBMS_RESOURCE_MANAGER.CREATE_CONSUMER_GROUP(\n");
            stringBuffer.append("        CONSUMER_GROUP => '");
            stringBuffer.append(values.get(GROUP_NAME));
            stringBuffer.append("',\n");
            stringBuffer.append("        COMMENT => '");
            stringBuffer.append(values.get(DESCRIPTION));
            stringBuffer.append("',\n");
            stringBuffer.append("        CPU_MTH => '");
            stringBuffer.append(values.get(POLICY));
            stringBuffer.append("');\n");
        } else {
            stringBuffer.append("    DBMS_RESOURCE_MANAGER.UPDATE_CONSUMER_GROUP(\n");
            stringBuffer.append("        CONSUMER_GROUP => '");
            stringBuffer.append(values.get(GROUP_NAME));
            stringBuffer.append("',\n");
            stringBuffer.append("        NEW_COMMENT => '");
            stringBuffer.append(values.get(DESCRIPTION));
            stringBuffer.append("',\n");
            stringBuffer.append("        NEW_CPU_MTH => '");
            stringBuffer.append(values.get(POLICY));
            stringBuffer.append("');\n");
        }
        stringBuffer.append("    DBMS_RESOURCE_MANAGER.SUBMIT_PENDING_AREA();\n");
        stringBuffer.append("END;\n");
        return stringBuffer.toString();
    }

    private static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        EDIT;

    }
}

