/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupjobs;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.backupjobs.TapeBackupControlGroup;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessor;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;

public class CreateTapeBackupAction
extends ActionDialog {
    private boolean noarchiveLogMode;

    protected ScriptProcessor createScriptProcessor() {
        return new RMANScriptProcessor(this);
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("CREATE_TAPE_BACKUP_TITLE");
    }

    protected List<ActionControl> createControls(Connection connection) {
        this.noarchiveLogMode = !DbaUtil.isArchiveLogMode(connection);
        TapeBackupControlGroup tapeBackupControlGroup = new TapeBackupControlGroup(connection);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)tapeBackupControlGroup);
        arrayList.add((ActionControl)new SeperatorActionControl());
        arrayList.add(new RMANScriptProcessorActionControl(connection, "sqldev.rman", !this.noarchiveLogMode));
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        int n = Integer.parseInt(values.get("TAPE_PARALLELISM"));
        int n2 = Integer.parseInt(values.get("RECOVERY_WINDOW"));
        String string = values.get("TAPE_LIBRARY_PARAMS");
        StringBuffer stringBuffer = new StringBuffer();
        if (this.noarchiveLogMode) {
            stringBuffer.append("SHUTDOWN IMMEDIATE;\n");
            stringBuffer.append("STARTUP MOUNT;\n");
        }
        stringBuffer.append("RUN {\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("ALLOCATE CHANNEL SQLDEV_SBT_BACKUP");
            stringBuffer.append(i + 1);
            stringBuffer.append(" TYPE 'SBT_TAPE' FORMAT '%U' PARMS '");
            stringBuffer.append(string);
            stringBuffer.append("';\n");
        }
        stringBuffer.append("BACKUP INCREMENTAL LEVEL 1 CUMULATIVE DATABASE;\n");
        stringBuffer.append("BACKUP ARCHIVELOG ALL NOT BACKED UP;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("ALLOCATE CHANNEL FOR MAINTENANCE DEVICE TYPE 'SBT_TAPE' PARMS '");
        stringBuffer.append(string);
        stringBuffer.append("';\n");
        stringBuffer.append("DELETE NOPROMPT OBSOLETE RECOVERY WINDOW OF ");
        stringBuffer.append(n2);
        stringBuffer.append(" DAYS DEVICE TYPE 'SBT_TAPE';\n");
        if (this.noarchiveLogMode) {
            stringBuffer.append("ALTER DATABASE OPEN;\n");
        }
        return stringBuffer.toString();
    }
}

