/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupjobs;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.backupjobs.DiskEncryptionActionGroup;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessor;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;

public class CreateDiskBackupAction
extends ActionDialog {
    private boolean noarchiveLogMode;

    protected ScriptProcessor createScriptProcessor() {
        return new RMANScriptProcessor(this);
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("CREATE_DISK_BACKUP_TITLE");
    }

    protected List<ActionControl> createControls(Connection connection) {
        this.noarchiveLogMode = !DbaUtil.isArchiveLogMode(connection);
        RMANScriptProcessorActionControl rMANScriptProcessorActionControl = new RMANScriptProcessorActionControl(connection, "sqldev.rman", !this.noarchiveLogMode);
        DiskEncryptionActionGroup diskEncryptionActionGroup = new DiskEncryptionActionGroup(connection, rMANScriptProcessorActionControl);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)diskEncryptionActionGroup);
        arrayList.add((ActionControl)new SeperatorActionControl());
        arrayList.add(rMANScriptProcessorActionControl);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.noarchiveLogMode) {
            stringBuffer.append("SHUTDOWN IMMEDIATE;\n");
            stringBuffer.append("STARTUP MOUNT;\n");
        }
        if (Boolean.parseBoolean(values.get("USE_RMAN_ENCRYPTION"))) {
            String string = values.get("ENCRYPTION_ALGORITHM");
            if (Boolean.parseBoolean(values.get("USE_ENCRYPTION_PASSWORDS"))) {
                stringBuffer.append("SET ENCRYPTION ON FOR ALL TABLESPACES ALGORITHM '");
                stringBuffer.append(string);
                if (values.get("RMANScriptProcessor/Type").equals(RMANScriptProcessorActionControl.RUN_SCHEDULER_JOB)) {
                    String string2 = values.get("PASSWORD_TEXT");
                    stringBuffer.append("' IDENTIFIED BY '");
                    stringBuffer.append(string2);
                    stringBuffer.append("' ONLY;\n");
                    stringBuffer.append("SET DECRYPTION IDENTIFIED BY '");
                    stringBuffer.append(string2);
                    stringBuffer.append("';\n");
                } else {
                    stringBuffer.append("' IDENTIFIED BY '%PASSWORD' ONLY;\n");
                    stringBuffer.append("SET DECRYPTION IDENTIFIED BY '%PASSWORD';\n");
                }
            } else {
                stringBuffer.append("SET ENCRYPTION ON FOR ALL TABLESPACES ALGORITHM '");
                stringBuffer.append(string);
                stringBuffer.append("';\n");
            }
        }
        stringBuffer.append("RUN {\n");
        stringBuffer.append("ALLOCATE CHANNEL SQLDEV_DISK_BACKUP DEVICE TYPE DISK;\n");
        stringBuffer.append("RECOVER COPY OF DATABASE WITH TAG 'ORA_SQLDEV_LEVEL_0';\n");
        stringBuffer.append("BACKUP INCREMENTAL LEVEL 1 CUMULATIVE COPIES=1 FOR RECOVER OF COPY WITH TAG 'ORA_SQLDEV_LEVEL_0' DATABASE;\n");
        stringBuffer.append("}\n");
        if (this.noarchiveLogMode) {
            stringBuffer.append("ALTER DATABASE OPEN;\n");
        }
        return stringBuffer.toString();
    }
}

