/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator;

import oracle.dbtools.raptor.dba.navigator.Databases;
import oracle.dbtools.raptor.dba.navigator.DbaConnection;
import oracle.dbtools.raptor.dba.navigator.DbaNavController;
import oracle.dbtools.raptor.dba.navigator.Messages;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.db.CoreDBNavigatorWindow;
import oracle.dbtools.raptor.navigator.db.DBTreeUpdater;
import oracle.dbtools.raptor.navigator.db.UIUpdater;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.ide.controller.Controller;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;

public class DbaNavWindow
extends CoreDBNavigatorWindow {
    protected DbaNavWindow(ViewId viewId) {
        super(viewId);
    }

    protected Controller createController() {
        return new DbaNavController();
    }

    public String getTabName() {
        return Messages.getString("DbaNavWindow.0");
    }

    public String getTitleName() {
        return Messages.getString("DbaNavWindow.0");
    }

    public void expandVisibleRoot(NavigatorTree navigatorTree) {
        super.expandVisibleRoot(navigatorTree);
        navigatorTree.expand(navigatorTree.getRoot(), false);
    }

    protected Element getRootElement() {
        return Databases.getInstance();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_idedbanavigator_html");
    }

    protected UIUpdater getTreeUpdater() {
        return new DBTreeUpdater("sqldev.dbanav", (NavigatorWindow)this){

            protected NavigatorTreeNode getConnectionNode(String string) {
                DbaConnection dbaConnection = Databases.getConnectionNode(string, false);
                if (dbaConnection == null) {
                    return null;
                }
                NavigatorTree navigatorTree = this.getTree();
                return navigatorTree.findTreeNode((Element)dbaConnection, navigatorTree.getRoot());
            }
        };
    }

    public boolean canCollapse(NavigatorTreeNode navigatorTreeNode) {
        return navigatorTreeNode != this.getTree().getRoot();
    }
}

