/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util.tools;

import java.io.PrintWriter;
import java.sql.SQLException;
import oracle.aurora.util.IndentPrintWriter;
import oracle.aurora.util.tools.AbortException;
import oracle.aurora.util.tools.Jdbc;
import oracle.aurora.util.tools.ToolError;
import oracle.aurora.util.tools.ToolException;
import oracle.aurora.util.tools.ToolLogOptions;

public class ToolLog {
    public static final int UNCOND = 0;
    public static final int FATAL = 1;
    public static final int ERR = 2;
    public static final int WARN = 3;
    public static final int INFO = 4;
    public static final int DEBUG = 5;
    private ToolLogOptions opts;
    private long startTime;
    private long lastTime;
    private int maxLevel = 3;

    public ToolLog() {
        this(new ToolLogOptions());
    }

    public ToolLog(ToolLogOptions opts) {
        this.opts = opts;
        if (opts.getDebug()) {
            this.maxLevel = 5;
        } else if (opts.getVerbose()) {
            this.maxLevel = 4;
        }
    }

    public ToolLogOptions getOpts() {
        return this.opts;
    }

    public IndentPrintWriter getWriter() {
        return this.opts.getWriter();
    }

    public void println(int level, String msg) {
        if (level <= this.maxLevel) {
            this.println(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void println(String msg) {
        String tMsg = null;
        if (this.getOpts().getBoolean("-time")) {
            if (this.startTime == 0L) {
                this.startTime = System.currentTimeMillis();
            }
            long t = System.currentTimeMillis() - this.startTime;
            tMsg = "[" + (double)(t - this.lastTime) / 1000.0 + " sec, " + (double)t / 1000.0 + " sec] " + msg;
            this.lastTime = t;
        }
        if (tMsg != null) {
            this.getWriter().prePush(tMsg);
        }
        try {
            this.getWriter().println(msg);
            this.getWriter().flush();
        }
        finally {
            if (tMsg != null) {
                this.getWriter().pop();
            }
        }
    }

    public void msg(String m) {
        this.println(4, m);
    }

    public void warn(String m) {
        this.println(3, m);
    }

    public void warn(Exception ex, String when) {
        this.err(3, ex, when);
    }

    public void err(String m) {
        this.println(2, m);
    }

    public void failErr(String m) {
        this.println(1, m);
    }

    public void err(Exception ex, String what) {
        this.err(2, ex, what);
    }

    void err(int level, Exception ex, String what) {
        if (ex instanceof SQLException && this.getOpts().getBoolean("-sqlaborts")) {
            SQLException sex = (SQLException)ex;
            if (Jdbc.isUserInterrupt(sex)) {
                throw new AbortException(sex, "interrupted by user");
            }
            if (Jdbc.isLostConnection(sex)) {
                throw new AbortException(sex, "lost connection");
            }
        }
        this.println(what);
        this.println(level, "Exception " + ex.toString());
        if (this.getOpts().getBoolean("-debug") && this.maxLevel >= 5) {
            Throwable exForTrace = ex;
            if (ex instanceof ToolException && ((ToolException)ex).getChain() != null) {
                exForTrace = ((ToolException)ex).getChain();
            } else if (ex instanceof ToolError && ((ToolError)ex).getChain() != null) {
                exForTrace = ((ToolError)ex).getChain();
            }
            exForTrace.printStackTrace(this.getWriter());
        }
        this.getWriter().flush();
    }

    public void setWriter(PrintWriter output) {
        this.getOpts().setOut(output);
    }
}

