/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util.tools;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.aurora.util.tools.OptionFile;
import oracle.aurora.util.tools.ToolError;

public class Options
implements Cloneable {
    private Hashtable hashtable;
    private Options defaultOpts;
    private String[] oneList;
    private String[] twoList;
    private String[] substList;
    private Object[] expandList;
    private OptionFile optionFile;
    private Object unsetValue = new Object(){

        public String toString() {
            return "***UNSET***";
        }
    };

    public Options(String[] oneList, String[] twoList, String[] substList, Object[] expandList, Options defaultOpts) {
        this.defaultOpts = defaultOpts;
        this.hashtable = null;
        this.oneList = oneList == null ? new String[]{} : oneList;
        this.twoList = twoList == null ? new String[]{} : twoList;
        this.substList = substList == null ? new String[]{} : substList;
        this.expandList = expandList == null ? new Object[]{} : expandList;
    }

    public Options(String[] oneList, String[] twoList, String[] abbrevList, Object[] expandList) {
        this(oneList, twoList, abbrevList, expandList, null);
    }

    public Options(Options defaultOpts) {
        this(new String[0], new String[0], new String[0], new Object[0], defaultOpts);
    }

    public Options() {
        this(null);
    }

    public Object clone() {
        try {
            Options copy = (Options)super.clone();
            if (this.hashtable != null) {
                copy.hashtable = (Hashtable)this.hashtable.clone();
            }
            return copy;
        }
        catch (CloneNotSupportedException ex) {
            throw new ToolError(ex.toString());
        }
    }

    public Options clone(Options defaultOpts) {
        Options copy = (Options)this.clone();
        copy.defaultOpts = defaultOpts;
        return copy;
    }

    public void setOptionFile(OptionFile optionFile) {
        this.optionFile = optionFile;
    }

    public Options getOptionsFor(String className) {
        Options newDefault = this.defaultOpts;
        if (newDefault != null) {
            newDefault = newDefault.getOptionsFor(className);
        }
        Options copy = this;
        if (newDefault != this.defaultOpts) {
            copy = copy.clone(newDefault);
        }
        Options specialized = copy;
        if (this.optionFile != null) {
            specialized = this.optionFile.getOptionsFor(className, copy);
        }
        return specialized;
    }

    public Object get(String key) {
        Object result = key == null ? null : (this.hashtable != null && this.hashtable.containsKey(key) ? this.hashtable.get(key) : (this.defaultOpts != null ? this.defaultOpts.get(key) : null));
        if (result == this.unsetValue) {
            result = null;
        }
        return result;
    }

    public String getString(String prop) {
        Object obj = this.get(prop);
        String result = obj == null ? null : obj.toString();
        return result;
    }

    public boolean getBoolean(String prop) {
        Object obj = this.get(prop);
        boolean result = obj == null ? false : (obj instanceof Boolean ? (Boolean)obj : true);
        return result;
    }

    public Object getObject(String prop, Class cl) {
        Object obj = this.get(prop);
        if (cl != null && !cl.isInstance(obj)) {
            obj = null;
        }
        return obj;
    }

    private boolean inOptionList(String s, String[] optionList) {
        if (s == null) {
            return false;
        }
        for (int xOpt = 0; xOpt < optionList.length; ++xOpt) {
            if (!s.equals(optionList[xOpt])) continue;
            return true;
        }
        return false;
    }

    private String checkSubst(String option) {
        String replacement = option;
        int xAbbrv = 0;
        while (xAbbrv + 1 < this.substList.length) {
            if (this.substList[xAbbrv].equals(option)) {
                replacement = this.substList[xAbbrv + 1];
            }
            xAbbrv += 2;
        }
        return replacement;
    }

    private int checkExpand(String option) {
        int found = -1;
        int xOpt = 0;
        while (xOpt + 2 < this.expandList.length && found == -1) {
            if (this.expandList[xOpt].equals(option)) {
                found = xOpt;
            }
            xOpt += 3;
        }
        return found;
    }

    protected int parseArg(String[] argv, int xArgv) {
        return 0;
    }

    void clear() {
        this.hashtable = new Hashtable();
    }

    public void set(String option) {
        int xExpand = this.checkExpand(option = this.checkSubst(option));
        if (xExpand >= 0) {
            this.set((String)this.expandList[xExpand + 1], this.expandList[xExpand + 2]);
        } else {
            this.set(option, Boolean.TRUE);
        }
    }

    public void set(String option, Object value) {
        if (this.hashtable == null) {
            this.hashtable = new Hashtable();
        }
        if ((option = this.checkSubst(option)) != null && value != null) {
            this.hashtable.put(option, value);
        } else if (option != null) {
            this.unset(option);
        }
    }

    void unset(String option) {
        this.set(option, this.unsetValue);
    }

    public String[] parseArgs(String[] argv) {
        Args args = new Args(argv);
        this.parseArgs(args);
        return args.unused();
    }

    public int parseOne(String[] args) {
        return this.parseOne(args, 0);
    }

    public int parseOne(String[] argv, int xArg) {
        int xExpand;
        String option = this.checkSubst(argv[xArg]);
        int incr = this.parseArg(argv, xArg);
        if (incr == 0 && this.inOptionList(option, this.oneList)) {
            this.set(argv[xArg]);
            incr = 1;
        }
        if (incr == 0 && this.inOptionList(option, this.twoList)) {
            if (xArg + 1 < argv.length) {
                this.set(argv[xArg], argv[xArg + 1]);
                incr = 2;
            } else {
                incr = 0;
            }
        }
        if (incr == 0 && (xExpand = this.checkExpand(option)) >= 0) {
            this.set((String)this.expandList[xExpand + 1], this.expandList[xExpand + 2]);
            incr = 1;
        }
        return incr;
    }

    public void parseArgs(Args args) {
        int incr;
        Vector<String> vUnrecognized = new Vector<String>();
        String[] argv = args.argv();
        for (int xArg = 0; xArg < argv.length; xArg += incr) {
            incr = this.parseOne(argv, xArg);
            args.markUsed(xArg, xArg + incr);
            if (incr != 0) continue;
            vUnrecognized.addElement(argv[xArg]);
            incr = 1;
        }
    }

    public String toString() {
        String result = this.hashtable == null ? "{ }" : this.hashtable.toString();
        if (this.defaultOpts != null) {
            result = result + "->" + this.defaultOpts.toString();
        }
        return result;
    }

    public boolean isParseArg(String option) {
        boolean is = this.inOptionList(option = this.checkSubst(option), this.oneList) || this.inOptionList(option, this.twoList) || this.checkExpand(option) >= 0;
        return is;
    }

    public boolean isProperty(String option) {
        boolean is;
        boolean bl = is = this.inOptionList(option, this.oneList) || this.inOptionList(option, this.twoList);
        if (!is) {
            int xOpt = 0;
            while (xOpt + 2 < this.expandList.length && !is) {
                is = this.expandList[xOpt + 1].equals(option);
                xOpt += 3;
            }
        }
        return is;
    }

    public static void printArgs(String what, String[] argv) {
        System.out.print(what + ": ");
        for (int x = 0; x < argv.length; ++x) {
            System.out.print(argv[x] + " ");
        }
        System.out.println();
    }

    Enumeration allSetProperties() {
        if (this.hashtable == null) {
            this.hashtable = new Hashtable();
        }
        return this.hashtable.keys();
    }

    Options map(Mapper mapper) {
        Options d = this.defaultOpts;
        if (d != null) {
            d = d.map(mapper);
        }
        if (d != this.defaultOpts) {
            Options options = this.clone(d);
        }
        return mapper.map(this);
    }

    static interface OptionOverride {
        public Options getOptionsFor(String var1, Options var2);
    }

    static interface Mapper {
        public Options map(Options var1);
    }

    public static class Args {
        String[] argv_;
        boolean[] used;

        public Args(String[] argv) {
            if (argv == null) {
                argv = new String[]{};
            }
            this.argv_ = new String[argv.length];
            System.arraycopy(argv, 0, this.argv_, 0, argv.length);
            this.used = new boolean[argv.length];
        }

        public String get(int x) {
            return this.argv_[x];
        }

        public String[] argv() {
            return this.argv_;
        }

        public int length() {
            return this.argv_.length;
        }

        public boolean isUsed(int x) {
            return this.used[x];
        }

        public void markUsed(int beg, int end) {
            for (int x = beg; x < end; ++x) {
                if (x < 0 || x >= this.used.length) continue;
                this.used[x] = true;
            }
        }

        public void markUsed(int x) {
            this.markUsed(x, x + 1);
        }

        public String[] unused() {
            Vector<String> vStrings = new Vector<String>();
            for (int xArg = 0; xArg < this.length(); ++xArg) {
                if (this.isUsed(xArg)) continue;
                vStrings.addElement(this.get(xArg));
            }
            Object[] strings = new String[vStrings.size()];
            vStrings.copyInto(strings);
            return strings;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("<");
            for (int xArg = 0; xArg < this.length(); ++xArg) {
                buf.append("'").append(this.get(xArg)).append("'");
                if (this.isUsed(xArg)) {
                    buf.append('*');
                }
                if (xArg + 1 >= this.length()) continue;
                buf.append(',');
            }
            return buf.toString();
        }
    }
}

