/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import oracle.aurora.util.Cursor;
import oracle.aurora.util.DynaHash;
import oracle.aurora.util.Identifier;
import oracle.aurora.util.MapCursor;

public class Dictionary {
    private static final Identifier id = new Identifier(){

        public int hash(Object obj) {
            return ((Entry)obj).key.hashCode();
        }

        public int findHash(Object key) {
            return key.hashCode();
        }

        public boolean identify(Object obj1, Object obj2) {
            Entry e1 = (Entry)obj1;
            Entry e2 = (Entry)obj2;
            return e1.key.equals(e2.key);
        }

        public boolean findIdentify(Object obj1, Object obj2) {
            return obj1.equals(obj2);
        }
    };
    private DynaHash table = new DynaHash(id);

    public Cursor elements() {
        return new Elements(this.table);
    }

    public boolean isEmpty() {
        return this.table.size() == 0;
    }

    public Cursor keys() {
        return new Keys(this.table);
    }

    public Object get(Object key) {
        Object value = null;
        Entry e = (Entry)this.table.find(key);
        if (e != null) {
            value = e.value;
        }
        return value;
    }

    public Object put(Object key, Object value) {
        Entry old = (Entry)this.table.replace(new Entry(key, value));
        Object result = null;
        if (old != null) {
            result = old.value;
        }
        return result;
    }

    public Object remove(Object key) {
        Entry old = (Entry)this.table.remove(new Entry(key, null));
        Object result = null;
        if (old != null) {
            result = old.value;
        }
        return result;
    }

    public Cursor enumerate() {
        return this.table.enumerate();
    }

    static class Keys
    extends MapCursor {
        Keys(DynaHash table) {
            super(table.enumerate());
        }

        public Object transform(Object obj) {
            return ((Entry)obj).key;
        }
    }

    static class Elements
    extends MapCursor {
        Elements(DynaHash table) {
            super(table.enumerate());
        }

        public Object transform(Object obj) {
            return ((Entry)obj).value;
        }
    }

    public static class Entry {
        public Object key;
        public Object value;

        public Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

