/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.PrintWriter;
import java.util.Hashtable;
import oracle.aurora.util.Assertion;
import oracle.aurora.util.BTree;
import oracle.aurora.util.Comparator;
import oracle.aurora.util.Iterator;
import oracle.aurora.util.Random;
import oracle.aurora.util.TestObj;

class BTreeTest {
    static final short INODE_ORDER = 5;
    static final short LNODE_ORDER = 5;
    static final int NITERS = 101;

    BTreeTest() {
    }

    public static void main(String[] args) {
        TestObj[] tobjs = new TestObj[101];
        for (int i = 0; i < 101; ++i) {
            tobjs[i] = new TestObj();
        }
        Hashtable<TestObj, TestObj> htab = new Hashtable<TestObj, TestObj>(101);
        Random rnd = new Random(0L);
        Comparator comp = new Comparator(){

            public int compare(Object obj1, Object obj2) {
                return obj1.hashCode() - obj2.hashCode();
            }
        };
        BTree.oassert.setSuppressionLevel(2);
        Object bogus = null;
        final BTree tree = new BTree(comp, BTree.DEF_PRINTER, 5, 5);
        PrintWriter out = new PrintWriter(System.out);
        for (int i = 0; i < 101; ++i) {
            int idx = Math.abs(rnd.nextInt() % 101);
            System.out.print(" " + i + "[" + tobjs[idx].hashCode() + "]");
            TestObj result = (TestObj)tree.insert(tobjs[idx]);
            tree.checkIntegrity();
            Assertion.oassert(htab.get(tobjs[idx]) == null == (result == null));
            htab.put(tobjs[idx], tobjs[idx]);
        }
        System.out.println();
        tree.printOn(out);
        Assertion.oassert(htab.size() == tree.size());
        final int[] count = new int[1];
        final Object[] last = new Object[1];
        Iterator itr = new Iterator(){

            public void eval(Object obj) {
                if (count[0] > 0) {
                    Assertion.oassert(tree.comparator.compare(last[0], obj) < 0);
                }
                count[0] = count[0] + 1;
                last[0] = obj;
            }
        };
        tree.iterate(itr);
        Assertion.oassert(count[0] == htab.size());
        int i = 0;
        while (i++ < htab.size()) {
            int idx;
            while (tobjs[idx = Math.abs(rnd.nextInt() % 101)] == null || htab.get(tobjs[idx]) == null) {
            }
            TestObj tobj = tobjs[idx];
            tobjs[idx] = null;
            System.out.print(" " + (i - 1) + "[" + tobj.hashCode() + "]");
            Assertion.oassert(tree.contains(tobj));
            Assertion.oassert(tree.find(tobj) == tobj);
            Assertion.oassert(tree.replace(tobj) == tobj);
            Assertion.oassert(tree.remove(tobj) == tobj);
            Assertion.oassert(!tree.contains(tobj));
            Assertion.oassert(tree.size() == htab.size() - i);
            tree.checkIntegrity();
            count[0] = 0;
            last[0] = null;
            tree.iterate(itr);
        }
        Assertion.oassert(tree.size() == 0);
    }
}

