/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import oracle.aurora.server.tools.loadjava.ByteCode;

public final class ByteCodeReader {
    protected byte[] _code;
    protected int _index;

    public ByteCodeReader(byte[] code, int offset) {
        this._code = code;
        this._index = offset;
    }

    public ByteCodeReader(byte[] code) {
        this(code, 0);
    }

    public void setOffset(int offset) {
        this._index = offset;
    }

    public boolean hasNext() {
        return this._index < this._code.length;
    }

    public static int byte2Int(byte bite) {
        int i = bite & 0xFF;
        return i;
    }

    public void readNextByteCode(ByteCode byteCode) {
        int opcode = ByteCodeReader.byte2Int(this._code[this._index]);
        int argsSize = ByteCode.getOperandLength(opcode);
        boolean isWide = opcode == 196;
        int start = this._index++;
        if (isWide) {
            opcode = ByteCodeReader.byte2Int(this._code[this._index]);
            argsSize = ByteCode.getOperandLength(opcode) * 2;
        }
        ++this._index;
        if (ByteCode.getOpcodeType(opcode) == 14) {
            argsSize = opcode == 170 ? this.readSwitchTableSize(this._code, start) : this.readSwitchLookupSize(this._code, start);
        }
        this._index += argsSize;
        byteCode.set(opcode, this._code, start, argsSize, isWide);
    }

    public void reset() {
        this._index = 0;
    }

    public SwitchTableInfo readSwitchInfo(ByteCode switchCode, byte[] code, int index) {
        if (switchCode.getOpcode() == 170) {
            return this.readSwitchTableInfo(code, index);
        }
        return this.readSwitchLookupInfo(code, index);
    }

    public SwitchTableInfo readSwitchLookupInfo(byte[] code, int index) {
        int start = index + 1;
        start = start + 3 & 0xFFFFFFFC;
        int default_offset = ByteCodeReader.byte2Int(code[start]) << 24 | ByteCodeReader.byte2Int(code[start + 1]) << 16 | ByteCodeReader.byte2Int(code[start + 2]) << 8 | ByteCodeReader.byte2Int(code[start + 3]);
        default_offset += index;
        int nPairs = ByteCodeReader.byte2Int(code[start += 4]) << 24 | ByteCodeReader.byte2Int(code[start + 1]) << 16 | ByteCodeReader.byte2Int(code[start + 2]) << 8 | ByteCodeReader.byte2Int(code[start + 3]);
        start += 4;
        int[] jumpTable = new int[nPairs];
        int[] matchTable = new int[nPairs];
        for (int i = 0; i < nPairs; ++i) {
            int match = ByteCodeReader.byte2Int(code[start]) << 24 | ByteCodeReader.byte2Int(code[start + 1]) << 16 | ByteCodeReader.byte2Int(code[start + 2]) << 8 | ByteCodeReader.byte2Int(code[start + 3]);
            int target = ByteCodeReader.byte2Int(code[start += 4]) << 24 | ByteCodeReader.byte2Int(code[start + 1]) << 16 | ByteCodeReader.byte2Int(code[start + 2]) << 8 | ByteCodeReader.byte2Int(code[start + 3]);
            start += 4;
            jumpTable[i] = index + target;
            matchTable[i] = match;
        }
        SwitchTableInfo returnVal = new SwitchTableInfo();
        returnVal._jumpTable = jumpTable;
        returnVal._matchTable = matchTable;
        returnVal._defaultOffset = default_offset;
        returnVal._argsSize = start - index - 1;
        return returnVal;
    }

    public int readSwitchLookupSize(byte[] code, int index) {
        int start = index + 1;
        start = start + 3 & 0xFFFFFFFC;
        int nPairs = ByteCodeReader.byte2Int(code[start += 4]) << 24 | ByteCodeReader.byte2Int(code[start + 1]) << 16 | ByteCodeReader.byte2Int(code[start + 2]) << 8 | ByteCodeReader.byte2Int(code[start + 3]);
        start += 4;
        return (start += 8 * nPairs) - index - 1;
    }

    public SwitchTableInfo readSwitchTableInfo(byte[] code, int index) {
        int start = index + 1;
        start = start + 3 & 0xFFFFFFFC;
        int default_offset = ByteCodeReader.byte2Int(code[start]) << 24 | ByteCodeReader.byte2Int(code[start + 1]) << 16 | ByteCodeReader.byte2Int(code[start + 2]) << 8 | ByteCodeReader.byte2Int(code[start + 3]);
        default_offset += index;
        int low = ByteCodeReader.byte2Int(code[start += 4]) << 24 | ByteCodeReader.byte2Int(code[start + 1]) << 16 | ByteCodeReader.byte2Int(code[start + 2]) << 8 | ByteCodeReader.byte2Int(code[start + 3]);
        int high = ByteCodeReader.byte2Int(code[start += 4]) << 24 | ByteCodeReader.byte2Int(code[start + 1]) << 16 | ByteCodeReader.byte2Int(code[start + 2]) << 8 | ByteCodeReader.byte2Int(code[start + 3]);
        start += 4;
        int[] jumpTable = new int[high - low + 1];
        for (int j = 0; j < jumpTable.length; ++j) {
            int target = ByteCodeReader.byte2Int(code[start]) << 24 | ByteCodeReader.byte2Int(code[start + 1]) << 16 | ByteCodeReader.byte2Int(code[start + 2]) << 8 | ByteCodeReader.byte2Int(code[start + 3]);
            start += 4;
            jumpTable[j] = index + target;
        }
        SwitchTableInfo returnVal = new SwitchTableInfo();
        returnVal._low = low;
        returnVal._high = high;
        returnVal._jumpTable = jumpTable;
        returnVal._defaultOffset = default_offset;
        returnVal._argsSize = start - index - 1;
        return returnVal;
    }

    public int readSwitchTableSize(byte[] code, int index) {
        int start = index + 1;
        start = start + 3 & 0xFFFFFFFC;
        int low = ByteCodeReader.byte2Int(code[start += 4]) << 24 | ByteCodeReader.byte2Int(code[start + 1]) << 16 | ByteCodeReader.byte2Int(code[start + 2]) << 8 | ByteCodeReader.byte2Int(code[start + 3]);
        int high = ByteCodeReader.byte2Int(code[start += 4]) << 24 | ByteCodeReader.byte2Int(code[start + 1]) << 16 | ByteCodeReader.byte2Int(code[start + 2]) << 8 | ByteCodeReader.byte2Int(code[start + 3]);
        start += 4;
        return (start += (high - low + 1) * 4) - index - 1;
    }

    public static final class SwitchTableInfo {
        int _low;
        int _high;
        int[] _matchTable;
        int[] _jumpTable;
        int _defaultOffset;
        int _argsSize;

        SwitchTableInfo() {
        }

        public boolean isLookupSwitch() {
            return this._matchTable != null;
        }
    }
}

