/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import oracle.aurora.server.tools.loadjava.ByteCodeReader;

public final class ByteCode {
    public static final int OP_AALOAD = 50;
    public static final int OP_AASTORE = 83;
    public static final int OP_ACONST_NULL = 1;
    public static final int OP_ALOAD = 25;
    public static final int OP_ALOAD_0 = 42;
    public static final int OP_ALOAD_1 = 43;
    public static final int OP_ALOAD_2 = 44;
    public static final int OP_ALOAD_3 = 45;
    public static final int OP_ANEWARRAY = 189;
    public static final int OP_ARETURN = 176;
    public static final int OP_ARRAYLENGTH = 190;
    public static final int OP_ASTORE = 58;
    public static final int OP_ASTORE_0 = 75;
    public static final int OP_ASTORE_1 = 76;
    public static final int OP_ASTORE_2 = 77;
    public static final int OP_ASTORE_3 = 78;
    public static final int OP_ATHROW = 191;
    public static final int OP_BALOAD = 51;
    public static final int OP_BASTORE = 84;
    public static final int OP_BIPUSH = 16;
    public static final int OP_BREAKPOINT = 202;
    public static final int OP_CALOAD = 52;
    public static final int OP_CASTORE = 85;
    public static final int OP_CHECKCAST = 192;
    public static final int OP_D2F = 144;
    public static final int OP_D2I = 142;
    public static final int OP_D2L = 143;
    public static final int OP_DADD = 99;
    public static final int OP_DALOAD = 49;
    public static final int OP_DASTORE = 82;
    public static final int OP_DCMPG = 152;
    public static final int OP_DCMPL = 151;
    public static final int OP_DCONST_0 = 14;
    public static final int OP_DCONST_1 = 15;
    public static final int OP_DDIV = 111;
    public static final int OP_DLOAD = 24;
    public static final int OP_DLOAD_0 = 38;
    public static final int OP_DLOAD_1 = 39;
    public static final int OP_DLOAD_2 = 40;
    public static final int OP_DLOAD_3 = 41;
    public static final int OP_DMUL = 107;
    public static final int OP_DNEG = 119;
    public static final int OP_DREM = 115;
    public static final int OP_DRETURN = 175;
    public static final int OP_DSTORE = 57;
    public static final int OP_DSTORE_0 = 71;
    public static final int OP_DSTORE_1 = 72;
    public static final int OP_DSTORE_2 = 73;
    public static final int OP_DSTORE_3 = 74;
    public static final int OP_DSUB = 103;
    public static final int OP_DUP = 89;
    public static final int OP_DUP2 = 92;
    public static final int OP_DUP2_X1 = 93;
    public static final int OP_DUP2_X2 = 94;
    public static final int OP_DUP_X1 = 90;
    public static final int OP_DUP_X2 = 91;
    public static final int OP_F2D = 141;
    public static final int OP_F2I = 139;
    public static final int OP_F2L = 140;
    public static final int OP_FADD = 98;
    public static final int OP_FALOAD = 48;
    public static final int OP_FASTORE = 81;
    public static final int OP_FCMPG = 150;
    public static final int OP_FCMPL = 149;
    public static final int OP_FCONST_0 = 11;
    public static final int OP_FCONST_1 = 12;
    public static final int OP_FCONST_2 = 13;
    public static final int OP_FDIV = 110;
    public static final int OP_FLOAD = 23;
    public static final int OP_FLOAD_0 = 34;
    public static final int OP_FLOAD_1 = 35;
    public static final int OP_FLOAD_2 = 36;
    public static final int OP_FLOAD_3 = 37;
    public static final int OP_FMUL = 106;
    public static final int OP_FNEG = 118;
    public static final int OP_FREM = 114;
    public static final int OP_FRETURN = 174;
    public static final int OP_FSTORE = 56;
    public static final int OP_FSTORE_0 = 67;
    public static final int OP_FSTORE_1 = 68;
    public static final int OP_FSTORE_2 = 69;
    public static final int OP_FSTORE_3 = 70;
    public static final int OP_FSUB = 102;
    public static final int OP_GETFIELD = 180;
    public static final int OP_GETSTATIC = 178;
    public static final int OP_GOTO = 167;
    public static final int OP_GOTO_W = 200;
    public static final int OP_I2D = 135;
    public static final int OP_I2F = 134;
    public static final int OP_I2L = 133;
    public static final int OP_IADD = 96;
    public static final int OP_IALOAD = 46;
    public static final int OP_IAND = 126;
    public static final int OP_IASTORE = 79;
    public static final int OP_ICONST_0 = 3;
    public static final int OP_ICONST_1 = 4;
    public static final int OP_ICONST_2 = 5;
    public static final int OP_ICONST_3 = 6;
    public static final int OP_ICONST_4 = 7;
    public static final int OP_ICONST_5 = 8;
    public static final int OP_ICONST_M1 = 2;
    public static final int OP_IDIV = 108;
    public static final int OP_IF_ACMPEQ = 165;
    public static final int OP_IF_ACMPNE = 166;
    public static final int OP_IF_ICMPEQ = 159;
    public static final int OP_IF_ICMPGE = 162;
    public static final int OP_IF_ICMPGT = 163;
    public static final int OP_IF_ICMPLE = 164;
    public static final int OP_IF_ICMPLT = 161;
    public static final int OP_IF_ICMPNE = 160;
    public static final int OP_IFEQ = 153;
    public static final int OP_IFGE = 156;
    public static final int OP_IFGT = 157;
    public static final int OP_IFLE = 158;
    public static final int OP_IFLT = 155;
    public static final int OP_IFNE = 154;
    public static final int OP_IFNONNULL = 199;
    public static final int OP_IFNULL = 198;
    public static final int OP_IINC = 132;
    public static final int OP_ILOAD = 21;
    public static final int OP_ILOAD_0 = 26;
    public static final int OP_ILOAD_1 = 27;
    public static final int OP_ILOAD_2 = 28;
    public static final int OP_ILOAD_3 = 29;
    public static final int OP_IMUL = 104;
    public static final int OP_INEG = 116;
    public static final int OP_INSTANCEOF = 193;
    public static final int OP_INT2BYTE = 145;
    public static final int OP_INT2CHAR = 146;
    public static final int OP_INT2SHORT = 147;
    public static final int OP_I2B = 145;
    public static final int OP_I2C = 146;
    public static final int OP_I2S = 147;
    public static final int OP_INVOKEINTERFACE = 185;
    public static final int OP_INVOKESPECIAL = 183;
    public static final int OP_INVOKESTATIC = 184;
    public static final int OP_INVOKEVIRTUAL = 182;
    public static final int OP_IOR = 128;
    public static final int OP_IREM = 112;
    public static final int OP_IRETURN = 172;
    public static final int OP_ISHL = 120;
    public static final int OP_ISHR = 122;
    public static final int OP_ISTORE = 54;
    public static final int OP_ISTORE_0 = 59;
    public static final int OP_ISTORE_1 = 60;
    public static final int OP_ISTORE_2 = 61;
    public static final int OP_ISTORE_3 = 62;
    public static final int OP_ISUB = 100;
    public static final int OP_IUSHR = 124;
    public static final int OP_IXOR = 130;
    public static final int OP_JSR = 168;
    public static final int OP_JSR_W = 201;
    public static final int OP_L2D = 138;
    public static final int OP_L2F = 137;
    public static final int OP_L2I = 136;
    public static final int OP_LADD = 97;
    public static final int OP_LALOAD = 47;
    public static final int OP_LAND = 127;
    public static final int OP_LASTORE = 80;
    public static final int OP_LCMP = 148;
    public static final int OP_LCONST_0 = 9;
    public static final int OP_LCONST_1 = 10;
    public static final int OP_LDC = 18;
    public static final int OP_LDC_W = 19;
    public static final int OP_LDC2_W = 20;
    public static final int OP_LDIV = 109;
    public static final int OP_LLOAD = 22;
    public static final int OP_LLOAD_0 = 30;
    public static final int OP_LLOAD_1 = 31;
    public static final int OP_LLOAD_2 = 32;
    public static final int OP_LLOAD_3 = 33;
    public static final int OP_LMUL = 105;
    public static final int OP_LNEG = 117;
    public static final int OP_LOOKUPSWITCH = 171;
    public static final int OP_LOR = 129;
    public static final int OP_LREM = 113;
    public static final int OP_LRETURN = 173;
    public static final int OP_LSHL = 121;
    public static final int OP_LSHR = 123;
    public static final int OP_LSTORE = 55;
    public static final int OP_LSTORE_0 = 63;
    public static final int OP_LSTORE_1 = 64;
    public static final int OP_LSTORE_2 = 65;
    public static final int OP_LSTORE_3 = 66;
    public static final int OP_LSUB = 101;
    public static final int OP_LUSHR = 125;
    public static final int OP_LXOR = 131;
    public static final int OP_MONITORENTER = 194;
    public static final int OP_MONITOREXIT = 195;
    public static final int OP_MULTIANEWARRAY = 197;
    public static final int OP_NEW = 187;
    public static final int OP_NEWARRAY = 188;
    public static final int OP_NOP = 0;
    public static final int OP_POP = 87;
    public static final int OP_POP2 = 88;
    public static final int OP_PUTFIELD = 181;
    public static final int OP_PUTSTATIC = 179;
    public static final int OP_RET = 169;
    public static final int OP_RETURN = 177;
    public static final int OP_SALOAD = 53;
    public static final int OP_SASTORE = 86;
    public static final int OP_SIPUSH = 17;
    public static final int OP_SWAP = 95;
    public static final int OP_TABLESWITCH = 170;
    public static final int OP_WIDE = 196;
    public static final int NONE = 0;
    public static final int I = 1;
    public static final int II = 2;
    public static final int ARRAYTYPE = 3;
    public static final int BIGCONSTANT = 4;
    public static final int CONSTANT = 5;
    public static final int CLASS = 6;
    public static final int FIELD = 7;
    public static final int IGNORE = 8;
    public static final int INTERFACE = 9;
    public static final int LABEL = 10;
    public static final int LABEL_W = 11;
    public static final int METHOD = 12;
    public static final int MARRAY = 13;
    public static final int SWITCH = 14;
    protected static final OpcodeInfo[] _opcodeInfoTable = new OpcodeInfo[256];
    int _opcode;
    byte[] _code;
    int _byteOffset;
    int _argsOffset;
    int _argsSize;
    boolean _isWide;

    public void set(int opcode, byte[] code, int byteOffset, int argsSize, boolean isWide) {
        this._opcode = opcode;
        this._code = code;
        this._byteOffset = byteOffset;
        this._argsOffset = byteOffset + 1 + (isWide ? 1 : 0);
        this._argsSize = argsSize;
        this._isWide = isWide;
    }

    public String getMnemonic() {
        return ByteCode.getMnemonic(this._opcode);
    }

    public int getOpcode() {
        return this._opcode;
    }

    protected static OpcodeInfo getOpcodeInfo(int opcode) {
        OpcodeInfo info = _opcodeInfoTable[opcode];
        if (info == null) {
            throw new IllegalStateException("Opcode not recognized: " + opcode);
        }
        return info;
    }

    public static String getMnemonic(int opcode) {
        return ByteCode.getOpcodeInfo((int)opcode)._mnemonic;
    }

    public int getOpcodeType() {
        return ByteCode.getOpcodeType(this._opcode);
    }

    public static int getOperandLength(int opcode) {
        return ByteCode.getOpcodeInfo((int)opcode)._operandLength;
    }

    public static int getOpcodeType(int opcode) {
        return ByteCode.getOpcodeInfo((int)opcode)._opcodeType;
    }

    public int getArgCount() {
        return this._argsSize;
    }

    public int getByteOffset() {
        return this._byteOffset;
    }

    public int getNextByteOffset() {
        return this._byteOffset + 1 + this._argsSize + (this._isWide ? 1 : 0);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._byteOffset + ":\t" + this.getMnemonic());
        if (this._argsSize == 2) {
            sb.append("\t" + this.getArgsAsLocalVarIndex());
        }
        return sb.toString();
    }

    public int getArgsAsLocalVarIndex() {
        return this.getArgsAsCPIndex();
    }

    public int getArgsAsCPIndex() {
        int result = ByteCodeReader.byte2Int(this._code[this._argsOffset]);
        if (this._argsSize >= 2 || this._isWide) {
            result = result << 8 | ByteCodeReader.byte2Int(this._code[this._argsOffset + 1]);
        }
        return result;
    }

    public int getArgAt(int offset) {
        int result = ByteCodeReader.byte2Int(this._code[this._argsOffset + offset]);
        if (this._isWide) {
            result = result << 8 | ByteCodeReader.byte2Int(this._code[this._argsOffset + offset + 1]);
        }
        return result;
    }

    public int getByteValueAt(int offset) {
        return this._code[this._argsOffset + offset];
    }

    public int getShortValueAt(int offset) {
        int shortVal = this._code[this._argsOffset + offset];
        shortVal = shortVal << 8 | ByteCodeReader.byte2Int(this._code[this._argsOffset + offset + 1]);
        return shortVal;
    }

    public int getUnsignedShortValueAt(int offset) {
        int shortVal = ByteCodeReader.byte2Int(this._code[this._argsOffset + offset]);
        shortVal = shortVal << 8 | ByteCodeReader.byte2Int(this._code[this._argsOffset + offset + 1]);
        return shortVal;
    }

    public int get2ArgsAsLabel() {
        int result = this._code[this._argsOffset];
        if (this._argsSize >= 2) {
            result = result << 8 | ByteCodeReader.byte2Int(this._code[this._argsOffset + 1]);
        }
        return result + this._byteOffset;
    }

    public int get2or4ArgsAsLabel() {
        int result = this._code[this._argsOffset];
        if (this._argsSize >= 4) {
            result = result << 24 | ByteCodeReader.byte2Int(this._code[this._argsOffset + 1]) << 16 | ByteCodeReader.byte2Int(this._code[this._argsOffset + 2]) << 8 | ByteCodeReader.byte2Int(this._code[this._argsOffset + 3]);
        } else if (this._argsSize >= 2) {
            result = result << 8 | ByteCodeReader.byte2Int(this._code[this._argsOffset + 1]);
        }
        return result + this._byteOffset;
    }

    static {
        ByteCode._opcodeInfoTable[50] = new OpcodeInfo(50, "aaload", 0, 0);
        ByteCode._opcodeInfoTable[83] = new OpcodeInfo(83, "aastore", 0, 0);
        ByteCode._opcodeInfoTable[1] = new OpcodeInfo(1, "aconst_null", 0, 0);
        ByteCode._opcodeInfoTable[25] = new OpcodeInfo(25, "aload", 1, 1);
        ByteCode._opcodeInfoTable[42] = new OpcodeInfo(42, "aload_0", 0, 0);
        ByteCode._opcodeInfoTable[43] = new OpcodeInfo(43, "aload_1", 0, 0);
        ByteCode._opcodeInfoTable[44] = new OpcodeInfo(44, "aload_2", 0, 0);
        ByteCode._opcodeInfoTable[45] = new OpcodeInfo(45, "aload_3", 0, 0);
        ByteCode._opcodeInfoTable[189] = new OpcodeInfo(189, "anewarray", 6, 2);
        ByteCode._opcodeInfoTable[176] = new OpcodeInfo(176, "areturn", 0, 0);
        ByteCode._opcodeInfoTable[190] = new OpcodeInfo(190, "arraylength", 0, 0);
        ByteCode._opcodeInfoTable[58] = new OpcodeInfo(58, "astore", 1, 1);
        ByteCode._opcodeInfoTable[75] = new OpcodeInfo(75, "astore_0", 0, 0);
        ByteCode._opcodeInfoTable[76] = new OpcodeInfo(76, "astore_1", 0, 0);
        ByteCode._opcodeInfoTable[77] = new OpcodeInfo(77, "astore_2", 0, 0);
        ByteCode._opcodeInfoTable[78] = new OpcodeInfo(78, "astore_3", 0, 0);
        ByteCode._opcodeInfoTable[191] = new OpcodeInfo(191, "athrow", 0, 0);
        ByteCode._opcodeInfoTable[51] = new OpcodeInfo(51, "baload", 0, 0);
        ByteCode._opcodeInfoTable[84] = new OpcodeInfo(84, "bastore", 0, 0);
        ByteCode._opcodeInfoTable[16] = new OpcodeInfo(16, "bipush", 1, 1);
        ByteCode._opcodeInfoTable[202] = new OpcodeInfo(202, "breakpoint", 0, 0);
        ByteCode._opcodeInfoTable[52] = new OpcodeInfo(52, "caload", 0, 0);
        ByteCode._opcodeInfoTable[85] = new OpcodeInfo(85, "castore", 0, 0);
        ByteCode._opcodeInfoTable[192] = new OpcodeInfo(192, "checkcast", 6, 2);
        ByteCode._opcodeInfoTable[144] = new OpcodeInfo(144, "d2f", 0, 0);
        ByteCode._opcodeInfoTable[142] = new OpcodeInfo(142, "d2i", 0, 0);
        ByteCode._opcodeInfoTable[143] = new OpcodeInfo(143, "d2l", 0, 0);
        ByteCode._opcodeInfoTable[99] = new OpcodeInfo(99, "dadd", 0, 0);
        ByteCode._opcodeInfoTable[49] = new OpcodeInfo(49, "daload", 0, 0);
        ByteCode._opcodeInfoTable[82] = new OpcodeInfo(82, "dastore", 0, 0);
        ByteCode._opcodeInfoTable[152] = new OpcodeInfo(152, "dcmpg", 0, 0);
        ByteCode._opcodeInfoTable[151] = new OpcodeInfo(151, "dcmpl", 0, 0);
        ByteCode._opcodeInfoTable[14] = new OpcodeInfo(14, "dconst_0", 0, 0);
        ByteCode._opcodeInfoTable[15] = new OpcodeInfo(15, "dconst_1", 0, 0);
        ByteCode._opcodeInfoTable[111] = new OpcodeInfo(111, "ddiv", 0, 0);
        ByteCode._opcodeInfoTable[24] = new OpcodeInfo(24, "dload", 1, 1);
        ByteCode._opcodeInfoTable[38] = new OpcodeInfo(38, "dload_0", 0, 0);
        ByteCode._opcodeInfoTable[39] = new OpcodeInfo(39, "dload_1", 0, 0);
        ByteCode._opcodeInfoTable[40] = new OpcodeInfo(40, "dload_2", 0, 0);
        ByteCode._opcodeInfoTable[41] = new OpcodeInfo(41, "dload_3", 0, 0);
        ByteCode._opcodeInfoTable[107] = new OpcodeInfo(107, "dmul", 0, 0);
        ByteCode._opcodeInfoTable[119] = new OpcodeInfo(119, "dneg", 0, 0);
        ByteCode._opcodeInfoTable[115] = new OpcodeInfo(115, "drem", 0, 0);
        ByteCode._opcodeInfoTable[175] = new OpcodeInfo(175, "dreturn", 0, 0);
        ByteCode._opcodeInfoTable[57] = new OpcodeInfo(57, "dstore", 1, 1);
        ByteCode._opcodeInfoTable[71] = new OpcodeInfo(71, "dstore_0", 0, 0);
        ByteCode._opcodeInfoTable[72] = new OpcodeInfo(72, "dstore_1", 0, 0);
        ByteCode._opcodeInfoTable[73] = new OpcodeInfo(73, "dstore_2", 0, 0);
        ByteCode._opcodeInfoTable[74] = new OpcodeInfo(74, "dstore_3", 0, 0);
        ByteCode._opcodeInfoTable[103] = new OpcodeInfo(103, "dsub", 0, 0);
        ByteCode._opcodeInfoTable[89] = new OpcodeInfo(89, "dup", 0, 0);
        ByteCode._opcodeInfoTable[92] = new OpcodeInfo(92, "dup2", 0, 0);
        ByteCode._opcodeInfoTable[93] = new OpcodeInfo(93, "dup2_x1", 0, 0);
        ByteCode._opcodeInfoTable[94] = new OpcodeInfo(94, "dup2_x2", 0, 0);
        ByteCode._opcodeInfoTable[90] = new OpcodeInfo(90, "dup_x1", 0, 0);
        ByteCode._opcodeInfoTable[91] = new OpcodeInfo(91, "dup_x2", 0, 0);
        ByteCode._opcodeInfoTable[141] = new OpcodeInfo(141, "f2d", 0, 0);
        ByteCode._opcodeInfoTable[139] = new OpcodeInfo(139, "f2i", 0, 0);
        ByteCode._opcodeInfoTable[140] = new OpcodeInfo(140, "f2l", 0, 0);
        ByteCode._opcodeInfoTable[98] = new OpcodeInfo(98, "fadd", 0, 0);
        ByteCode._opcodeInfoTable[48] = new OpcodeInfo(48, "faload", 0, 0);
        ByteCode._opcodeInfoTable[81] = new OpcodeInfo(81, "fastore", 0, 0);
        ByteCode._opcodeInfoTable[150] = new OpcodeInfo(150, "fcmpg", 0, 0);
        ByteCode._opcodeInfoTable[149] = new OpcodeInfo(149, "fcmpl", 0, 0);
        ByteCode._opcodeInfoTable[11] = new OpcodeInfo(11, "fconst_0", 0, 0);
        ByteCode._opcodeInfoTable[12] = new OpcodeInfo(12, "fconst_1", 0, 0);
        ByteCode._opcodeInfoTable[13] = new OpcodeInfo(13, "fconst_2", 0, 0);
        ByteCode._opcodeInfoTable[110] = new OpcodeInfo(110, "fdiv", 0, 0);
        ByteCode._opcodeInfoTable[23] = new OpcodeInfo(23, "fload", 1, 1);
        ByteCode._opcodeInfoTable[34] = new OpcodeInfo(34, "fload_0", 0, 0);
        ByteCode._opcodeInfoTable[35] = new OpcodeInfo(35, "fload_1", 0, 0);
        ByteCode._opcodeInfoTable[36] = new OpcodeInfo(36, "fload_2", 0, 0);
        ByteCode._opcodeInfoTable[37] = new OpcodeInfo(37, "fload_3", 0, 0);
        ByteCode._opcodeInfoTable[106] = new OpcodeInfo(106, "fmul", 0, 0);
        ByteCode._opcodeInfoTable[118] = new OpcodeInfo(118, "fneg", 0, 0);
        ByteCode._opcodeInfoTable[114] = new OpcodeInfo(114, "frem", 0, 0);
        ByteCode._opcodeInfoTable[174] = new OpcodeInfo(174, "freturn", 0, 0);
        ByteCode._opcodeInfoTable[56] = new OpcodeInfo(56, "fstore", 1, 1);
        ByteCode._opcodeInfoTable[67] = new OpcodeInfo(67, "fstore_0", 0, 0);
        ByteCode._opcodeInfoTable[68] = new OpcodeInfo(68, "fstore_1", 0, 0);
        ByteCode._opcodeInfoTable[69] = new OpcodeInfo(69, "fstore_2", 0, 0);
        ByteCode._opcodeInfoTable[70] = new OpcodeInfo(70, "fstore_3", 0, 0);
        ByteCode._opcodeInfoTable[102] = new OpcodeInfo(102, "fsub", 0, 0);
        ByteCode._opcodeInfoTable[180] = new OpcodeInfo(180, "getfield", 7, 2);
        ByteCode._opcodeInfoTable[178] = new OpcodeInfo(178, "getstatic", 7, 2);
        ByteCode._opcodeInfoTable[167] = new OpcodeInfo(167, "goto", 10, 2);
        ByteCode._opcodeInfoTable[200] = new OpcodeInfo(200, "goto_w", 11, 4);
        ByteCode._opcodeInfoTable[135] = new OpcodeInfo(135, "i2d", 0, 0);
        ByteCode._opcodeInfoTable[134] = new OpcodeInfo(134, "i2f", 0, 0);
        ByteCode._opcodeInfoTable[133] = new OpcodeInfo(133, "i2l", 0, 0);
        ByteCode._opcodeInfoTable[96] = new OpcodeInfo(96, "iadd", 0, 0);
        ByteCode._opcodeInfoTable[46] = new OpcodeInfo(46, "iaload", 0, 0);
        ByteCode._opcodeInfoTable[126] = new OpcodeInfo(126, "iand", 0, 0);
        ByteCode._opcodeInfoTable[79] = new OpcodeInfo(79, "iastore", 0, 0);
        ByteCode._opcodeInfoTable[3] = new OpcodeInfo(3, "iconst_0", 0, 0);
        ByteCode._opcodeInfoTable[4] = new OpcodeInfo(4, "iconst_1", 0, 0);
        ByteCode._opcodeInfoTable[5] = new OpcodeInfo(5, "iconst_2", 0, 0);
        ByteCode._opcodeInfoTable[6] = new OpcodeInfo(6, "iconst_3", 0, 0);
        ByteCode._opcodeInfoTable[7] = new OpcodeInfo(7, "iconst_4", 0, 0);
        ByteCode._opcodeInfoTable[8] = new OpcodeInfo(8, "iconst_5", 0, 0);
        ByteCode._opcodeInfoTable[2] = new OpcodeInfo(2, "iconst_m1", 0, 0);
        ByteCode._opcodeInfoTable[108] = new OpcodeInfo(108, "idiv", 0, 0);
        ByteCode._opcodeInfoTable[165] = new OpcodeInfo(165, "if_acmpeq", 10, 2);
        ByteCode._opcodeInfoTable[166] = new OpcodeInfo(166, "if_acmpne", 10, 2);
        ByteCode._opcodeInfoTable[159] = new OpcodeInfo(159, "if_icmpeq", 10, 2);
        ByteCode._opcodeInfoTable[162] = new OpcodeInfo(162, "if_icmpge", 10, 2);
        ByteCode._opcodeInfoTable[163] = new OpcodeInfo(163, "if_icmpgt", 10, 2);
        ByteCode._opcodeInfoTable[164] = new OpcodeInfo(164, "if_icmple", 10, 2);
        ByteCode._opcodeInfoTable[161] = new OpcodeInfo(161, "if_icmplt", 10, 2);
        ByteCode._opcodeInfoTable[160] = new OpcodeInfo(160, "if_icmpne", 10, 2);
        ByteCode._opcodeInfoTable[153] = new OpcodeInfo(153, "ifeq", 10, 2);
        ByteCode._opcodeInfoTable[156] = new OpcodeInfo(156, "ifge", 10, 2);
        ByteCode._opcodeInfoTable[157] = new OpcodeInfo(157, "ifgt", 10, 2);
        ByteCode._opcodeInfoTable[158] = new OpcodeInfo(158, "ifle", 10, 2);
        ByteCode._opcodeInfoTable[155] = new OpcodeInfo(155, "iflt", 10, 2);
        ByteCode._opcodeInfoTable[154] = new OpcodeInfo(154, "ifne", 10, 2);
        ByteCode._opcodeInfoTable[199] = new OpcodeInfo(199, "ifnonnull", 10, 2);
        ByteCode._opcodeInfoTable[198] = new OpcodeInfo(198, "ifnull", 10, 2);
        ByteCode._opcodeInfoTable[132] = new OpcodeInfo(132, "iinc", 2, 2);
        ByteCode._opcodeInfoTable[21] = new OpcodeInfo(21, "iload", 1, 1);
        ByteCode._opcodeInfoTable[26] = new OpcodeInfo(26, "iload_0", 0, 0);
        ByteCode._opcodeInfoTable[27] = new OpcodeInfo(27, "iload_1", 0, 0);
        ByteCode._opcodeInfoTable[28] = new OpcodeInfo(28, "iload_2", 0, 0);
        ByteCode._opcodeInfoTable[29] = new OpcodeInfo(29, "iload_3", 0, 0);
        ByteCode._opcodeInfoTable[104] = new OpcodeInfo(104, "imul", 0, 0);
        ByteCode._opcodeInfoTable[116] = new OpcodeInfo(116, "ineg", 0, 0);
        ByteCode._opcodeInfoTable[193] = new OpcodeInfo(193, "instanceof", 6, 2);
        ByteCode._opcodeInfoTable[145] = new OpcodeInfo(145, "i2b", 0, 0);
        ByteCode._opcodeInfoTable[146] = new OpcodeInfo(146, "i2c", 0, 0);
        ByteCode._opcodeInfoTable[147] = new OpcodeInfo(147, "i2s", 0, 0);
        ByteCode._opcodeInfoTable[185] = new OpcodeInfo(185, "invokeinterface", 9, 4);
        ByteCode._opcodeInfoTable[183] = new OpcodeInfo(183, "invokespecial", 12, 2);
        ByteCode._opcodeInfoTable[184] = new OpcodeInfo(184, "invokestatic", 12, 2);
        ByteCode._opcodeInfoTable[182] = new OpcodeInfo(182, "invokevirtual", 12, 2);
        ByteCode._opcodeInfoTable[128] = new OpcodeInfo(128, "ior", 0, 0);
        ByteCode._opcodeInfoTable[112] = new OpcodeInfo(112, "irem", 0, 0);
        ByteCode._opcodeInfoTable[172] = new OpcodeInfo(172, "ireturn", 0, 0);
        ByteCode._opcodeInfoTable[120] = new OpcodeInfo(120, "ishl", 0, 0);
        ByteCode._opcodeInfoTable[122] = new OpcodeInfo(122, "ishr", 0, 0);
        ByteCode._opcodeInfoTable[54] = new OpcodeInfo(54, "istore", 1, 1);
        ByteCode._opcodeInfoTable[59] = new OpcodeInfo(59, "istore_0", 0, 0);
        ByteCode._opcodeInfoTable[60] = new OpcodeInfo(60, "istore_1", 0, 0);
        ByteCode._opcodeInfoTable[61] = new OpcodeInfo(61, "istore_2", 0, 0);
        ByteCode._opcodeInfoTable[62] = new OpcodeInfo(62, "istore_3", 0, 0);
        ByteCode._opcodeInfoTable[100] = new OpcodeInfo(100, "isub", 0, 0);
        ByteCode._opcodeInfoTable[124] = new OpcodeInfo(124, "iushr", 0, 0);
        ByteCode._opcodeInfoTable[130] = new OpcodeInfo(130, "ixor", 0, 0);
        ByteCode._opcodeInfoTable[168] = new OpcodeInfo(168, "jsr", 10, 2);
        ByteCode._opcodeInfoTable[201] = new OpcodeInfo(201, "jsr_w", 11, 4);
        ByteCode._opcodeInfoTable[138] = new OpcodeInfo(138, "l2d", 0, 0);
        ByteCode._opcodeInfoTable[137] = new OpcodeInfo(137, "l2f", 0, 0);
        ByteCode._opcodeInfoTable[136] = new OpcodeInfo(136, "l2i", 0, 0);
        ByteCode._opcodeInfoTable[97] = new OpcodeInfo(97, "ladd", 0, 0);
        ByteCode._opcodeInfoTable[47] = new OpcodeInfo(47, "laload", 0, 0);
        ByteCode._opcodeInfoTable[127] = new OpcodeInfo(127, "land", 0, 0);
        ByteCode._opcodeInfoTable[80] = new OpcodeInfo(80, "lastore", 0, 0);
        ByteCode._opcodeInfoTable[148] = new OpcodeInfo(148, "lcmp", 0, 0);
        ByteCode._opcodeInfoTable[9] = new OpcodeInfo(9, "lconst_0", 0, 0);
        ByteCode._opcodeInfoTable[10] = new OpcodeInfo(10, "lconst_1", 0, 0);
        ByteCode._opcodeInfoTable[18] = new OpcodeInfo(18, "ldc", 5, 1);
        ByteCode._opcodeInfoTable[19] = new OpcodeInfo(19, "ldc_w", 4, 2);
        ByteCode._opcodeInfoTable[20] = new OpcodeInfo(20, "ldc2_w", 4, 2);
        ByteCode._opcodeInfoTable[109] = new OpcodeInfo(109, "ldiv", 0, 0);
        ByteCode._opcodeInfoTable[22] = new OpcodeInfo(22, "lload", 1, 1);
        ByteCode._opcodeInfoTable[30] = new OpcodeInfo(30, "lload_0", 0, 0);
        ByteCode._opcodeInfoTable[31] = new OpcodeInfo(31, "lload_1", 0, 0);
        ByteCode._opcodeInfoTable[32] = new OpcodeInfo(32, "lload_2", 0, 0);
        ByteCode._opcodeInfoTable[33] = new OpcodeInfo(33, "lload_3", 0, 0);
        ByteCode._opcodeInfoTable[105] = new OpcodeInfo(105, "lmul", 0, 0);
        ByteCode._opcodeInfoTable[117] = new OpcodeInfo(117, "lneg", 0, 0);
        ByteCode._opcodeInfoTable[171] = new OpcodeInfo(171, "lookupswitch", 14, 0);
        ByteCode._opcodeInfoTable[129] = new OpcodeInfo(129, "lor", 0, 0);
        ByteCode._opcodeInfoTable[113] = new OpcodeInfo(113, "lrem", 0, 0);
        ByteCode._opcodeInfoTable[173] = new OpcodeInfo(173, "lreturn", 0, 0);
        ByteCode._opcodeInfoTable[121] = new OpcodeInfo(121, "lshl", 0, 0);
        ByteCode._opcodeInfoTable[123] = new OpcodeInfo(123, "lshr", 0, 0);
        ByteCode._opcodeInfoTable[55] = new OpcodeInfo(55, "lstore", 1, 1);
        ByteCode._opcodeInfoTable[63] = new OpcodeInfo(63, "lstore_0", 0, 0);
        ByteCode._opcodeInfoTable[64] = new OpcodeInfo(64, "lstore_1", 0, 0);
        ByteCode._opcodeInfoTable[65] = new OpcodeInfo(65, "lstore_2", 0, 0);
        ByteCode._opcodeInfoTable[66] = new OpcodeInfo(66, "lstore_3", 0, 0);
        ByteCode._opcodeInfoTable[101] = new OpcodeInfo(101, "lsub", 0, 0);
        ByteCode._opcodeInfoTable[125] = new OpcodeInfo(125, "lushr", 0, 0);
        ByteCode._opcodeInfoTable[131] = new OpcodeInfo(131, "lxor", 0, 0);
        ByteCode._opcodeInfoTable[194] = new OpcodeInfo(194, "monitorenter", 0, 0);
        ByteCode._opcodeInfoTable[195] = new OpcodeInfo(195, "monitorexit", 0, 0);
        ByteCode._opcodeInfoTable[197] = new OpcodeInfo(197, "multianewarray", 13, 3);
        ByteCode._opcodeInfoTable[187] = new OpcodeInfo(187, "new", 6, 2);
        ByteCode._opcodeInfoTable[188] = new OpcodeInfo(188, "newarray", 3, 1);
        ByteCode._opcodeInfoTable[0] = new OpcodeInfo(0, "nop", 0, 0);
        ByteCode._opcodeInfoTable[87] = new OpcodeInfo(87, "pop", 0, 0);
        ByteCode._opcodeInfoTable[88] = new OpcodeInfo(88, "pop2", 0, 0);
        ByteCode._opcodeInfoTable[181] = new OpcodeInfo(181, "putfield", 7, 2);
        ByteCode._opcodeInfoTable[179] = new OpcodeInfo(179, "putstatic", 7, 2);
        ByteCode._opcodeInfoTable[169] = new OpcodeInfo(169, "ret", 1, 1);
        ByteCode._opcodeInfoTable[177] = new OpcodeInfo(177, "return", 0, 0);
        ByteCode._opcodeInfoTable[53] = new OpcodeInfo(53, "saload", 0, 0);
        ByteCode._opcodeInfoTable[86] = new OpcodeInfo(86, "sastore", 0, 0);
        ByteCode._opcodeInfoTable[17] = new OpcodeInfo(17, "sipush", 2, 2);
        ByteCode._opcodeInfoTable[95] = new OpcodeInfo(95, "swap", 0, 0);
        ByteCode._opcodeInfoTable[170] = new OpcodeInfo(170, "tableswitch", 14, 0);
        ByteCode._opcodeInfoTable[196] = new OpcodeInfo(196, "wide", 8, 0);
    }

    private static final class OpcodeInfo {
        int _opcode;
        String _mnemonic;
        int _opcodeType;
        int _operandLength;

        OpcodeInfo(int opcode, String mnemonic, int opcodeType, int operandLength) {
            this._opcode = opcode;
            this._mnemonic = mnemonic;
            this._opcodeType = opcodeType;
            this._operandLength = operandLength;
        }
    }
}

