/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.dumpclass;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.aurora.rdbms.ClassHandle;
import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.util.StreamUtils;

public class ObjectDumper {
    String name;
    OutputStream output;
    InputStream input;
    Handle hndl;
    Schema schema = null;

    ObjectDumper(String oname, String sname, OutputStream outs, int type) throws IOException, ClassNotFoundException {
        this.name = oname;
        this.output = outs;
        this.schema = sname != null ? Schema.lookup(sname) : Schema.currentSchema();
        this.hndl = Handle.lookup(oname, this.schema, type, true);
        if (this.hndl == null) {
            throw new ClassNotFoundException("Dumping " + oname + "from schema " + this.schema.toString() + " with type " + type);
        }
        this.input = type == 29 ? ((ClassHandle)this.hndl).untransformedInputStream() : this.hndl.inputStream();
    }

    public int dump() throws IOException {
        int trans = 0;
        int size = this.input.available();
        trans = StreamUtils.copyStream(this.input, this.output, true);
        return size - trans;
    }
}

