/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.io.FileDescriptor;
import java.security.Permission;
import oracle.aurora.rdbms.ClassHandle;
import oracle.aurora.rdbms.DbmsJava;
import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.HandlePermission;
import oracle.aurora.rdbms.ObjectTypeChangedException;
import oracle.aurora.rdbms.ResourceHandle;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.security.PolicyTable;
import oracle.aurora.rdbms.security.PolicyTableManager;
import oracle.aurora.security.JServerPermission;
import oracle.aurora.vm.EnvironmentSpecific;
import oracle.aurora.vm.HotLoader;
import sun.security.util.SecurityConstants;

public final class SecurityManagerImpl
extends SecurityManager {
    private static final RuntimePermission readFileDescriptorPermission = new RuntimePermission("readFileDescriptor");
    private PolicyTable policyTable;
    private boolean inTableInitialization;

    public SecurityManagerImpl() {
        this.getPolicyTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyTable getPolicyTable() {
        if (this.policyTable == null) {
            try {
                this.inTableInitialization = true;
                this.policyTable = PolicyTableManager.getTable();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                this.inTableInitialization = false;
            }
        }
        return this.policyTable;
    }

    private native boolean checkDir(String var1);

    public void checkRead(Handle h) {
        if (h instanceof ResourceHandle) {
            boolean ok;
            Schema actor = Schema.currentSchema().concreteSchema();
            try {
                ok = h.hasExecutePrivilege(actor);
            }
            catch (ObjectTypeChangedException ex) {
                ok = false;
            }
            if (!ok) {
                String msg = "cannot read " + h + " because " + actor + " does not have execute privilege on it";
                throw new SecurityException(msg);
            }
        } else {
            Schema schema = h.schema().baseSchema();
            String objName = DbmsJava.longName(h.name()).replace('/', '.');
            HandlePermission p = new HandlePermission(schema, objName, "read");
            this.checkPermission((Permission)((Object)p));
        }
    }

    public void checkRead(FileDescriptor fd) {
        if (fd == null) {
            throw new NullPointerException("file descriptor can't be null");
        }
        this.checkPermission(readFileDescriptorPermission);
    }

    public void checkMemberAccess(Class clazz, int which) {
        if (clazz == null) {
            throw new NullPointerException("class can't be null");
        }
        if (which != 0) {
            Class<?>[] stack = this.getClassContext();
            boolean doCheck = true;
            if (stack.length >= 4) {
                Class<?> caller = stack[3];
                ClassHandle callerHandle = ClassHandle.lookup(caller);
                ClassHandle targetHandle = ClassHandle.lookup(clazz);
                if (callerHandle != null) {
                    if (targetHandle != null && callerHandle.schema().baseSchema().ownerNumber() == targetHandle.schema().baseSchema().ownerNumber()) {
                        doCheck = false;
                    }
                } else if (targetHandle == null && caller.getClassLoader() == clazz.getClassLoader()) {
                    doCheck = false;
                }
            }
            if (doCheck) {
                this.checkPermission(SecurityConstants.CHECK_MEMBER_ACCESS_PERMISSION);
            }
        }
    }

    public void checkPermission(Permission perm) {
        if (!HotLoader.inSave() && !EnvironmentSpecific.getInBootStrap()) {
            super.checkPermission(perm);
        }
    }

    public void checkCanDebug() {
        JServerPermission.check((String)"Debug");
    }
}

