/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.aurora.memoryManager.EndOfCallRegistry;
import oracle.aurora.rdbms.DbmsJava;
import oracle.aurora.rdbms.DynamicSchema;
import oracle.aurora.rdbms.EditionHandle;
import oracle.aurora.rdbms.HandleHolder;
import oracle.aurora.rdbms.JavaSysSchema;
import oracle.aurora.rdbms.JavaUserSchema;
import oracle.aurora.rdbms.LoginSchema;
import oracle.aurora.rdbms.NoSchema;
import oracle.aurora.rdbms.PublicSchema;
import oracle.aurora.rdbms.SchemaReadOnly;
import oracle.aurora.rdbms.SystemSchema;
import oracle.aurora.vm.Id;
import oracle.aurora.vm.IdNotFoundException;
import oracle.sql.CHAR;

public class Schema
implements Id {
    public static final int SYSTEM_OWNER_NUMBER = 0;
    public static final int PUBLIC_OWNER_NUMBER = 1;
    protected static final int NO_OWNER_NUMBER = -1;
    protected static final int DYNAMIC_OWNER_NUMBER = -2;
    protected static final int LOGIN_OWNER_NUMBER = -3;
    private static final Hashtable table = new Hashtable();
    private static final Schema key = new Schema();
    private static boolean set;
    protected static CHAR systemCharName;
    protected static String systemStringName;
    protected static int javaSysOwnerNumber;
    protected static CHAR javaSysCharName;
    protected static String javaSysStringName;
    protected static int javaUserOwnerNumber;
    protected static CHAR javaUserCharName;
    protected static String javaUserStringName;
    protected static CHAR noSchemaCharName;
    protected static final String noSchemaStringName = "-";
    protected CHAR charName;
    protected String stringName;
    protected int ownerNumberField;
    protected Schema baseSchema;
    protected EditionHandle edition;
    protected boolean editionInitialized;
    private Hashtable cachedRoles;
    public static final SystemSchema systemSchema;
    public static final PublicSchema publicSchema;
    public static final DynamicSchema dynamicSchema;
    public static final NoSchema noSchema;
    public static final LoginSchema loginSchema;
    public static final JavaSysSchema javaSysPrivSchema;
    public static final JavaUserSchema javaUserPrivSchema;

    Schema() {
    }

    protected Schema(CHAR name, int ownerNumber) {
        this.charName = name;
        this.ownerNumberField = ownerNumber;
    }

    protected void init(CHAR name, int ownerNumber) {
        this.charName = name;
        this.ownerNumberField = ownerNumber;
    }

    public static Schema lookup(String name) {
        CHAR cname = null;
        try {
            cname = new CHAR(name, CHAR.DEFAULT_CHARSET);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return Schema.lookup(cname);
    }

    public static Schema lookup(CHAR name) {
        Schema result = null;
        int ownerNumber = Schema.lookupOwnerNumber(name, false, false, false, null);
        result = Schema.get(ownerNumber);
        if (result == null) {
            if (ownerNumber >= 0) {
                if (ownerNumber == 1) {
                    result = publicSchema;
                } else {
                    result = new Schema();
                    result.init(name, ownerNumber);
                    result.intern();
                }
            } else if (name.equals((Object)noSchema.name())) {
                result = noSchema;
            }
        }
        return result;
    }

    public static Schema lookup(int ownerNumber) {
        return Schema.lookup(ownerNumber, null);
    }

    static Schema lookup(int ownerNumber, Schema initee) {
        Schema result = null;
        switch (ownerNumber) {
            case -1: {
                result = noSchema;
                break;
            }
            case -2: {
                result = dynamicSchema;
                break;
            }
            case -3: {
                CHAR lname = Schema.lookupName(ownerNumber, false, false, false, null);
                if (lname == null) break;
                result = Schema.lookup(lname);
                break;
            }
            case 1: {
                if (initee == null) {
                    result = publicSchema;
                    break;
                }
            }
            case 0: {
                if (initee == null) {
                    result = systemSchema;
                    break;
                }
            }
            default: {
                if (ownerNumber < 0 || (result = Schema.get(ownerNumber)) != null) break;
                CHAR name = Schema.lookupName(ownerNumber, false, false, false, null);
                if (name == null) {
                    return null;
                }
                result = initee == null ? new Schema() : initee;
                result.init(name, ownerNumber);
                result.intern();
            }
        }
        return result;
    }

    public static Schema lookupFixed(int ownerNumber) {
        Schema s = Schema.lookup(ownerNumber);
        if (s == dynamicSchema) {
            s = Schema.currentSchema();
        }
        if (s != null && s.ownerNumberField < 0) {
            s = null;
        }
        return s;
    }

    public static int lookupOwnerNumber(CHAR name, boolean allowRole, boolean disallowPublic, boolean disallowNonRole, boolean[] isRole) {
        if (name.equals((Object)noSchema.name())) {
            return -1;
        }
        return Schema.lookupNumber(name, allowRole, disallowPublic, disallowNonRole, isRole);
    }

    public static int lookupOwnerNumber(String name, boolean allowRole, boolean disallowPublic, boolean disallowNonRole, boolean[] isRole) throws SQLException {
        return Schema.lookupOwnerNumber(new CHAR(name, CHAR.DEFAULT_CHARSET), allowRole, disallowPublic, disallowNonRole, isRole);
    }

    public static String lookupOwnerName(int ownerNumber, boolean allowRole, boolean disallowPublic, boolean disallowNonRole, boolean[] isRole) {
        String result = null;
        if (isRole != null) {
            isRole[0] = false;
        }
        switch (ownerNumber) {
            case -1: {
                result = noSchema.toString();
                break;
            }
            case -2: {
                if (disallowNonRole) break;
                result = dynamicSchema.toString();
                break;
            }
            case 1: {
                if (disallowPublic || disallowNonRole) break;
                result = publicSchema.toString();
                break;
            }
            case 0: {
                if (disallowNonRole) break;
                result = systemSchema.toString();
                break;
            }
            default: {
                if (ownerNumber < 0) break;
            }
            case -3: {
                CHAR cname = Schema.lookupName(ownerNumber, allowRole, disallowPublic, disallowNonRole, isRole);
                if (cname == null) break;
                result = cname.toString();
            }
        }
        return result;
    }

    public static Schema currentSchema() {
        int currentOwnerNumber = Schema.lookupNumber(null, false, false, false, null);
        return Schema.lookup(currentOwnerNumber);
    }

    public CHAR name() {
        return this.charName;
    }

    public String toString() {
        if (this.stringName == null) {
            if (this == key) {
                return "Internal lookup key Schema";
            }
            CHAR n = this.name();
            if (n == null) {
                return "Schema number: " + this.ownerNumberField + ", name unknown";
            }
            this.stringName = n.toString();
            if (this.edition() != null) {
                this.stringName = this.baseSchema.toString() + "[edition " + this.edition.name() + "]";
            }
        }
        return this.stringName;
    }

    public int ownerNumber() {
        return this.ownerNumberField;
    }

    protected void initializeEditionInfo() {
        HandleHolder holder = new HandleHolder();
        int baseSchemaNumber = this.initializeEditionInfo(holder);
        if (holder.name != null) {
            this.edition = new EditionHandle(holder.name, systemSchema, holder.index, holder.timestamp);
        }
        this.baseSchema = Schema.lookup(baseSchemaNumber);
        this.editionInitialized = true;
    }

    public Schema baseSchema() {
        if (!this.editionInitialized) {
            this.initializeEditionInfo();
        }
        return this.baseSchema;
    }

    public EditionHandle edition() {
        if (!this.editionInitialized) {
            this.initializeEditionInfo();
        }
        return this.edition;
    }

    public int hashCode() {
        return this.ownerNumberField;
    }

    public boolean equals(Object obj) {
        return obj instanceof Schema && ((Schema)obj).ownerNumber() == this.ownerNumberField;
    }

    public boolean equals(int id) {
        return id == this.ownerNumberField;
    }

    protected void intern() {
        table.put(this, this);
    }

    protected static Schema get(int ownerNumber) {
        Schema.key.ownerNumberField = ownerNumber;
        return (Schema)table.get(key);
    }

    public int[] getGrantedRoles() {
        return DbmsJava.grantedRoles(this.ownerNumber(), true);
    }

    protected static final native CHAR lookupName(int var0, boolean var1, boolean var2, boolean var3, boolean[] var4);

    protected static final native int lookupNumber(CHAR var0, boolean var1, boolean var2, boolean var3, boolean[] var4);

    protected static final native int lookupNumber(int var0);

    protected native int initializeEditionInfo(HandleHolder var1);

    private void clearCachedRoles() {
        if (this.cachedRoles != null) {
            this.cachedRoles = null;
        }
    }

    static void clearCachedSchemaRoles() {
        Enumeration schemas = table.keys();
        while (schemas.hasMoreElements()) {
            ((Schema)schemas.nextElement()).clearCachedRoles();
        }
        set = false;
    }

    public boolean hasRole(int role) {
        Schema r = Schema.lookupRole(role);
        if (r == null) {
            return false;
        }
        return this.hasRole(r);
    }

    public boolean hasRole(Schema role) {
        if (role == null) {
            throw new IllegalArgumentException("Role is null");
        }
        if (!set) {
            EndOfCallRegistry.registerCallback(systemSchema);
            set = true;
        }
        if (this.cachedRoles == null) {
            this.cachedRoles = new Hashtable();
        } else {
            Boolean hasRole = (Boolean)this.cachedRoles.get(role);
            if (hasRole != null) {
                return hasRole;
            }
        }
        boolean reallyHasRole = DbmsJava.hasRole_(this.ownerNumberField, role.ownerNumber());
        if (reallyHasRole) {
            this.cachedRoles.put(role, Boolean.TRUE);
            return true;
        }
        this.cachedRoles.put(role, Boolean.FALSE);
        return false;
    }

    public boolean hasRole(String rolename) {
        return this.hasRole(Schema.lookupRole(rolename));
    }

    public static Schema lookupRole(CHAR name) {
        Schema result = null;
        int ownerNumber = Schema.lookupNumber(name, true, true, true, null);
        result = Schema.get(ownerNumber);
        if (result == null && ownerNumber >= 0) {
            if (ownerNumber == 1) {
                result = publicSchema;
            } else {
                result = new Schema();
                result.init(name, ownerNumber);
                result.intern();
            }
        }
        return result;
    }

    public static Schema lookupRole(int ownerNumber) {
        Schema result = Schema.get(ownerNumber);
        if (result != null) {
            return result;
        }
        CHAR name = Schema.lookupName(ownerNumber, true, true, true, null);
        if (name == null) {
            return null;
        }
        result = new Schema();
        result.init(name, ownerNumber);
        result.intern();
        return result;
    }

    public static Schema lookupRole(String name) {
        CHAR cname = null;
        try {
            cname = new CHAR(name, CHAR.DEFAULT_CHARSET);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return Schema.lookupRole(cname);
    }

    public Schema concreteSchema() {
        return this;
    }

    public boolean isConcrete() {
        return true;
    }

    public boolean resolvesTo(Object obj) {
        return obj instanceof Schema && ((Schema)obj).ownerNumber() == this.ownerNumber();
    }

    public Id getId() {
        return this;
    }

    public Class lookupClass(String name) throws ClassNotFoundException {
        return DbmsJava.classForNameAndSchema(name, this);
    }

    public final String getName() {
        return this.toString();
    }

    public long getNumber() {
        return this.ownerNumber();
    }

    public boolean inGroup(Id group) {
        return this.hasRole((int)group.getNumber());
    }

    public Id[] getGroups() {
        int[] ints = this.getGrantedRoles();
        int nids = ints == null ? 0 : ints.length;
        Id[] ids = new Id[nids];
        for (int xId = 0; xId < nids; ++xId) {
            try {
                int id = ints[xId];
                if (id == 1) {
                    if (xId == 0) {
                        ids[xId] = publicSchema;
                        continue;
                    }
                    ids[xId] = ids[0];
                    ids[0] = publicSchema;
                    continue;
                }
                ids[xId] = systemSchema.getId(id);
                continue;
            }
            catch (IdNotFoundException ex) {
                ids[xId] = systemSchema.invalidId();
            }
        }
        return ids;
    }

    static {
        javaSysOwnerNumber = -1;
        javaUserOwnerNumber = -1;
        systemSchema = SchemaReadOnly.systemSchema;
        publicSchema = new PublicSchema();
        dynamicSchema = SchemaReadOnly.dynamicSchema;
        noSchema = SchemaReadOnly.noSchema;
        loginSchema = SchemaReadOnly.loginSchema;
        javaSysPrivSchema = SchemaReadOnly.javaSysPrivSchema;
        javaUserPrivSchema = SchemaReadOnly.javaUserPrivSchema;
        systemSchema.intern();
        publicSchema.intern();
        javaSysPrivSchema.intern();
        javaUserPrivSchema.intern();
    }
}

