/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.notinserver;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import oracle.aurora.compiler.ExternalEntity;
import oracle.aurora.compiler.QName;

public class ExternalFile
extends ExternalEntity {
    File file;
    QName name;
    int kind;
    String pkg;

    public ExternalFile(File file, QName name, int kind) {
        super(kind);
        this.file = file;
        this.name = name;
        this.kind = kind;
    }

    public boolean isKind(int kind) {
        return kind == this.kind;
    }

    public Reader getReader() throws IOException {
        InputStreamReader reader = null;
        if (reader == null && this.kind == 0) {
            InputStream in = this.getStream();
            reader = new InputStreamReader(this.getStream());
        }
        return reader;
    }

    public InputStream getStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    public String getEncoding() {
        return null;
    }

    public Class getLoadedClass() {
        return null;
    }

    public QName getQualifiedName() {
        return this.name;
    }

    public String getPath() {
        return this.file.getPath();
    }

    public String getNameForClassFile() {
        String name = this.file.getPath();
        int x = name.lastIndexOf(File.separatorChar);
        if (x >= 0) {
            name = name.substring(x + 1);
        }
        return name;
    }

    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof ExternalFile)) {
            return false;
        }
        ExternalFile other = (ExternalFile)otherObject;
        return this.file.getName().equals(other.file.getName());
    }

    public int hashCode() {
        return this.file.getName().hashCode();
    }

    File getFile() {
        return this.file;
    }

    public void setPackage(String pkg) {
        this.pkg = pkg;
        if (this.name == null) {
            this.name = new QName(pkg, "");
        }
    }
}

