/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.compiler;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import oracle.aurora.compiler.ExternalEntity;

public class PositionAnalyzer {
    ExternalEntity source;
    char[] array;
    int endOfData;
    int curLine;
    int curIndex;
    int endOfLineIndex;
    boolean endOfFile;

    public PositionAnalyzer(ExternalEntity source) {
        this.source = source;
    }

    public int lineToAbsolute(int line) {
        this.gotoLine(line);
        return this.curIndex;
    }

    public int absoluteToLine(int absolute) {
        this.gotoAbsolute(absolute);
        return this.curLine;
    }

    public int absoluteToColumn(int absolute) {
        this.gotoAbsolute(absolute);
        return this.endOfFile ? 0 : absolute - this.curIndex;
    }

    public String getLine(int line) {
        this.gotoLine(line);
        int length = this.endOfLineIndex - this.curIndex;
        if (this.endOfLineIndex > 0 && this.array[this.endOfLineIndex - 1] == '\r') {
            --length;
        }
        return new String(this.array, this.curIndex, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillArray() {
        if (this.array == null) {
            Reader r = null;
            try {
                r = this.source.getReader();
                if (r == null) {
                    throw new FileNotFoundException();
                }
                boolean atEnd = false;
                int size = 0;
                while (!atEnd) {
                    long n = r.skip(8192L);
                    atEnd = n == 0L;
                    size = (int)((long)size + n);
                }
                r.close();
                r = this.source.getReader();
                this.array = new char[size];
                this.endOfData = r.read(this.array);
                r.close();
            }
            catch (IOException e) {
                this.array = new char[0];
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.reset();
        }
    }

    private void reset() {
        this.curLine = -1;
        this.curIndex = -1;
        this.endOfLineIndex = -1;
        this.endOfFile = false;
    }

    private void gotoLine(int line) {
        this.fillArray();
        if (line < 0) {
            line = 0;
        }
        if (this.curLine > line) {
            this.reset();
        }
        while (this.curLine < line && !this.endOfFile) {
            this.nextLine();
        }
    }

    private void gotoAbsolute(int index) {
        this.fillArray();
        if (index < this.curIndex) {
            this.reset();
        }
        while (index > this.endOfLineIndex && !this.endOfFile) {
            this.nextLine();
        }
    }

    private void nextLine() {
        if (!this.endOfFile) {
            this.curIndex = this.endOfLineIndex + 1;
            if (this.curIndex < this.endOfLineIndex && this.curIndex > 0 && this.array[this.curIndex] == '\r') {
                ++this.curIndex;
            }
            ++this.curLine;
            this.endOfLineIndex = this.curIndex;
            while (this.endOfLineIndex < this.endOfData && this.array[this.endOfLineIndex] != '\n') {
                ++this.endOfLineIndex;
            }
            this.endOfFile = this.curIndex >= this.endOfData;
        }
    }
}

