/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.compiler;

import java.io.PrintWriter;
import oracle.aurora.compiler.DbData;

public class Db {
    static DbData data = new DbData();

    public static void output(String msg) {
        data.indent();
        Db.data.writer.write(msg);
        Db.data.writer.println();
        Db.data.writer.flush();
    }

    public static void output(String label, Object obj) {
        data.indent();
        Db.data.writer.write(label);
        Db.data.writer.write(" = ");
        Db.data.writer.write(obj == null ? "<null>" : obj.toString());
        Db.data.writer.println();
        Db.data.writer.flush();
    }

    public static void mem(String s) {
        Runtime r = Runtime.getRuntime();
        r.gc();
        long inUse = r.totalMemory() - r.freeMemory();
        long change = inUse - Db.data.inUse;
        Db.output("at " + s + " memory in use " + inUse + " changed by " + change);
        Db.data.inUse = inUse;
    }

    public static void push() {
        ++Db.data.indentation;
    }

    public static void push(String msg) {
        Db.output(msg);
        Db.push();
    }

    public static void pop() {
        --Db.data.indentation;
    }

    public static void pop(String msg) {
        Db.pop();
        Db.output(msg);
    }

    public static void enter(Object category) {
        Db.enter(category, null);
    }

    public static void enter(Object category, Object what) {
        if (Db.data.timer != null) {
            String id = what == null ? null : what.toString();
            String cat = category.toString();
            Db.data.timer = Db.data.timer.enter(cat, id);
            if (id != null) {
                Db.output("entering " + cat + ": " + id);
                Db.push();
            } else if (Db.data.traceOn) {
                Db.output("entering " + cat);
                Db.push();
            }
        }
    }

    public static void leave(Object category) {
        String timerId;
        String id;
        if (Db.data.timer != null && !(id = category.toString()).equals(timerId = Db.data.timer.getCategory())) {
            Db.output("enter/leave mismatch. leaving " + id + " while timing " + timerId);
        }
        Db.leave();
    }

    public static void leave() {
        if (Db.data.timer != null) {
            String id = Db.data.timer.getId();
            if (id != null) {
                String cat = Db.data.timer.getCategory();
                Db.pop();
                Db.output("leaving " + cat + ": " + id + ", " + Db.data.timer.getTime() + " msec.");
            } else if (Db.data.traceOn) {
                Db.pop();
                Db.output("leaving " + Db.data.timer.getCategory());
            }
            Db.data.timer = Db.data.timer.leave();
        } else {
            Db.output("timer is null");
        }
    }

    public static void start() {
        data = new DbData();
    }

    public static void done() {
        if (data != null && Db.data.timer != null) {
            Db.data.timer.print(Db.data.writer);
            Db.data.writer.flush();
        }
    }

    static void setWriter(PrintWriter writer) {
        Db.data.writer = writer;
    }
}

