/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug.streams;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.util.Log;
import oracle.jdevimpl.debugger.plugin.StreamDebugger;
import oracle.jdevimpl.debugger.support.DebugDisassembleBytecode;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.runner.debug.streams.ExpressionInfo;

public class MethodCallExpressionInfo
extends ExpressionInfo {
    protected List<ExpressionInfo> methodArguments = new ArrayList<ExpressionInfo>();
    protected int invokeBytecodeOffset;
    protected String methodSignature;

    public String getSignature() {
        return this.methodSignature;
    }

    public String getFormattedArgumentList() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        if (this.methodArguments != null) {
            for (int i = 0; i < this.methodArguments.size(); ++i) {
                sb.append(this.methodArguments.get(i).getText());
                if (i >= this.methodArguments.size() - 1) continue;
                sb.append(',');
            }
        }
        sb.append(')');
        return sb.toString();
    }

    public List<ExpressionInfo> getArgumentList() {
        return this.methodArguments;
    }

    public void addArgument(ExpressionInfo arg) {
        this.methodArguments.add(arg);
    }

    @Override
    public String toString() {
        return "MethodCallExpressionInfo: " + this.expressionText + " (line " + this.lineNumber + " source " + this.sourceOffset + ")";
    }

    @Override
    public int attachBytecodes(List<DebugDisassembleBytecode> ddbs, DebugMethodInfo currentMethod) {
        Log logger = StreamDebugger.getLogger();
        this.methodSignature = currentMethod.getName();
        int consumed = 0;
        Iterator<DebugDisassembleBytecode> ddbiter = ddbs.iterator();
        while (ddbiter.hasNext()) {
            DebugDisassembleBytecode ddb = ddbiter.next();
            if (!ddb.getBytecode().startsWith("invoke")) continue;
            this.invokeBytecodeOffset = ddb.getOffset();
            ddbiter.remove();
            ++consumed;
            logger.trace("MethodCallExpressionInfo.attachBytescodes to " + this.getText() + " consumes " + ddb.getOffset() + " " + ddb.getBytecode());
            break;
        }
        return consumed;
    }
}

