/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;

public class WindowSettingsColumnManager {
    private static final String COLUMN_VISIBLE = "columnVisible";
    private static final String COLUMN_NUMERIC = "columnNumeric";
    private static final String COLUMN_BREADCRUMB_VISIBLE = "columnBreadcrumbVisible";
    private static final String COLUMN_WIDTH = "columnWidth";
    private static final String COLUMN_BREADCRUMB_WIDTH = "columnBreadcrumbWidth";
    private static final String COLUMN_ORDER = "columnOrder";
    private static final String COLUMN_BREADCRUMB_ORDER = "columnBreadcrumbOrder";
    private static final String COLUMN_NAMES = "columnNames";
    private static final String COLUMN_NAMES_PREFS = "columnNamesInPrefPane";
    private static final String ACTIVE_DATA_VIEW = "activeDataView";
    private static final String VM_NAMES = "vmNames";

    static boolean getColumnVisible(HashStructure hash, String vmName, int column) {
        if (hash.containsKey(COLUMN_VISIBLE + vmName + column)) {
            return hash.getBoolean(COLUMN_VISIBLE + vmName + column);
        }
        boolean defaultValue = column == 0 || column == 2 || column == 1;
        return hash.getBoolean(COLUMN_VISIBLE + column, defaultValue);
    }

    static void setColumnVisible(HashStructure hash, String vmName, int column, boolean visible) {
        if (hash == null) {
            return;
        }
        hash.putBoolean(COLUMN_VISIBLE + vmName + column, visible);
    }

    static boolean getColumnNumeric(HashStructure hash, String vmName, int column) {
        return hash.getBoolean(COLUMN_NUMERIC + vmName + column);
    }

    static void setColumnNumeric(HashStructure hash, String vmName, int column, boolean numeric) {
        if (hash == null) {
            return;
        }
        hash.putBoolean(COLUMN_NUMERIC + vmName + column, numeric);
    }

    static boolean getColumnBreadcrumbVisible(HashStructure hash, String vmName, int columnIndex) {
        if (hash.containsKey(COLUMN_BREADCRUMB_VISIBLE + vmName + columnIndex)) {
            return hash.getBoolean(COLUMN_BREADCRUMB_VISIBLE + vmName + columnIndex);
        }
        if (hash.containsKey(COLUMN_VISIBLE + vmName + columnIndex)) {
            boolean treeSetting = hash.getBoolean(COLUMN_VISIBLE + vmName + columnIndex);
            WindowSettingsColumnManager.setColumnBreadcrumbVisible(hash, vmName, columnIndex, treeSetting);
            return treeSetting;
        }
        boolean defaultValue = columnIndex == 0 || columnIndex == 2 || columnIndex == 1;
        return hash.getBoolean(COLUMN_BREADCRUMB_VISIBLE + columnIndex, defaultValue);
    }

    static void setColumnBreadcrumbVisible(HashStructure hash, String vmName, int columnIndex, boolean columnVisible) {
        if (hash == null) {
            return;
        }
        hash.putBoolean(COLUMN_BREADCRUMB_VISIBLE + vmName + columnIndex, columnVisible);
    }

    static int getColumnWidth(HashStructure hash, String vmName, int column) {
        if (hash.containsKey(COLUMN_WIDTH + vmName + column)) {
            return hash.getInt(COLUMN_WIDTH + vmName + column);
        }
        return hash.getInt(COLUMN_WIDTH + column, 0);
    }

    static void setColumnWidth(HashStructure hash, String vmName, int column, int width) {
        if (hash == null) {
            return;
        }
        hash.putInt(COLUMN_WIDTH + vmName + column, width);
    }

    static int getColumnBreadcrumbWidth(HashStructure hash, String vmName, int columnIndex) {
        if (hash.containsKey(COLUMN_BREADCRUMB_WIDTH + vmName + columnIndex)) {
            return hash.getInt(COLUMN_BREADCRUMB_WIDTH + vmName + columnIndex);
        }
        if (hash.containsKey(COLUMN_WIDTH + vmName + columnIndex)) {
            int ttWidth = hash.getInt(COLUMN_WIDTH + vmName + columnIndex);
            WindowSettingsColumnManager.setColumnBreadcrumbWidth(hash, vmName, columnIndex, ttWidth);
            return ttWidth;
        }
        return hash.getInt(COLUMN_WIDTH + columnIndex, 0);
    }

    static void setColumnBreadcrumbWidth(HashStructure hash, String vmName, int columnIndex, int columnWidth) {
        if (hash == null) {
            return;
        }
        hash.putInt(COLUMN_BREADCRUMB_WIDTH + vmName + columnIndex, columnWidth);
    }

    static String getColumnOrder(HashStructure hash, String vmName) {
        if (hash.containsKey(COLUMN_ORDER + vmName)) {
            return hash.getString(COLUMN_ORDER + vmName);
        }
        return hash.getString(COLUMN_ORDER);
    }

    static void setColumnOrder(HashStructure hash, String vmName, String columnOrder) {
        if (hash == null) {
            return;
        }
        hash.putString(COLUMN_ORDER + vmName, columnOrder);
    }

    static String getColumnBreadcrumbOrder(HashStructure hash, String vmName) {
        if (hash.containsKey(COLUMN_BREADCRUMB_ORDER + vmName)) {
            return hash.getString(COLUMN_BREADCRUMB_ORDER + vmName);
        }
        if (hash.containsKey(COLUMN_ORDER + vmName)) {
            String ttOrder = hash.getString(COLUMN_ORDER + vmName);
            WindowSettingsColumnManager.setColumnBreadcrumbOrder(hash, vmName, ttOrder);
            return ttOrder;
        }
        return hash.getString(COLUMN_ORDER);
    }

    static void setColumnBreadcrumbOrder(HashStructure hash, String vmName, String columnOrder) {
        if (hash == null) {
            return;
        }
        hash.putString(COLUMN_BREADCRUMB_ORDER + vmName, columnOrder);
    }

    static List<String> getColumnNames(HashStructure hash, String vmName) {
        if (hash == null) {
            return Collections.emptyList();
        }
        ListStructure names = hash.getListStructure(COLUMN_NAMES + vmName);
        if (names == null) {
            return Collections.emptyList();
        }
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < names.size(); ++i) {
            stringList.add(names.get(i) == null ? null : names.get(i).toString());
        }
        return stringList;
    }

    static void setColumnNames(HashStructure hash, String vmName, List<String> columnNames) {
        if (hash == null) {
            return;
        }
        ListStructure names = ListStructure.newInstance();
        for (String name : columnNames) {
            names.add((Object)name);
        }
        hash.putListStructure(COLUMN_NAMES + vmName, names);
    }

    static List<String> getColumnNamesInPreferences(HashStructure hash, String vmName) {
        ListStructure names = hash.getListStructure(COLUMN_NAMES_PREFS + vmName);
        if (names == null) {
            return Collections.emptyList();
        }
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < names.size(); ++i) {
            stringList.add(names.get(i) == null ? null : names.get(i).toString());
        }
        return stringList;
    }

    static void setColumnNamesInPreferences(HashStructure hash, String vmName, List<String> columnNames) {
        if (hash == null) {
            return;
        }
        ListStructure names = ListStructure.newInstance();
        for (String name : columnNames) {
            names.add((Object)name);
        }
        hash.putListStructure(COLUMN_NAMES_PREFS + vmName, names);
    }

    public static String getActiveDataView(HashStructure hash, String vmName, String windowId) {
        return hash.getString(ACTIVE_DATA_VIEW + vmName + windowId, "TABLE_TABLE");
    }

    public static String getActiveDataViewNoDefault(HashStructure hash, String vmName, String windowId) {
        return hash.getString(ACTIVE_DATA_VIEW + vmName + windowId);
    }

    public static void setActiveDataView(HashStructure hash, String vmName, String windowId, String dataView) {
        if (hash == null) {
            return;
        }
        hash.putString(ACTIVE_DATA_VIEW + vmName + windowId, dataView);
    }

    static List<String> getVMNames(HashStructure hash) {
        if (hash == null) {
            return Collections.emptyList();
        }
        ListStructure names = hash.getListStructure(VM_NAMES);
        if (names == null) {
            return Collections.emptyList();
        }
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < names.size(); ++i) {
            stringList.add(names.get(i).toString());
        }
        return stringList;
    }

    static void addVMName(HashStructure hash, String vmName) {
        if (hash == null) {
            return;
        }
        ListStructure names = hash.getListStructure(VM_NAMES);
        if (names == null) {
            names = ListStructure.newInstance();
        }
        if (!names.contains((Object)vmName)) {
            names.add((Object)vmName);
            hash.putListStructure(VM_NAMES, names);
        }
    }
}

