/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.util.PropertyAccess;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.debugger.support.DebuggerDataWindowOptions;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataWindow;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.WatchController;
import oracle.jdevimpl.runner.debug.WatchPanel;
import oracle.jdevimpl.runner.debug.WatchWindowSettings;

final class WatchWindow
extends DataWindow {
    private WatchWindowSettings watchWindowSettings = WatchWindowSettings.getInstance();
    static final String WATCH_WINDOW_ID = "Debugger.WatchWindow";
    private WatchPanel watchPanel;
    private Boolean useFilters;

    WatchWindow() {
        super(WATCH_WINDOW_ID, DbgArb.getString(543), "f1_deb_watchwindow_html");
    }

    @Override
    protected final DataPanel getDataPanel(boolean forceCreate) {
        if (this.watchPanel == null && forceCreate) {
            this.watchPanel = new WatchPanel(this, this.watchWindowSettings);
            if (this.useFilters != null) {
                this.watchPanel.setUseFilters(this.useFilters);
            }
        }
        return this.watchPanel;
    }

    @Override
    final void setUseFilters(boolean useFilters) {
        if (this.watchPanel != null) {
            this.watchPanel.setUseFilters(useFilters);
        } else {
            this.useFilters = useFilters;
        }
    }

    public Icon getTabIcon() {
        DebuggerDataWindowOptions options = this.getWatchController().getDebuggerWindowOptions();
        if (options != null) {
            return options.getTabIcon();
        }
        return OracleIcons.getIcon((String)"watch.png");
    }

    private WatchController getWatchController() {
        return (WatchController)this.getDataPanel(true).getController();
    }

    EvaluatorItem addWatch(Object expression) {
        return this.getWatchController().addWatch(expression);
    }

    boolean removeWatch(EvaluatorItem ei) {
        return this.getWatchController().removeWatch(ei);
    }

    boolean addWatchDialog(String expression) {
        return this.getWatchController().addWatchDialog(expression);
    }

    @Override
    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.SOUTH;
    }

    public boolean installByDefault() {
        return true;
    }

    @Override
    public void shutDown() {
        super.shutDown();
        if (this.watchPanel != null) {
            this.getWatchController().saveWatches((PropertyAccess)Ide.getIdeProperties());
        }
    }
}

