/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.runner.debug.DbgArb;

final class UnmodifiableObjectDialog
extends JPanel
implements ItemListener {
    private JEWTDialog dlg;
    private transient DebugClassInfo clazz;
    private transient DebugDataInfo data;
    private String currentText = null;
    private JCheckBox setAddressToZeroCheckBox;

    static boolean showUnmodifiableObjectDialog(String type, String name, String currentValue, String currentAddress, DebugClassInfo clazz, DebugDataInfo data) {
        UnmodifiableObjectDialog panel = new UnmodifiableObjectDialog(type, name, currentValue, currentAddress, clazz, data);
        String title = DbgArb.getString(491);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.setAddressToZeroCheckBox, (String)title);
        panel.setJEWTDialog(dlg);
        dlg.setOKButtonEnabled(panel.canOk());
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_deb_unmodifiableobjectdialog_html");
        return WizardLauncher.runDialog((JDialog)dlg);
    }

    private UnmodifiableObjectDialog(String type, String name, String currentValue, String currentAddress, DebugClassInfo clazz, DebugDataInfo data) {
        super(new GridBagLayout());
        String text;
        this.clazz = clazz;
        this.data = data;
        JLabel topLabel = new JLabel(type + " " + name);
        JLabel explainLabel1 = new JLabel(DbgArb.getString(492));
        JLabel explainLabel2 = new JLabel(DbgArb.getString(493));
        JLabel currentLabel = new JLabel();
        JTextArea currentTextArea = new JTextArea();
        this.currentText = text = this.makeCurrentValue(currentValue, currentAddress);
        currentTextArea.setText(text);
        currentTextArea.setBorder(new JTextField().getBorder());
        currentTextArea.setEditable(false);
        currentTextArea.setLineWrap(false);
        currentTextArea.setMinimumSize(new Dimension(20, 20));
        currentTextArea.setForeground(currentTextArea.getDisabledTextColor());
        this.setAddressToZeroCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.setAddressToZeroCheckBox, (String)DbgArb.getString(494));
        this.setAddressToZeroCheckBox.setSelected(false);
        this.setAddressToZeroCheckBox.setEnabled(true);
        JScrollPane scrollPane = new JScrollPane(currentTextArea);
        ResourceUtils.resLabel((JLabel)currentLabel, (Component)scrollPane, (String)DbgArb.getString(482));
        currentTextArea.setRows(4);
        int y = 0;
        this.add((Component)explainLabel1, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)explainLabel2, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)topLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)currentLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)scrollPane, new GridBagConstraints(0, y++, 0, 2, 1.0, 2.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.setAddressToZeroCheckBox, new GridBagConstraints(0, y += 2, 0, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setAddressToZeroCheckBox.addItemListener(this);
    }

    private void setJEWTDialog(JEWTDialog dlg) {
        this.dlg = dlg;
        dlg.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && !UnmodifiableObjectDialog.this.setDataNewValue()) {
                    throw new PropertyVetoException("no", evt);
                }
            }
        });
    }

    private String makeCurrentValue(String currentValue, String currentAddress) {
        if (currentValue != null) {
            if (currentAddress != null) {
                return currentValue + "\n" + DbgArb.format(483, currentAddress);
            }
            return currentValue;
        }
        if (currentAddress != null) {
            return DbgArb.format(483, currentAddress);
        }
        return "";
    }

    private void processChange() {
        this.dlg.setOKButtonEnabled(this.canOk());
    }

    private boolean canOk() {
        return this.setAddressToZeroCheckBox.isSelected();
    }

    private boolean setDataNewValue() {
        String errorMessage = null;
        if (this.setAddressToZeroCheckBox.isSelected()) {
            boolean valueSet = true;
            boolean setOK = ((DebugDataCompositeInfo)this.data).setAddressOfObject(0L);
            if (!setOK) {
                errorMessage = DbgArb.getString(489);
            }
        } else {
            boolean valueSet = false;
        }
        if (errorMessage != null) {
            String title = DbgArb.getString(481);
            String[] messages = new String[]{DbgArb.getString(486), DbgArb.getString(487), DbgArb.getString(488), errorMessage};
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), messages, title, 0);
            return false;
        }
        return true;
    }

    public void cancel() {
        this.setVisible(false);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.processChange();
    }
}

