/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.ThreadsPanelSettingsPanel;
import oracle.jdevimpl.runner.debug.ThreadsWindowSettings;
import oracle.jdevimpl.runner.debug.WindowSettingsColumnManager;

public final class ThreadsWindowSettingsPanel
extends DefaultTraversablePanel
implements ActionListener {
    ThreadsPanelSettingsPanel threadsPanel = new ThreadsPanelSettingsPanel();
    JCheckBox showThreadGroupStructureCheckBox = new JCheckBox();
    JLabel spacerLabel = new JLabel();
    private JComboBox<String> vmChooser;
    private JLabel vmChooserLabel;
    private MultiLineLabel disclaimerLabel;
    private transient ThreadsWindowSettings settings;
    private JPanel spacer;
    private JPanel optionPanel;

    public ThreadsWindowSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_threadswindowsetpanel_html");
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.showThreadGroupStructureCheckBox, (String)DbgArb.getString(660));
        this.spacerLabel.setEnabled(false);
        this.spacer = new JPanel();
        this.optionPanel = new JPanel(new GridBagLayout());
        this.disclaimerLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), DbgArb.format(862, DbgArb.getString(188)));
        this.vmChooser = new JComboBox();
        this.vmChooserLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.vmChooserLabel, this.vmChooser, (String)DbgArb.getString(861));
    }

    private JPanel makeMiscPanel(Insets borderInsets) {
        JPanel panel = new JPanel(new GridLayout(0, 1, 0, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(0, borderInsets.left, 0, borderInsets.right));
        panel.add(this.showThreadGroupStructureCheckBox);
        return panel;
    }

    private ThreadsWindowSettings getData(TraversableContext tc) {
        return ThreadsWindowSettings.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        this.settings = this.getData(tc);
        HashStructure hash = this.settings.getThreadsPanelSettings().getHash();
        this.removeAll();
        List<String> vmNames = WindowSettingsColumnManager.getVMNames(hash);
        if (vmNames.size() <= 0) {
            this.add((Component)this.disclaimerLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(6, 0, 16, 0), 0, 0));
            this.add(this.spacer, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.threadsPanel.onEntry(this.settings.getThreadsPanelSettings());
        this.vmChooser.removeAllItems();
        if (vmNames.size() > 0) {
            int y = 0;
            for (String vmName : vmNames) {
                this.vmChooser.addItem(vmName);
            }
            this.vmChooser.setEditable(false);
            if (vmNames.size() > 1) {
                this.add(this.vmChooserLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 0, 8, 8), 0, 0));
                this.add(this.vmChooser, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 8, 0), 0, 0));
            }
            this.add(this.optionPanel, new GridBagConstraints(0, y++, 2, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagConstraints constraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
            constraints.gridy = y;
            constraints.insets.top = 10;
            Insets borderInsets = new Insets(0, 0, 0, 0);
            this.add(this.makeMiscPanel(borderInsets), constraints);
            ++constraints.gridy;
            constraints.weighty = 1.0;
            this.add(this.spacerLabel, constraints);
            this.vmChooser.addActionListener(this);
            this.vmChooser.setSelectedIndex(0);
        }
        this.showThreadGroupStructureCheckBox.setSelected(this.settings.isShowThreadGroupStructure());
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        ThreadsWindowSettings settings = this.getData(tc);
        this.threadsPanel.onExit(settings.getThreadsPanelSettings());
        settings.setShowThreadGroupStructure(this.showThreadGroupStructureCheckBox.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.vmChooser && this.vmChooser.getSelectedIndex() != -1) {
            String newVM = this.vmChooser.getSelectedItem().toString();
            String window = DbgArb.getString(188);
            String title = DbgArb.format(863, window, newVM);
            TitledBorder border = BorderFactory.createTitledBorder(title);
            this.optionPanel.setBorder(border);
            this.optionPanel.removeAll();
            GridBagConstraints constraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
            Insets borderInsets = new Insets(0, 0, 0, 0);
            this.optionPanel.add((Component)this.threadsPanel.makeChooseColumnsPanel(newVM, borderInsets), constraints);
            this.optionPanel.revalidate();
        }
    }
}

