/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.List;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.runner.SmartDataProvider;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdevimpl.runner.debug.JDebugger;

public final class SmartUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getExpressions(TextNode textNode, int line, int numberOfLines, List<String> expressions) {
        TextBuffer tb = textNode.acquireTextBuffer();
        tb.readLock();
        try {
            int startOffset = tb.getLineMap().getLineStartOffset(--line);
            int endOffset = startOffset + 1;
            for (int endLine = line + numberOfLines - 1; endLine >= line; --endLine) {
                try {
                    endOffset = tb.getLineMap().getLineEndOffset(endLine);
                    if (endOffset < startOffset) continue;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            List<SmartDataProvider> smartDataProviders = JDebugger.getInstance().getSmartDataProviders();
            for (int i = smartDataProviders.size() - 1; i >= 0; --i) {
                SmartDataProvider smartDataProvider = smartDataProviders.get(i);
                if (!smartDataProvider.canUnderstand((Node)textNode)) continue;
                smartDataProvider.getExpressions((ReadTextBuffer)tb, startOffset, endOffset, expressions);
            }
        }
        finally {
            tb.readUnlock();
            textNode.releaseTextBuffer();
        }
    }
}

