/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.debugger.support.DebugFactory;

public class DebugConfiguration
extends HashStructureAdapter {
    private static final String DATA_KEY = DebugConfiguration.class.getName();
    private RunConfiguration runConfiguration;
    private static final String TRACING_INCLUDE = "tracingInclude";
    private static final String TRACING_EXCLUDE = "tracingExclude";
    private static final String REMOTE_PROTOCOL = "remoteProtocol";
    private static final String REMOTE_PARAMETERS = "remoteParameter:";
    private static final String OJVM_DEBUG_ARGUMENTS = "OJVMDebugArguments";
    private static final String OJVM_DEBUG_ARGUMENTS_DEFAULT = "-XXdebug,quiet,port<port>";
    private static final String JPDA_CLASSIC_DEBUG_ARGUMENTS = "JPDAClassicDebugArguments";
    private static final String JPDA_CLASSIC_DEBUG_ARGUMENTS_DEFAULT = "-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,address=<port>";
    private static final String PRE_50_JPDA_DEBUG_ARGUMENTS = "Pre50JPDADebugArguments";
    private static final String PRE_50_JPDA_DEBUG_ARGUMENTS_DEFAULT = "-Xdebug -Xrunjdwp:transport=dt_socket,server=y,address=<port>";
    private static final String JPDA_DEBUG_ARGUMENTS = "JPDADebugArguments";
    private static final String JPDA_DEBUG_ARGUMENTS_DEFAULT = "-agentlib:jdwp=transport=dt_socket,server=y,address=<port>";
    private static final String MOZILLA_FIREFOX_DEBUG_ARGUMENTS = "MozillaFirefoxDebugArguments";
    private static final String MOZILLA_FIREFOX_DEBUG_ARGUMENTS_DEFAULT = "-oraclejsdebugport=<port>";

    private DebugConfiguration(HashStructure hash, RunConfiguration runConfiguration) {
        super(hash);
        this.runConfiguration = runConfiguration;
    }

    static DebugConfiguration getInstance(PropertyStorage propertyStorage) {
        if (propertyStorage instanceof RunConfiguration) {
            return new DebugConfiguration(DebugConfiguration.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY), (RunConfiguration)propertyStorage);
        }
        RunConfiguration runConfiguration = RunConfiguration.getInstance(propertyStorage);
        return DebugConfiguration.getInstance(runConfiguration);
    }

    RunConfiguration getRunConfiguration() {
        return this.runConfiguration;
    }

    boolean isCustom() {
        if (this.runConfiguration != null) {
            return this.runConfiguration.isCustom();
        }
        return false;
    }

    String getTracingInclude() {
        return this._hash.getString(TRACING_INCLUDE, "");
    }

    void setTracingInclude(String tracingInclude) {
        if (tracingInclude == null) {
            tracingInclude = "";
        }
        this._hash.putString(TRACING_INCLUDE, tracingInclude);
    }

    List getTracingIncludeList() {
        ArrayList list = new ArrayList();
        IdeUtil.string2List((String)this.getTracingInclude(), list);
        return list;
    }

    void setTracingIncludeList(List tracingInclude) {
        this.setTracingInclude(IdeUtil.list2String((List)tracingInclude));
    }

    String getTracingExclude() {
        return this._hash.getString(TRACING_EXCLUDE, DebugConfiguration.getDefaultTracingExclude());
    }

    void setTracingExclude(String tracingExclude) {
        if (tracingExclude == null) {
            tracingExclude = "";
        }
        this._hash.putString(TRACING_EXCLUDE, tracingExclude);
    }

    List getTracingExcludeList() {
        ArrayList list = new ArrayList();
        IdeUtil.string2List((String)this.getTracingExclude(), list);
        return list;
    }

    void setTracingExcludeList(List tracingExclude) {
        this.setTracingExclude(IdeUtil.list2String((List)tracingExclude));
    }

    private static String getDefaultTracingExclude() {
        String[] array = new String[]{"java", "javax", "sun", "sunw", "jdk", "com.sun", "apple", "com.apple", "com.evermind", "com.oracle", "com.orionserver", "EDU.oswego", "oracle.as", "oracle.aurora", "oracle.core", "oracle.dms", "oracle.gss", "oracle.hooks", "oracle.ide", "oracle.ias", "oracle.j2ee", "oracle.jdbc", "oracle.jdevimpl", "oracle.jsp", "oracle.oc4j", "oracle.ojc", "oracle.security", "oracle.sql", "oracle.webservices", "oracle.xml", "org.omg", "org.w3c", "org.xml", "weblogic", "org.codehaus.groovy", "groovy.lang", "oracle.jbo.script.groovy"};
        List<String> list = Arrays.asList(array);
        return IdeUtil.list2String(list);
    }

    static int getDebuggerFactory(String protocol) {
        int cookie = DebugFactory.getDebugConnectorCookie(protocol);
        if (cookie >= 0) {
            return cookie;
        }
        return DebugFactory.getDefaultDebugConnectorCookie();
    }

    String getRemoteProtocol() {
        return this._hash.getString(REMOTE_PROTOCOL, DebugFactory.getDefaultProtocol());
    }

    void setRemoteProtocol(String remoteProtocol) {
        if (remoteProtocol == null) {
            remoteProtocol = DebugFactory.getDefaultProtocol();
        }
        this._hash.putString(REMOTE_PROTOCOL, remoteProtocol);
    }

    private String getRemoteParameterKey(String protocol, String name) {
        return REMOTE_PARAMETERS + protocol + ":" + name;
    }

    String getRemoteParameterValue(String protocol, String name, String defaultValue) {
        return this._hash.getString(this.getRemoteParameterKey(protocol, name), defaultValue);
    }

    void putRemoteParameterValue(String protocol, String name, String value) {
        this._hash.putString(this.getRemoteParameterKey(protocol, name), value);
    }

    String getOJVMDebugArguments() {
        return this._hash.getString(OJVM_DEBUG_ARGUMENTS, OJVM_DEBUG_ARGUMENTS_DEFAULT);
    }

    void setOJVMDebugArguments(String ojvmDebugArguments) {
        if (ojvmDebugArguments == null) {
            ojvmDebugArguments = OJVM_DEBUG_ARGUMENTS_DEFAULT;
        }
        this._hash.putString(OJVM_DEBUG_ARGUMENTS, ojvmDebugArguments);
    }

    String[] getOJVMDebugArguments(String port) {
        return DebugConfiguration.insertPort(this.getOJVMDebugArguments(), port);
    }

    String getJPDAClassicDebugArguments() {
        return this._hash.getString(JPDA_CLASSIC_DEBUG_ARGUMENTS, JPDA_CLASSIC_DEBUG_ARGUMENTS_DEFAULT);
    }

    void setJPDAClassicDebugArguments(String jpdaClassicDebugArguments) {
        if (jpdaClassicDebugArguments == null) {
            jpdaClassicDebugArguments = JPDA_CLASSIC_DEBUG_ARGUMENTS_DEFAULT;
        }
        this._hash.putString(JPDA_CLASSIC_DEBUG_ARGUMENTS, jpdaClassicDebugArguments);
    }

    String[] getJPDAClassicDebugArguments(String port) {
        return DebugConfiguration.insertPort(this.getJPDAClassicDebugArguments(), port);
    }

    String getPre50JPDADebugArguments() {
        return this._hash.getString(PRE_50_JPDA_DEBUG_ARGUMENTS, PRE_50_JPDA_DEBUG_ARGUMENTS_DEFAULT);
    }

    String getJPDADebugArguments() {
        return this._hash.getString(JPDA_DEBUG_ARGUMENTS, JPDA_DEBUG_ARGUMENTS_DEFAULT);
    }

    void setPre50JPDADebugArguments(String jpdaDebugArguments) {
        if (jpdaDebugArguments == null) {
            jpdaDebugArguments = PRE_50_JPDA_DEBUG_ARGUMENTS_DEFAULT;
        }
        this._hash.putString(PRE_50_JPDA_DEBUG_ARGUMENTS, jpdaDebugArguments);
    }

    void setJPDADebugArguments(String jpdaDebugArguments) {
        if (jpdaDebugArguments == null) {
            jpdaDebugArguments = JPDA_DEBUG_ARGUMENTS_DEFAULT;
        }
        this._hash.putString(JPDA_DEBUG_ARGUMENTS, jpdaDebugArguments);
    }

    String[] getPre50JPDADebugArguments(String port) {
        return DebugConfiguration.insertPort(this.getPre50JPDADebugArguments(), port);
    }

    String[] getJPDADebugArguments(String port) {
        return DebugConfiguration.insertPort(this.getJPDADebugArguments(), port);
    }

    String getMozillaFireFoxDebugArguments() {
        return this._hash.getString(MOZILLA_FIREFOX_DEBUG_ARGUMENTS, MOZILLA_FIREFOX_DEBUG_ARGUMENTS_DEFAULT);
    }

    void setMozillaFireFoxDebugArguments(String mozillaFirefoxDebugArguments) {
        if (mozillaFirefoxDebugArguments == null) {
            mozillaFirefoxDebugArguments = MOZILLA_FIREFOX_DEBUG_ARGUMENTS_DEFAULT;
        }
        this._hash.putString(MOZILLA_FIREFOX_DEBUG_ARGUMENTS, mozillaFirefoxDebugArguments);
    }

    String[] getMozillaFireFoxDebugArguments(String port) {
        return DebugConfiguration.insertPort(this.getMozillaFireFoxDebugArguments(), port);
    }

    private static String[] insertPort(String args, String port) {
        int i = args.indexOf("<port>");
        if (i < 0) {
            return null;
        }
        args = i + 6 == args.length() ? args.substring(0, i) + port : args.substring(0, i) + port + args.substring(i + 6);
        return IdeUtil.convertStringToStringArray((String)args);
    }
}

