/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import oracle.ide.controller.Controller;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.runner.Debugger;
import oracle.ide.runner.RunLogPage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.HyperlinkButton;
import oracle.jdevimpl.runner.debug.DataArrayNavigationPanel;
import oracle.jdevimpl.runner.debug.DataCellEditor;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataTipDisplayer;

class DataValueCellEditor
extends DataCellEditor
implements Controller {
    private JPanel valueColumnPanel;
    private JPanel dataTipColumnPanel;
    private JLabel label;
    private final DataArrayNavigationPanel buttonPanel;
    private HyperlinkButton hyperlinkButton = new HyperlinkButton();
    private JPanel hyperlinkButtonPanel;

    DataValueCellEditor(DataPanel dataPanel) {
        super(dataPanel);
        this.valueColumnPanel = new JPanel(new BorderLayout(0, 0));
        this.valueColumnPanel.setOpaque(true);
        this.hyperlinkButtonPanel = new JPanel(new BorderLayout(0, 0));
        this.hyperlinkButton.setOpaque(true);
        this.hyperlinkButtonPanel.add((Component)this.hyperlinkButton, "West");
        this.valueColumnPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                DataValueCellEditor.this.cancelCellEditing();
            }
        });
        this.buttonPanel = new DataArrayNavigationPanel();
        this.buttonPanel.setOpaque(true);
        this.label = new JLabel();
        this.label.setOpaque(true);
        this.label.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.valueColumnPanel.add((Component)this.label, "Center");
        this.valueColumnPanel.add((Component)this.buttonPanel, "East");
        this.buttonPanel.addObjectPreferencesActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataValueCellEditor.this.cancelCellEditing();
                DataValueCellEditor.this.dataPanel.getController().showObjectPreferences(e);
            }
        });
        this.buttonPanel.addFirstButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataValueCellEditor.this.cancelCellEditing();
                DataItem dataItem = DataValueCellEditor.this.getCurrentDataItem();
                if (dataItem != null) {
                    dataItem.adjustRangeFirst(DataValueCellEditor.this.dataPanel.getSelectedTreePath());
                    DataValueCellEditor.this.buttonPanel.enableNavigationButtons(dataItem);
                }
            }
        });
        this.buttonPanel.addLastButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataValueCellEditor.this.cancelCellEditing();
                DataItem dataItem = DataValueCellEditor.this.getCurrentDataItem();
                if (dataItem != null) {
                    dataItem.adjustRangeLast(DataValueCellEditor.this.dataPanel.getSelectedTreePath());
                    DataValueCellEditor.this.buttonPanel.enableNavigationButtons(dataItem);
                }
            }
        });
        this.buttonPanel.addPreviousButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataValueCellEditor.this.cancelCellEditing();
                DataItem dataItem = DataValueCellEditor.this.getCurrentDataItem();
                if (dataItem != null) {
                    dataItem.adjustRangePrevious(DataValueCellEditor.this.dataPanel.getSelectedTreePath());
                    DataValueCellEditor.this.buttonPanel.enableNavigationButtons(dataItem);
                }
            }
        });
        this.buttonPanel.addNextButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataValueCellEditor.this.cancelCellEditing();
                DataItem dataItem = DataValueCellEditor.this.getCurrentDataItem();
                if (dataItem != null) {
                    dataItem.adjustRangeNext(DataValueCellEditor.this.dataPanel.getSelectedTreePath());
                    DataValueCellEditor.this.buttonPanel.enableNavigationButtons(dataItem);
                }
            }
        });
        this.dataTipColumnPanel = new JPanel(new BorderLayout());
        this.dataTipColumnPanel.setOpaque(false);
        JButton button = DataArrayNavigationPanel.createButton(OracleIcons.getIcon((String)"green_dot.png"), null);
        this.dataTipColumnPanel.add((Component)button, "Center");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataItem dataItem = DataValueCellEditor.this.getCurrentDataItem();
                if (dataItem != null) {
                    DataTipDisplayer dataTipDisplayer = new DataTipDisplayer(DataValueCellEditor.this.dataPanel, dataItem, DataValueCellEditor.this.dataPanel.getDataTipModelIndices());
                    dataTipDisplayer.prepareAndShowQuickInspect();
                }
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, final DataItem dataItem) {
        String dataItemTypeName = null;
        try {
            dataItemTypeName = dataItem.getFullyQualifiedActualType();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dataItem != null && "java.lang.StackTraceElement".equals(dataItemTypeName)) {
            this.hyperlinkButton.setAction((Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Debugger debugger = Debugger.getDebugger();
                    if (debugger != null) {
                        String stackTraceLine = "at " + dataItem.getValue();
                        Workspace workspace = DataValueCellEditor.this.dataPanel.getDebuggingProcess().getWorkspace();
                        Project project = DataValueCellEditor.this.dataPanel.getDebuggingProcess().getProject();
                        URL urlForNonJavaStackTraceLines = RunLogPage.getURLFromStackTraceLine((String)stackTraceLine);
                        if (urlForNonJavaStackTraceLines != null) {
                            debugger.showSourceFileForStackTraceLine(workspace, project, urlForNonJavaStackTraceLines);
                        } else {
                            debugger.showSourceFileForStackTraceLine(workspace, project, stackTraceLine);
                        }
                    }
                }
            });
            this.hyperlinkButton.setText(dataItem.getValue());
            this.hyperlinkButton.setToolTipText(dataItem.getValue());
            isSelected = true;
            this.hyperlinkButton.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            this.hyperlinkButtonPanel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            this.hyperlinkButton.setForegroundOnHover(isSelected ? Colors.HYPERLINK_SELECTED_HOVER : Colors.HYPERLINK_HOVER);
            this.hyperlinkButton.setForeground(isSelected ? Colors.HYPERLINK_SELECTED : Colors.HYPERLINK);
            return this.hyperlinkButtonPanel;
        }
        this.label.setForeground(table.getSelectionForeground());
        this.label.setBackground(table.getSelectionBackground());
        this.label.setFont(table.getFont());
        this.label.setText(value == null ? "" : value.toString());
        this.buttonPanel.updatePanel(dataItem);
        this.buttonPanel.setForeground(table.getSelectionForeground());
        this.buttonPanel.setBackground(table.getSelectionBackground());
        this.valueColumnPanel.revalidate();
        return this.valueColumnPanel;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            int row;
            DataItem dataItem;
            int col;
            MouseEvent mouseEvent = (MouseEvent)anEvent;
            JTable table = this.dataPanel.getDataTable().getTable();
            int modelCol = table.convertColumnIndexToModel(col = table.columnAtPoint(mouseEvent.getPoint()));
            if (modelCol == 1 && (dataItem = this.dataPanel.getDataItemForRow(row = table.rowAtPoint(mouseEvent.getPoint()))) != null) {
                String dataItemTypeName = null;
                try {
                    dataItemTypeName = dataItem.getFullyQualifiedActualType();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ("java.lang.StackTraceElement".equals(dataItemTypeName)) {
                    return true;
                }
                boolean showingArrayNavigationButtons = dataItem.shouldShowArrayNavigationButtons();
                boolean showingObjectPrefButton = dataItem.canAdjustObjectPreferences();
                if (showingArrayNavigationButtons || showingObjectPrefButton) {
                    this.buttonPanel.updatePanel(dataItem);
                    int w = this.buttonPanel.getPreferredSize().width;
                    Rectangle r = table.getCellRect(row, col, true);
                    int leftBorderOfButtons = r.x + r.width - w;
                    double mouseX = mouseEvent.getPoint().getX();
                    return mouseX < (double)(r.x + r.width) && mouseX > (double)leftBorderOfButtons;
                }
            }
        }
        return false;
    }

    void setNavigationButtonsPermitted(boolean navigationButtonsPermitted) {
        this.buttonPanel.setNavigationButtonsPermitted(navigationButtonsPermitted);
    }
}

