/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import javax.swing.tree.TreePath;
import oracle.jdevimpl.runner.debug.DataInfoPath;
import oracle.jdevimpl.runner.debug.DataTable;
import oracle.jdevimpl.runner.debug.DataTableUtils;
import oracle.jdevimpl.runner.debug.DataTreeTableModel;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

final class DataPanelSelectionTracker {
    private DataInfoPath selection;

    DataPanelSelectionTracker() {
    }

    void saveSelection(DataTable dataTable, DebuggingProcess debuggingProcess) {
        this.selection = this.getCurrentSelection(dataTable, debuggingProcess);
    }

    void restoreSelection(DataTable dataTable, DataTreeTableModel model, boolean scrollToVisible, boolean selectFirstRowIfNoPreviousSelection) {
        TreePath treePath = null;
        if (this.selection != null) {
            treePath = dataTable.makeVisible(model, this.selection);
        }
        if (treePath == null && selectFirstRowIfNoPreviousSelection) {
            treePath = dataTable.getPathForRow(0);
        }
        if (treePath != null) {
            DataTableUtils.selectTreeTablePath(dataTable, treePath, scrollToVisible);
        }
    }

    DataInfoPath getCurrentSelection(DataTable dataTable, DebuggingProcess debuggingProcess) {
        if (dataTable == null) {
            return null;
        }
        TreePath treePath = dataTable.getSelectionPath();
        if (treePath != null) {
            return DataInfoPath.convertTreePathToDataInfoPath(treePath, debuggingProcess);
        }
        return null;
    }

    void clearSelection() {
        this.selection = null;
    }
}

