/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdevimpl.debugger.BreakpointsWindowSettings;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.WindowSettingsColumnManager;

public final class BreakpointsWindowSettingsPanel
extends DefaultTraversablePanel
implements ActionListener {
    private static final long serialVersionUID = -7163424383308931613L;
    private JComboBox<String> vmChooser;
    private JLabel vmChooserLabel;
    private JCheckBox[] showColumnCheckBoxes;
    private JPanel optionPanel;
    private JPanel chooseColumnsPanel;
    private Map<String, boolean[]> showColumnsMap = new HashMap<String, boolean[]>();
    private transient BreakpointsWindowSettings settings;
    private JRadioButton bpScopeGlobalRadio;
    private JRadioButton bpScopeWorkspaceRadio;
    private JRadioButton bpScopeProjectRadio;
    private MultiLineLabel disclaimerLabel;
    private JPanel spacer;

    public BreakpointsWindowSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_breakpointswinsetpanel_html");
        this.showColumnCheckBoxes = new JCheckBox[10];
        for (int i = 0; i < 10; ++i) {
            this.showColumnCheckBoxes[i] = new JCheckBox();
            this.showColumnCheckBoxes[i].addActionListener(this);
        }
        this.showColumnCheckBoxes[0].setEnabled(false);
        this.bpScopeGlobalRadio = new JRadioButton();
        this.bpScopeWorkspaceRadio = new JRadioButton();
        this.bpScopeProjectRadio = new JRadioButton();
        ButtonGroup group = new ButtonGroup();
        group.add(this.bpScopeGlobalRadio);
        group.add(this.bpScopeWorkspaceRadio);
        group.add(this.bpScopeProjectRadio);
        ResourceUtils.resButton((AbstractButton)this.bpScopeGlobalRadio, (String)DbgArb.getString(656));
        ResourceUtils.resButton((AbstractButton)this.bpScopeWorkspaceRadio, (String)DbgArb.getString(657));
        ResourceUtils.resButton((AbstractButton)this.bpScopeProjectRadio, (String)DbgArb.getString(658));
        this.disclaimerLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), DbgArb.format(862, DbgArb.getString(337)));
        this.spacer = new JPanel();
        this.setLayout(new GridBagLayout());
        this.vmChooser = new JComboBox();
        this.vmChooserLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.vmChooserLabel, this.vmChooser, (String)DbgArb.getString(861));
        this.optionPanel = new JPanel(new GridBagLayout());
        this.chooseColumnsPanel = new JPanel(new GridLayout(0, 2, 0, 0));
    }

    private JPanel makeChooseColumnsPanel(String vmName) {
        HashStructure hash = this.settings.getHash();
        this.chooseColumnsPanel = new JPanel(new GridLayout(0, 2, 0, 0));
        this.chooseColumnsPanel.setBorder(BorderFactory.createTitledBorder(RunMgrArb.getString(91)));
        boolean[] columnsVisible = this.showColumnsMap.get(vmName);
        this.chooseColumnsPanel.removeAll();
        List<String> columnNames = WindowSettingsColumnManager.getColumnNamesInPreferences(hash, vmName);
        for (int i = 0; i < columnNames.size(); ++i) {
            ResourceUtils.resButton((AbstractButton)this.showColumnCheckBoxes[i], (String)columnNames.get(i));
            this.showColumnCheckBoxes[i].setSelected(columnsVisible[i]);
            this.chooseColumnsPanel.add(this.showColumnCheckBoxes[i]);
        }
        return this.chooseColumnsPanel;
    }

    private JPanel makeBPScopePanel() {
        JPanel bpScopePanel = new JPanel(new GridLayout(3, 0, 0, 0));
        bpScopePanel.setBorder(BorderFactory.createTitledBorder(DbgArb.getString(655)));
        bpScopePanel.add(this.bpScopeGlobalRadio);
        bpScopePanel.add(this.bpScopeWorkspaceRadio);
        bpScopePanel.add(this.bpScopeProjectRadio);
        return bpScopePanel;
    }

    private BreakpointsWindowSettings getSettings(TraversableContext tc) {
        return BreakpointsWindowSettings.getInstance((PropertyStorage)tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        this.settings = this.getSettings(tc);
        HashStructure hash = this.settings.getHash();
        this.removeAll();
        this.showColumnsMap.clear();
        List<String> vmNames = WindowSettingsColumnManager.getVMNames(hash);
        if (vmNames.size() <= 0) {
            this.add((Component)this.disclaimerLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(6, 0, 16, 0), 0, 0));
            this.add(this.spacer, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.vmChooser.removeAllItems();
        if (vmNames.size() > 0) {
            int y = 0;
            for (String vmName : vmNames) {
                this.vmChooser.addItem(vmName);
                boolean[] visibilities = new boolean[10];
                for (int j = 0; j < 10; ++j) {
                    visibilities[j] = WindowSettingsColumnManager.getColumnVisible(hash, vmName, j);
                }
                this.showColumnsMap.put(vmName, visibilities);
            }
            this.vmChooser.setEditable(false);
            if (vmNames.size() > 1) {
                this.add(this.vmChooserLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 0, 8, 8), 0, 0));
                this.add(this.vmChooser, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 8, 0), 0, 0));
            }
            this.add(this.optionPanel, new GridBagConstraints(0, y++, 2, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.makeBPScopePanel(), new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
            this.add(new JLabel(), new GridBagConstraints(0, y++, 0, 1, 1.0, 1.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
            this.vmChooser.addActionListener(this);
            this.vmChooser.setSelectedIndex(0);
            for (int i = 0; i < 10; ++i) {
                this.showColumnCheckBoxes[i].addActionListener(this);
            }
        }
        this.bpScopeGlobalRadio.setSelected(false);
        this.bpScopeWorkspaceRadio.setSelected(false);
        this.bpScopeProjectRadio.setSelected(false);
        String bpScope = this.settings.getBreakpointScope();
        if (bpScope.equals("global")) {
            this.bpScopeGlobalRadio.setSelected(true);
        } else if (bpScope.equals("project")) {
            this.bpScopeProjectRadio.setSelected(true);
        } else {
            this.bpScopeWorkspaceRadio.setSelected(true);
        }
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        BreakpointsWindowSettings settings = this.getSettings(tc);
        HashStructure hash = settings.getHash();
        for (String vmName : this.showColumnsMap.keySet()) {
            boolean[] columnVisibilities = this.showColumnsMap.get(vmName);
            for (int i = 0; i < columnVisibilities.length; ++i) {
                WindowSettingsColumnManager.setColumnVisible(hash, vmName, i, columnVisibilities[i]);
            }
        }
        this.vmChooser.removeActionListener(this);
        for (int i = 0; i < 10; ++i) {
            this.showColumnCheckBoxes[i].removeActionListener(this);
        }
        String bpScope = this.bpScopeGlobalRadio.isSelected() ? "global" : (this.bpScopeProjectRadio.isSelected() ? "project" : "workspace");
        settings.setBreakpointScope(bpScope);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.vmChooser && this.vmChooser.getSelectedIndex() != -1) {
            String newVM = this.vmChooser.getSelectedItem().toString();
            String window = DbgArb.getString(337);
            String title = DbgArb.format(863, window, newVM);
            TitledBorder border = BorderFactory.createTitledBorder(title);
            this.optionPanel.setBorder(border);
            this.optionPanel.removeAll();
            int y = 0;
            this.optionPanel.add((Component)this.makeChooseColumnsPanel(newVM), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 18, 2, new Insets(8, 8, 0, 0), 0, 0));
            this.optionPanel.revalidate();
        } else {
            for (int i = 0; i < this.showColumnCheckBoxes.length; ++i) {
                if (e.getSource() != this.showColumnCheckBoxes[i]) continue;
                String currentVM = this.vmChooser.getSelectedItem().toString();
                boolean[] visibilities = this.showColumnsMap.get(currentVM);
                visibilities[i] = this.showColumnCheckBoxes[i].isSelected();
                break;
            }
        }
    }
}

