/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.ide.ExtensionRegistry;
import oracle.jdevimpl.debugger.plugin.hooks.DebuggerProtocolHelper;
import oracle.jdevimpl.debugger.support.DebugConnector;
import oracle.jdevimpl.debugger.support.DebugConnectorAttributes;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugConnectorHook;

public final class DebugFactory {
    private static DebuggerProtocolHelper debuggerProtocolHelper;
    public static final int FACTORY_JPDA_Attach;
    public static final String JPDA_ATTACH_PROTOCOL = "jpda";
    public static final int FACTORY_JPDA_Listen;
    public static final String JPDA_LISTEN_PROTOCOL = "jpdalisten";
    public static final int FACTORY_Probe_Attach = 2;
    public static final int FACTORY_Probe = 2;
    private static int nextDebugConnectorCookie;
    private static Map<Integer, DebugConnectorAttributes> debugConnectors;

    private DebugFactory() {
    }

    public static void setProtocolSpecificHelper(DebuggerProtocolHelper helper) {
        debuggerProtocolHelper = helper;
    }

    public static synchronized int registerDebugConnector(DebugConnectorAttributes attributes) throws IllegalArgumentException {
        if (attributes == null) {
            throw new IllegalArgumentException("Null argument");
        }
        if (DebugFactory.hasDebugConnectorWithProtocol(attributes.getProtocol())) {
            throw new IllegalArgumentException("Duplicate DebugConnector protocol");
        }
        int cookie = nextDebugConnectorCookie++;
        debugConnectors.put(cookie, attributes);
        return cookie;
    }

    @Deprecated
    public static synchronized void registerDebugConnector(int i, final Class connectorClass, final String version) {
        if (i != 2) {
            throw new IllegalArgumentException("Unknown DebugConnector");
        }
        debugConnectors.put(i, new DebugConnectorAttributes(){

            @Override
            public Class getDebugConnectorClass() {
                return connectorClass;
            }

            @Override
            public String getDisplayName() {
                return "Probe";
            }

            @Override
            public String getProtocol() {
                return this.getDisplayName();
            }

            @Override
            public String getVersion() {
                return version;
            }

            @Override
            public String getRemoteConnectDialogTitle() {
                return DbgArb.getString(183);
            }

            @Override
            public boolean supportsRemoteDebugging() {
                return false;
            }

            @Override
            public String[] getRemoteConnectHelpStrings() {
                return new String[0];
            }

            @Override
            public boolean needsToolsJar() {
                return false;
            }
        });
    }

    public static synchronized DebugConnector newInstance(int cookie) {
        Class c;
        DebugConnectorAttributes connector = debugConnectors.get(cookie);
        if (connector != null && (c = connector.getDebugConnectorClass()) != null) {
            try {
                return (DebugConnector)c.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static synchronized int getDebugConnectorCookie(String protocol) {
        DebugFactory.getNewDebugConnectorsFromHook();
        for (Map.Entry<Integer, DebugConnectorAttributes> entry : debugConnectors.entrySet()) {
            if (!entry.getValue().getProtocol().equals(protocol)) continue;
            return entry.getKey();
        }
        return -1;
    }

    private static boolean hasDebugConnectorWithProtocol(String protocol) {
        for (Map.Entry<Integer, DebugConnectorAttributes> entry : debugConnectors.entrySet()) {
            if (!entry.getValue().getProtocol().equals(protocol)) continue;
            return true;
        }
        return false;
    }

    public static synchronized String getDebugConnectorProtocol(int debugConnectorCookie) {
        for (Map.Entry<Integer, DebugConnectorAttributes> entry : debugConnectors.entrySet()) {
            if (entry.getKey() != debugConnectorCookie) continue;
            return entry.getValue().getProtocol();
        }
        return null;
    }

    public static synchronized String getDebugConnectorDisplayName(int debugConnectorCookie) {
        for (Map.Entry<Integer, DebugConnectorAttributes> entry : debugConnectors.entrySet()) {
            if (entry.getKey() != debugConnectorCookie) continue;
            return entry.getValue().getDisplayName();
        }
        return null;
    }

    public static synchronized String[] getDebugConnectorRemoteConnectHelpStrings(int debugConnectorCookie) {
        for (Map.Entry<Integer, DebugConnectorAttributes> entry : debugConnectors.entrySet()) {
            if (entry.getKey() != debugConnectorCookie) continue;
            return entry.getValue().getRemoteConnectHelpStrings();
        }
        return new String[0];
    }

    public static synchronized String getDebugConnectorRemoteConnectDialogTitle(int debugConnectorCookie) {
        for (Map.Entry<Integer, DebugConnectorAttributes> entry : debugConnectors.entrySet()) {
            if (entry.getKey() != debugConnectorCookie) continue;
            return entry.getValue().getRemoteConnectDialogTitle();
        }
        return null;
    }

    public static synchronized boolean debugConnectorNeedsToolsJar(int debugConnectorCookie) {
        for (Map.Entry<Integer, DebugConnectorAttributes> entry : debugConnectors.entrySet()) {
            if (entry.getKey() != debugConnectorCookie) continue;
            return entry.getValue().needsToolsJar();
        }
        return false;
    }

    public static int getDefaultDebugConnectorCookie() {
        return FACTORY_JPDA_Attach;
    }

    public static String getDefaultProtocol() {
        return JPDA_ATTACH_PROTOCOL;
    }

    public static String getDefaultRemoteDialogTitle() {
        return DbgArb.getString(181);
    }

    public static synchronized List<String> getRemoteProtocols() {
        DebugFactory.getNewDebugConnectorsFromHook();
        ArrayList<String> remoteProtocols = new ArrayList<String>();
        for (DebugConnectorAttributes connector : debugConnectors.values()) {
            if (!connector.supportsRemoteDebugging()) continue;
            remoteProtocols.add(connector.getProtocol());
        }
        return remoteProtocols;
    }

    private static void getNewDebugConnectorsFromHook() {
        List<DebugConnectorAttributes> connectors = DebugConnectorHook.getNewDebugConnectors();
        for (DebugConnectorAttributes connector : connectors) {
            try {
                DebugFactory.registerDebugConnector(connector);
            }
            catch (IllegalArgumentException iae) {
                StringBuilder buf = new StringBuilder();
                buf.append("DebugConnector protocol '");
                buf.append(connector.getProtocol());
                buf.append("' of DebugConnector '");
                buf.append(connector.getClass().getName());
                buf.append("' conflicts with another DebugConnector");
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, buf.toString());
            }
        }
    }

    static {
        nextDebugConnectorCookie = 10443223;
        debugConnectors = new HashMap<Integer, DebugConnectorAttributes>(6);
        FACTORY_JPDA_Attach = DebugFactory.registerDebugConnector(new DebugConnectorAttributes(){

            @Override
            public Class getDebugConnectorClass() {
                if (debuggerProtocolHelper != null && debuggerProtocolHelper.canGetDebugConnectorClassAndVersion()) {
                    return debuggerProtocolHelper.getDebugConnectorAttachClass();
                }
                throw new IllegalStateException("DebugFactory cannot start debugger because JDI DebuggerProtocolHelper not found");
            }

            @Override
            public String getDisplayName() {
                return DbgArb.getString(321);
            }

            @Override
            public String getProtocol() {
                return DebugFactory.JPDA_ATTACH_PROTOCOL;
            }

            @Override
            public String getVersion() {
                if (debuggerProtocolHelper != null && debuggerProtocolHelper.canGetDebugConnectorClassAndVersion()) {
                    return debuggerProtocolHelper.getDebugConnectorAttachVersion();
                }
                return null;
            }

            @Override
            public String getRemoteConnectDialogTitle() {
                return DbgArb.getString(181);
            }

            @Override
            public String[] getRemoteConnectHelpStrings() {
                return new String[]{DbgArb.getString(323), DbgArb.getString(324), DbgArb.getString(325), DbgArb.getString(326)};
            }

            @Override
            public boolean supportsRemoteDebugging() {
                return true;
            }

            @Override
            public boolean needsToolsJar() {
                return true;
            }
        });
        FACTORY_JPDA_Listen = DebugFactory.registerDebugConnector(new DebugConnectorAttributes(){

            @Override
            public Class getDebugConnectorClass() {
                if (debuggerProtocolHelper != null && debuggerProtocolHelper.canGetDebugConnectorClassAndVersion()) {
                    return debuggerProtocolHelper.getDebugConnectorListenClass();
                }
                throw new IllegalStateException("DebugFactory cannot start debugger because JDI DebuggerProtocolHelper not found");
            }

            @Override
            public String getDisplayName() {
                return DbgArb.getString(322);
            }

            @Override
            public String getProtocol() {
                return DebugFactory.JPDA_LISTEN_PROTOCOL;
            }

            @Override
            public String getVersion() {
                if (debuggerProtocolHelper != null && debuggerProtocolHelper.canGetDebugConnectorClassAndVersion()) {
                    return debuggerProtocolHelper.getDebugConnectorListenVersion();
                }
                return null;
            }

            @Override
            public String getRemoteConnectDialogTitle() {
                return DbgArb.getString(182);
            }

            @Override
            public String[] getRemoteConnectHelpStrings() {
                return new String[]{DbgArb.getString(327), DbgArb.getString(328), DbgArb.getString(329), DbgArb.getString(330)};
            }

            @Override
            public boolean supportsRemoteDebugging() {
                return true;
            }

            @Override
            public boolean needsToolsJar() {
                return true;
            }
        });
    }
}

