/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.support;

import java.util.ArrayList;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHasExpired;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;

public interface DebugClassInfo
extends DebugHasExpired {
    public static final int CLASS_ACCESS_PUBLIC = 1;
    public static final int CLASS_ACCESS_FINAL = 16;
    public static final int CLASS_ACCESS_SUPER = 32;
    public static final int CLASS_ACCESS_INTERFACE = 512;
    public static final int CLASS_ACCESS_ABSTRACT = 1024;

    public String getName();

    public String getPackage();

    public String getPackagePath();

    public String getNameWithoutPackage();

    public String getGenericSignature();

    public int getAccess();

    public boolean isInterface();

    public boolean isPrimitive();

    public boolean isObject();

    public boolean isNotYetLoadedType();

    public boolean isArray();

    public int getSizeOfObject();

    public long countObjectsOfClass();

    public int countMemoryOfClass();

    public DebugDataObjectInfo getClassObject();

    public DebugDataObjectInfo getClassLoaderObject();

    public DebugClassLoaderInfo getClassLoader();

    public String getPrimarySourceFilename();

    public String getSourceFilename();

    public DebugClassInfo getSuperClass(int var1);

    public int getMethodCount();

    public DebugMethodInfo[] getMethods();

    default public DebugMethodInfo[] getDefaultMethods() {
        if (this.isInterface()) {
            DebugMethodInfo[] methods = this.getMethods();
            ArrayList<DebugMethodInfo> defaultMethods = new ArrayList<DebugMethodInfo>();
            for (DebugMethodInfo info : methods) {
                if (!info.isDefault()) continue;
                defaultMethods.add(info);
            }
            return defaultMethods.toArray(new DebugMethodInfo[defaultMethods.size()]);
        }
        throw new IllegalArgumentException("Invalid to call on non-interface object");
    }

    public int getStaticFieldCount();

    public DebugFieldInfo[] getStaticFields();

    public DebugFieldInfo getStaticField(int var1);

    public int getStaticFieldCount(int var1);

    public DebugFieldInfo[] getStaticFields(int var1);

    public DebugFieldInfo getStaticField(int var1, int var2);

    public int getStaticFieldCount(int var1, boolean var2);

    public DebugFieldInfo[] getStaticFields(int var1, boolean var2);

    public DebugFieldInfo getStaticField(int var1, boolean var2, int var3);

    public DebugFieldInfo getStaticField(String var1);

    public int getFieldCount(int var1);

    public DebugFieldInfo[] getFields(int var1);

    public DebugFieldInfo getField(int var1, int var2);

    public int getFieldCount(int var1, boolean var2);

    public DebugFieldInfo[] getFields(int var1, boolean var2);

    public DebugFieldInfo getField(int var1, boolean var2, int var3);

    public int getFieldCount(int var1, boolean var2, boolean var3);

    public DebugFieldInfo[] getFields(int var1, boolean var2, boolean var3);

    public DebugFieldInfo getField(int var1, boolean var2, boolean var3, int var4);

    public boolean isDebuggable();

    public void setDebuggable(boolean var1);

    public boolean isObfuscated();

    public boolean isCodeCoverage();

    public void setCodeCoverage(boolean var1);

    public void discardCodeCoverage();

    public double getCodeCoverageRatio();

    public DebugClassInfo[] getInterfaces();

    public DebugClassInfo[] getInterfaces(int var1);

    public int getLanguage();

    public boolean isEnum();

    public DebugFieldInfo[] getEnumConstants();

    public int getConstantPoolCount();

    public byte[] getConstantPool();
}

