/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.spnego;

import java.io.IOException;
import oracle.security.spnego.ASNReader;
import oracle.security.spnego.ASNWriter;
import oracle.security.spnego.IType;
import oracle.security.spnego.Tag;

public abstract class Type
implements IType {
    protected String name;
    protected Tag tag;
    protected Object value;
    protected Object defaultValue;
    protected boolean optional;

    protected Type(String name, Tag tag) {
        this.name = new String(name);
        if (tag != null) {
            this.tag = (Tag)tag.clone();
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void name(String name) {
        this.name = new String(name);
    }

    @Override
    public Tag tag() {
        return this.tag;
    }

    @Override
    public void decode(ASNReader is) throws IOException {
        RuntimeException x = new RuntimeException("Subclass should override encode() method");
        throw x;
    }

    @Override
    public void encode(ASNWriter os) throws IOException {
        RuntimeException x = new RuntimeException("Subclass should override encode() method");
        throw x;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public void value(Object value) {
        this.value = value;
    }

    @Override
    public Object defaultValue() {
        return this.defaultValue;
    }

    @Override
    public void defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public void optional(boolean optional) {
        this.optional = optional;
    }

    @Override
    public boolean isBlank() {
        return this.value == null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Type)) {
            return false;
        }
        Type that = (Type)obj;
        if (that.tag == null || !that.tag.equals(this.tag)) {
            return false;
        }
        return this.sameValue(that.value);
    }

    protected boolean sameValue(Object obj) {
        if (this.value == null || obj == null) {
            return false;
        }
        return this.value.equals(obj);
    }
}

