/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.spnego;

import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import oracle.security.spnego.ASNException;
import oracle.security.spnego.ASNReader;
import oracle.security.spnego.ASNWriter;
import oracle.security.spnego.IType;
import oracle.security.spnego.Tag;
import oracle.security.spnego.Type;

public class OctetString
extends Type
implements IType {
    public OctetString() {
        super("", new Tag(4));
    }

    public OctetString(String name) {
        super(name, new Tag(4));
    }

    public OctetString(String name, Tag tag) {
        super(name, tag);
    }

    public OctetString(String name, Object value) {
        this(name, new Tag(4), value);
    }

    public OctetString(String name, Tag tag, Object value) {
        super(name, tag);
        if (value != null) {
            this.value = (byte[])((byte[])value).clone();
        }
        if (this.value != null) {
            this.defaultValue(this.value);
        }
    }

    public static OctetString getInstance(byte[] value) {
        return new OctetString("", value);
    }

    @Override
    public void value(Object value) {
        this.value = value instanceof OctetString ? (Object)((OctetString)value).byteArrayValue() : value;
    }

    @Override
    public void decode(ASNReader is) throws IOException {
        is.mark(Integer.MAX_VALUE);
        try {
            byte[] result = is.decodeOctetString(this);
            if (result == null) {
                throw new ASNException(1, "Decoding OCTET STRING");
            }
            this.value(result);
        }
        catch (IOException x) {
            if (x instanceof ASNException || x instanceof EOFException) {
                is.reset();
            }
            throw x;
        }
    }

    @Override
    public void encode(ASNWriter os) throws IOException {
        Object val = this.value();
        if (val != null) {
            os.encodeOctetString(this, (byte[])val);
        } else {
            val = this.defaultValue();
            if (val != null) {
                os.encodeOctetString(this, (byte[])val);
            } else if (!this.isOptional()) {
                throw new ASNException(0, "Encoding OCTET STRING");
            }
        }
    }

    public byte[] byteArrayValue() {
        return (byte[])this.value;
    }

    @Override
    protected boolean sameValue(Object obj) {
        byte[] other;
        if (obj == null) {
            return false;
        }
        try {
            other = (byte[])obj;
        }
        catch (ClassCastException x) {
            return false;
        }
        byte[] val = this.byteArrayValue();
        if (val == null) {
            return false;
        }
        if (val.length != other.length) {
            return false;
        }
        for (int i = 0; i < val.length; ++i) {
            if (val[i] == other[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("-- ");
        if (this.value != null) {
            sb.append("0x").append(new BigInteger(1, this.byteArrayValue()).toString(16));
        } else {
            sb.append("N/A");
        }
        return sb.toString();
    }
}

