/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.spnego;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import oracle.security.spnego.ASNWriter;
import oracle.security.spnego.IIterativeType;
import oracle.security.spnego.IType;
import oracle.security.spnego.Tag;
import oracle.security.spnego.Type;

public class DerEncoder
extends ASNWriter
implements Cloneable {
    BufferedOutputStream out;

    @Override
    public Object clone() {
        return new DerEncoder();
    }

    @Override
    public void open(OutputStream os) {
        if (this.out != null) {
            throw new IllegalStateException();
        }
        this.out = os instanceof BufferedOutputStream ? (BufferedOutputStream)os : new BufferedOutputStream(os, 10240);
    }

    @Override
    public void encodeAny(IType obj, Object val) throws IOException {
        if (val instanceof Boolean) {
            this.encodeBoolean(obj, (Boolean)val);
        } else if (val instanceof BigInteger) {
            this.encodeInteger(obj, (BigInteger)val);
        } else if (val instanceof IType) {
            ((IType)val).encode(this);
        } else {
            this.encodeOctetString(obj, (byte[])val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeObjectIdentifier(IType obj, String val) throws IOException {
        int i;
        Tag tag = obj.tag();
        StringTokenizer st = new StringTokenizer(val, ".");
        int[] component = new int[st.countTokens()];
        for (i = 0; i < component.length; ++i) {
            component[i] = Integer.parseInt(st.nextToken());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.encodeSubIdentifier(baos, component[0] * 40 + component[1]);
        for (i = 2; i < component.length; ++i) {
            this.encodeSubIdentifier(baos, component[i]);
        }
        byte[] ba = baos.toByteArray();
        if (tag.isExplicit() && !tag.isUniversal()) {
            ba = this.toTLV(6, ba);
        }
        BufferedOutputStream bufferedOutputStream = this.out;
        synchronized (bufferedOutputStream) {
            this.encode(tag);
            this.encode(ba.length);
            this.write(ba);
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeNull(IType obj) throws IOException {
        Tag tag = obj.tag();
        byte[] ba = new byte[]{};
        if (tag.isExplicit() && !tag.isUniversal()) {
            ba = this.toTLV(5, ba);
        }
        BufferedOutputStream bufferedOutputStream = this.out;
        synchronized (bufferedOutputStream) {
            this.encode(tag);
            this.encode(ba.length);
            this.write(ba);
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeBoolean(IType obj, Boolean val) throws IOException {
        Tag tag = obj.tag();
        byte[] ba = new byte[]{(byte)(val != false ? 1 : 0)};
        if (tag.isExplicit() && !tag.isUniversal()) {
            ba = this.toTLV(1, ba);
        }
        BufferedOutputStream bufferedOutputStream = this.out;
        synchronized (bufferedOutputStream) {
            this.encode(tag);
            this.encode(ba.length);
            this.write(ba);
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeInteger(IType obj, BigInteger val) throws IOException {
        Tag tag = obj.tag();
        byte[] ba = val.toByteArray();
        if ((ba[0] & 0x80) != 0) {
            throw new IllegalArgumentException("Illegal internal encoding");
        }
        if (tag.isExplicit() && !tag.isUniversal()) {
            ba = this.toTLV(2, ba);
        }
        BufferedOutputStream bufferedOutputStream = this.out;
        synchronized (bufferedOutputStream) {
            this.encode(tag);
            this.encode(ba.length);
            this.write(ba);
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeEnumerated(IType obj, BigInteger val) throws IOException {
        Tag tag = obj.tag();
        byte[] ba = val.toByteArray();
        if ((ba[0] & 0x80) != 0) {
            throw new IllegalArgumentException("Illegal internal encoding");
        }
        if (tag.isExplicit() && !tag.isUniversal()) {
            ba = this.toTLV(10, ba);
        }
        BufferedOutputStream bufferedOutputStream = this.out;
        synchronized (bufferedOutputStream) {
            this.encode(tag);
            this.encode(ba.length);
            this.write(ba);
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeString(int tagValue, IType obj, String val) throws IOException {
        Tag tag = obj.tag();
        if (tag == null) {
            tag = new Tag(tagValue, false);
        }
        byte[] ba = val.getBytes("UTF8");
        if (tag.isExplicit() && !tag.isUniversal()) {
            ba = this.toTLV(tagValue, ba);
        }
        BufferedOutputStream bufferedOutputStream = this.out;
        synchronized (bufferedOutputStream) {
            this.encode(tag);
            this.encode(ba.length);
            this.write(ba);
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeBitString(IType obj, byte[] val) throws IOException {
        Tag tag = obj.tag();
        byte[] ba = new byte[val.length + 1];
        System.arraycopy(val, 0, ba, 1, val.length);
        if (tag.isExplicit() && !tag.isUniversal()) {
            ba = this.toTLV(3, ba);
        }
        BufferedOutputStream bufferedOutputStream = this.out;
        synchronized (bufferedOutputStream) {
            this.encode(tag);
            this.encode(ba.length);
            this.write(ba);
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeOctetString(IType obj, byte[] val) throws IOException {
        Tag tag = obj.tag();
        if (tag.isExplicit() && !tag.isUniversal()) {
            val = this.toTLV(4, val);
        }
        BufferedOutputStream bufferedOutputStream = this.out;
        synchronized (bufferedOutputStream) {
            this.encode(tag);
            this.encode(val.length);
            this.write(val);
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeStructure(IIterativeType obj) throws IOException {
        Tag tag = obj.tag();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASNWriter local = (ASNWriter)this.clone();
        local.open(baos);
        ListIterator it = obj.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (element instanceof IType) {
                Type t = (Type)element;
                t.encode(local);
                continue;
            }
            for (Type t : (ArrayList)element) {
                t.encode(local);
            }
        }
        local.close();
        byte[] ba = baos.toByteArray();
        if (tag.isExplicit() && !tag.isUniversal()) {
            ba = this.toTLV(16, ba, tag.isConstructed());
        }
        BufferedOutputStream bufferedOutputStream = this.out;
        synchronized (bufferedOutputStream) {
            this.encode(tag);
            this.encode(ba.length);
            this.write(ba);
            this.flush();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b & 0xFF);
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.out = null;
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    private void encode(Tag tag) throws IOException {
        int value;
        int t = tag.getClazz();
        if (tag.isConstructed()) {
            t |= 0x20;
        }
        if ((value = tag.getValue()) < 31) {
            this.write(t | value);
        } else {
            this.write(t | 0x1F);
            for (t = value; t > 63; t -= 63) {
                this.write(63);
            }
            this.write(t);
        }
    }

    private void encode(int length) throws IOException {
        if (length < 128) {
            this.write(length);
            return;
        }
        if (length < 256) {
            this.write(-127);
            this.write(length);
            return;
        }
        if (length < 65536) {
            this.write(-126);
            this.write(length >> 8);
            this.write(length);
            return;
        }
        if (length < 0x1000000) {
            this.write(-125);
            this.write(length >> 16);
            this.write(length >> 8);
            this.write(length);
            return;
        }
        this.write(-124);
        this.write(length >> 24);
        this.write(length >> 16);
        this.write(length >> 8);
        this.write(length);
    }

    private byte[] toTLV(int universalValue, byte[] ba) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DerEncoder local = new DerEncoder();
        local.open(baos);
        local.encode(new Tag(universalValue));
        local.encode(ba.length);
        local.write(ba);
        local.close();
        return baos.toByteArray();
    }

    private byte[] toTLV(int universalValue, byte[] ba, boolean constructed) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DerEncoder local = new DerEncoder();
        local.open(baos);
        local.encode(new Tag(0, universalValue, true, constructed));
        local.encode(ba.length);
        local.write(ba);
        local.close();
        return baos.toByteArray();
    }

    private void encodeSubIdentifier(OutputStream os, int c) throws IOException {
        int i;
        byte[] ab = new byte[4];
        for (i = 0; i < 4; ++i) {
            ab[i] = (byte)(c & 0x7F);
            if ((c >>>= 7) == 0) break;
        }
        while (i > 0) {
            os.write((ab[i] | 0x80) & 0xFF);
            --i;
        }
        os.write(ab[0] & 0xFF);
    }
}

