/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.spnego;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import oracle.security.spnego.ASNException;
import oracle.security.spnego.ASNWriter;
import oracle.security.spnego.IIterativeType;
import oracle.security.spnego.IType;
import oracle.security.spnego.Tag;
import oracle.security.spnego.Type;

public abstract class CompoundType
extends Type
implements IIterativeType {
    protected ArrayList components;

    public CompoundType(String name, Tag tag) {
        super(name, tag == null ? null : new Tag(tag.getClazz(), tag.getValue(), tag.isExplicit(), true));
        this.initInternal();
    }

    @Override
    public void encode(ASNWriter os) throws IOException {
        if (!this.isBlank()) {
            os.encodeStructure(this);
        } else if (!this.isOptional()) {
            throw new ASNException(0, "Encoding COMPUND TYPE");
        }
    }

    @Override
    public void reset() {
        ((ArrayList)this.value).clear();
    }

    @Override
    public boolean isBlank() {
        return ((ArrayList)this.value).isEmpty();
    }

    @Override
    public ListIterator iterator() {
        return ((ArrayList)this.value).listIterator();
    }

    @Override
    public int size() {
        return this.components == null ? 0 : this.components.size();
    }

    protected void initInternal() {
        this.components = new ArrayList();
        this.value = new ArrayList();
    }

    protected ArrayList cloneComponents() {
        ArrayList result = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.components);
            oos.flush();
            baos.close();
            byte[] buffer = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
            ObjectInputStream ois = new ObjectInputStream(bais);
            result = (ArrayList)ois.readObject();
            bais.close();
            buffer = null;
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return result;
    }

    @Override
    protected boolean sameValue(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArrayList)) {
            return false;
        }
        if (((ArrayList)obj).size() != this.size()) {
            return false;
        }
        Iterator src = ((ArrayList)obj).iterator();
        ListIterator dst = this.iterator();
        while (src.hasNext() && dst.hasNext()) {
            IType td;
            IType ts = (IType)src.next();
            if (ts.equals(td = (IType)dst.next())) continue;
            return false;
        }
        return true;
    }
}

