/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.spnego;

import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import oracle.security.spnego.ASNException;
import oracle.security.spnego.ASNReader;
import oracle.security.spnego.ASNWriter;
import oracle.security.spnego.IType;
import oracle.security.spnego.Tag;
import oracle.security.spnego.Type;

public class ASNInteger
extends Type
implements IType {
    public ASNInteger() {
        super("", new Tag(2));
    }

    public ASNInteger(String name) {
        super(name, new Tag(2));
    }

    public ASNInteger(String name, Tag tag) {
        super(name, tag);
    }

    public ASNInteger(String name, Object value) {
        this(name, new Tag(2), value);
    }

    public ASNInteger(String name, Tag tag, Object value) {
        super(name, tag);
        this.value(value);
        if (this.value != null) {
            this.defaultValue(this.value);
        }
    }

    public static ASNInteger getInstance(String value) {
        return new ASNInteger("", new BigInteger(value));
    }

    public static ASNInteger getInstance(BigInteger value) {
        return new ASNInteger("", value);
    }

    public static ASNInteger getInstance(long value) {
        return new ASNInteger("", BigInteger.valueOf(value));
    }

    public static ASNInteger getInstance(ASNInteger value) {
        return new ASNInteger("", value);
    }

    @Override
    public void decode(ASNReader is) throws IOException {
        is.mark(Integer.MAX_VALUE);
        try {
            BigInteger result = is.decodeInteger(this);
            if (result == null) {
                throw new ASNException(1, "Decoding INTEGER");
            }
            this.value(result);
        }
        catch (IOException x) {
            if (x instanceof ASNException || x instanceof EOFException) {
                is.reset();
            }
            throw x;
        }
    }

    @Override
    public void encode(ASNWriter os) throws IOException {
        Object val = this.value();
        if (val != null) {
            os.encodeInteger(this, (BigInteger)val);
        } else {
            val = this.defaultValue();
            if (val != null) {
                os.encodeInteger(this, (BigInteger)val);
            } else if (!this.isOptional()) {
                throw new ASNException(0, "Decoding INTEGER");
            }
        }
    }

    @Override
    public void value(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            this.value = new BigInteger((String)value);
        } else if (value instanceof BigInteger) {
            this.value = (BigInteger)value;
        } else if (value instanceof ASNInteger) {
            this.value = ((ASNInteger)value).intValue();
        } else {
            throw new ClassCastException();
        }
    }

    public BigInteger intValue() {
        return (BigInteger)this.value;
    }

    @Override
    protected boolean sameValue(Object obj) {
        if (obj == null || !(obj instanceof BigInteger)) {
            return false;
        }
        BigInteger val = this.intValue();
        return val == null ? false : val.compareTo((BigInteger)obj) == 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("-- ");
        if (this.value != null) {
            BigInteger i = this.intValue();
            sb.append(i.toString());
            sb.append(" [0x").append(i.toString(16)).append("]");
        } else {
            sb.append("N/A");
        }
        return sb.toString();
    }
}

