/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.spnego;

import java.io.EOFException;
import java.io.IOException;
import oracle.security.spnego.ASNException;
import oracle.security.spnego.ASNReader;
import oracle.security.spnego.ASNWriter;
import oracle.security.spnego.IType;
import oracle.security.spnego.Tag;
import oracle.security.spnego.Type;

public class ASNBoolean
extends Type
implements IType {
    public static final ASNBoolean TRUE = new ASNBoolean("TRUE", Boolean.TRUE);
    public static final ASNBoolean FALSE = new ASNBoolean("FALSE", Boolean.FALSE);

    public ASNBoolean() {
        super("", new Tag(1));
    }

    public ASNBoolean(String name) {
        super(name, new Tag(1));
    }

    public ASNBoolean(String name, Tag tag) {
        super(name, tag);
    }

    public ASNBoolean(String name, Object value) {
        this(name, new Tag(1), value);
    }

    public ASNBoolean(String name, Tag tag, Object value) {
        super(name, tag);
        this.value(value);
        if (this.value != null) {
            this.defaultValue(this.value);
        }
    }

    public static ASNBoolean getInstance(String value) {
        return new ASNBoolean("", value);
    }

    public static ASNBoolean getInstance(Boolean value) {
        return new ASNBoolean("", value);
    }

    public static ASNBoolean getInstance(boolean value) {
        return new ASNBoolean("", new Boolean(value));
    }

    @Override
    public void decode(ASNReader is) throws IOException {
        is.mark(Integer.MAX_VALUE);
        try {
            Boolean result = is.decodeBoolean(this);
            if (result == null) {
                throw new ASNException(1, "Decoding BOOLEAN");
            }
            this.value(result);
        }
        catch (IOException x) {
            if (x instanceof ASNException || x instanceof EOFException) {
                is.reset();
            }
            throw x;
        }
    }

    @Override
    public void encode(ASNWriter os) throws IOException {
        Object val = this.value();
        if (val != null) {
            os.encodeBoolean(this, (Boolean)val);
        } else {
            val = this.defaultValue();
            if (val != null) {
                os.encodeBoolean(this, (Boolean)val);
            } else if (!this.isOptional()) {
                throw new ASNException(0, "Encoding BOOLEAN");
            }
        }
    }

    @Override
    public void value(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            this.value = new Boolean((String)value);
        } else if (value instanceof Boolean) {
            this.value = (Boolean)value;
        } else if (value instanceof ASNBoolean) {
            this.value = ((ASNBoolean)value).booleanValue();
        } else {
            throw new ClassCastException();
        }
    }

    public Boolean booleanValue() {
        return (Boolean)this.value;
    }

    @Override
    protected boolean sameValue(Object obj) {
        Boolean val = this.booleanValue();
        return val == null ? false : val.equals(obj);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("-- ");
        if (this.value != null) {
            sb.append(String.valueOf(this.booleanValue()));
        } else {
            sb.append("N/A");
        }
        return sb.toString();
    }
}

