/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.security.redaction.dialogs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.CardLayoutActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.EditorActionControl;
import oracle.dbtools.raptor.ui.controls.OptionalActionControl;
import oracle.dbtools.raptor.ui.controls.SideBySideActionControl;
import oracle.dbtools.raptor.ui.controls.SpinnerActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.security.redaction.controller.RedactController;
import oracle.dbtools.security.redaction.dialogs.AlterRedactPolicyAction;
import oracle.dbtools.security.redaction.dialogs.RedactConstants;
import oracle.dbtools.security.redaction.model.RedactColumn;
import oracle.dbtools.security.redaction.model.RedactModel;

public class AlterActionPropertyChangeListener
implements PropertyChangeListener {
    private AlterRedactPolicyAction alterActionDialog = null;
    private RedactController redactController2 = null;
    private RedactModel redactModel2 = null;
    private ComboBoxActionControl columnNameCtl = null;
    private TextBoxActionControl columnDescriptionCtl = null;
    private TextBoxActionControl policyDescriptionCtl = null;
    private EditorActionControl expressionEditorCtl = null;
    private SideBySideActionControl expressionEditorIconCtl = null;
    private CardLayoutActionControl functionCtl = null;

    public AlterActionPropertyChangeListener(AlterRedactPolicyAction alterRedactPolicyAction, RedactController redactController, RedactModel redactModel) {
        this.alterActionDialog = alterRedactPolicyAction;
        this.redactController2 = redactController;
        this.redactModel2 = redactModel;
        this.columnNameCtl = this.alterActionDialog.getColumnCtl();
        this.columnDescriptionCtl = this.alterActionDialog.getColumnDescriptionCtl();
        this.expressionEditorCtl = this.alterActionDialog.getExpressionEditorCtl();
        this.expressionEditorIconCtl = this.alterActionDialog.getExpressionEditorIconCtl();
        this.policyDescriptionCtl = this.alterActionDialog.getPolicyDescriptionCtl();
        this.functionCtl = this.alterActionDialog.getFunctionTypeCtl();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getNewValue();
        Object object2 = propertyChangeEvent.getOldValue();
        String string = propertyChangeEvent.getPropertyName();
        String string2 = propertyChangeEvent.getSource().getClass().getName();
        if (string == null) {
            return;
        }
        if ((ActionControl.Value)propertyChangeEvent.getNewValue() != null) {
            String string3 = ((ActionControl.Value)propertyChangeEvent.getNewValue()).get();
            this.updateColumnControl(string, string3);
        } else {
            this.updateColumnControl(string, null);
        }
    }

    public void updateColumnControl(String string, Object object) {
        String string2;
        String[] stringArray = new String[]{};
        String string3 = null;
        if (string == null) {
            return;
        }
        if (string.equals("redaction_column_name")) {
            string3 = (String)object;
            this.redactModel2.setColumnName(string3);
            string2 = this.redactModel2.getColumnDescriptionForGivenColumn(string3);
            this.redactModel2.setColumnDescription(string2);
            this.columnDescriptionCtl.set(string2);
            this.updateOldRedactModel(this.redactModel2, string3);
        }
        if (string.equals("redaction_alter_action") && object instanceof String) {
            Object object2;
            Object object4;
            String[] stringArray2;
            string2 = (String)object;
            if (string2 != null && string2.length() == 0) {
                string2 = null;
                this.redactController2.setActionType(null);
                return;
            }
            if (string2.equals(RedactConstants.REDACTION_ALTER_ACTION_TYPE_ADD_COLUMN)) {
                this.redactController2.setActionType("DBMS_REDACT.ADD_COLUMN");
                this.functionCtl.enableUI(true);
                this.columnNameCtl.enableUI(true);
                this.columnNameCtl.setEditable(true);
                this.expressionEditorCtl.setEditable(false);
                stringArray2 = this.redactModel2.getNonRedactedColumnNames();
                if (stringArray2 != null) {
                    this.columnNameCtl.reset(stringArray2);
                    this.redactModel2.setOldColumnName(stringArray2[0]);
                } else {
                    this.columnNameCtl.reset(stringArray);
                    this.redactModel2.setOldColumnName("");
                }
                this.columnDescriptionCtl.setEditable(true);
                this.policyDescriptionCtl.enableUI(true);
                this.policyDescriptionCtl.setEditable(true);
                this.expressionEditorIconCtl.enableUI(false);
                this.expressionEditorIconCtl.setEditable(false);
                object4 = this.expressionEditorIconCtl.getChildControls();
                Iterator object32 = object4.iterator();
                while (object32.hasNext()) {
                    object2 = (ActionControl)object32.next();
                    object2.enableUI(false);
                    object2.setEditable(false);
                }
                object2 = this.redactModel2.convertDatabaseToModelConstant("FULL REDACTION");
                this.functionCtl.setSelected(object2);
            }
            if (string2.equals(RedactConstants.REDACTION_ALTER_ACTION_TYPE_MODIFY_COLUMN)) {
                this.redactController2.setActionType("DBMS_REDACT.MODIFY_COLUMN");
                this.functionCtl.enableUI(true);
                this.columnNameCtl.enableUI(true);
                this.columnNameCtl.setEditable(true);
                stringArray2 = this.redactModel2.getRedactedColumnNames();
                if (stringArray2 != null) {
                    this.columnNameCtl.reset(stringArray2);
                    string3 = stringArray2[0];
                    this.redactModel2.setOldColumnName(string3);
                } else {
                    this.columnNameCtl.reset(stringArray);
                    this.redactModel2.setOldColumnName("");
                }
                this.columnDescriptionCtl.setEditable(true);
                this.expressionEditorCtl.setEditable(false);
                this.expressionEditorIconCtl.enableUI(false);
                this.expressionEditorIconCtl.setEditable(false);
                object4 = this.expressionEditorIconCtl.getChildControls();
                Iterator iterator = object4.iterator();
                while (iterator.hasNext()) {
                    object2 = (ActionControl)iterator.next();
                    object2.enableUI(false);
                    object2.setEditable(false);
                }
                this.updateOldRedactModel(this.redactModel2, string3);
            }
            if (string2.equals(RedactConstants.REDACTION_ALTER_ACTION_TYPE_DROP_COLUMN)) {
                this.redactController2.setActionType("DBMS_REDACT.DROP_COLUMN");
                this.functionCtl.enableUI(true);
                this.columnNameCtl.enableUI(true);
                this.columnNameCtl.setEditable(true);
                this.expressionEditorIconCtl.enableUI(false);
                stringArray2 = this.redactModel2.getRedactedColumnNames();
                if (stringArray2 != null) {
                    this.columnNameCtl.reset(stringArray2);
                    string3 = stringArray2[0];
                    this.redactModel2.setOldColumnName(string3);
                } else {
                    this.columnNameCtl.reset(stringArray);
                    this.redactModel2.setOldColumnName("");
                }
                this.columnDescriptionCtl.setEditable(false);
                this.policyDescriptionCtl.setEditable(false);
                this.expressionEditorIconCtl.enableUI(false);
                this.expressionEditorIconCtl.setEditable(false);
                object4 = this.expressionEditorIconCtl.getChildControls();
                Iterator iterator = object4.iterator();
                while (iterator.hasNext()) {
                    object2 = (ActionControl)iterator.next();
                    object2.enableUI(false);
                    object2.setEditable(false);
                }
                this.updateOldRedactModel(this.redactModel2, string3);
            }
            if (string2.equals(RedactConstants.REDACTION_ALTER_ACTION_TYPE_MODIFY_EXPRESSION)) {
                this.redactController2.setActionType("DBMS_REDACT.MODIFY_EXPRESSION");
                stringArray2 = this.expressionEditorIconCtl.getChildControls();
                for (ActionControl actionControl : stringArray2) {
                    actionControl.enableUI(true);
                    actionControl.setEditable(true);
                    object2 = actionControl.getChildControls();
                    if (object2 == null) continue;
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        ActionControl actionControl2 = (ActionControl)iterator.next();
                        if (actionControl2 == null) continue;
                        actionControl2.enableUI(true);
                        actionControl2.setEditable(true);
                    }
                }
                this.columnDescriptionCtl.setEditable(false);
                this.policyDescriptionCtl.setEditable(true);
                String string4 = this.redactModel2.convertDatabaseToModelConstant("FULL REDACTION");
                this.functionCtl.setSelected((Object)string4);
                this.functionCtl.enableUI(false);
                this.redactModel2.setOldFunctionType(this.redactModel2.convertToDMBS_Constant("FULL REDACTION"));
            }
        }
    }

    private void updateOldRedactModel(RedactModel redactModel, String string) {
        RedactColumn redactColumn = redactModel.findOldColumnDetails(string);
        if (redactColumn != null) {
            this.columnDescriptionCtl.set(redactColumn.getDescription());
            String string2 = redactModel.convertDatabaseToModelConstant(redactColumn.getFunctionType());
            this.functionCtl.setSelected((Object)string2);
            redactModel.setOldFunctionType(redactModel.convertToDMBS_Constant(redactColumn.getFunctionType()));
            List list = this.functionCtl.getChildControls();
            if (list != null) {
                for (ActionControl actionControl : list) {
                    List list2;
                    if (actionControl == null) continue;
                    if (actionControl.getName().equals("redaction_function_type_partial_panel")) {
                        list2 = actionControl.getChildControls();
                        if (list2 == null) continue;
                        for (ActionControl actionControl2 : list2) {
                            if (!actionControl2.getName().equals("redaction_function_parameters_partial")) continue;
                            ((TextBoxActionControl)actionControl2).set(redactColumn.getFunctionParameters());
                            redactModel.setFunctionParameters(redactColumn.getFunctionParameters());
                        }
                        continue;
                    }
                    if (actionControl.getName().equals("redaction_function_type_random_panel") || actionControl.getName().equals("redaction_function_type_none_panel") || actionControl.getName().equals("redaction_function_type_full_panel")) {
                        redactModel.resetFunctionParameters();
                        continue;
                    }
                    if (!actionControl.getName().equals("redaction_function_type_regexp_panel") || (list2 = actionControl.getChildControls()) == null) continue;
                    for (ActionControl actionControl2 : list2) {
                        BooleanCheckBoxActionControl booleanCheckBoxActionControl;
                        TextBoxActionControl textBoxActionControl;
                        Iterator iterator;
                        List list3;
                        if (actionControl2.getName().equals("redaction_regexp_pattern")) {
                            if (redactColumn.getRegexpPattern() != null) {
                                ((OptionalActionControl)actionControl2).set(true);
                                list3 = ((OptionalActionControl)actionControl2).getChildControls();
                                if (list3 != null && (iterator = list3.iterator()) != null) {
                                    textBoxActionControl = (TextBoxActionControl)iterator.next();
                                    textBoxActionControl.set(redactColumn.getRegexpPattern());
                                    redactModel.setRegexpPattern(redactColumn.getRegexpPattern());
                                }
                            } else {
                                ((OptionalActionControl)actionControl2).set(false);
                                list3 = ((OptionalActionControl)actionControl2).getChildControls();
                                if (list3 != null && (iterator = list3.iterator()) != null) {
                                    textBoxActionControl = (TextBoxActionControl)iterator.next();
                                    booleanCheckBoxActionControl = (BooleanCheckBoxActionControl)iterator.next();
                                }
                            }
                        }
                        if (actionControl2.getName().equals("redaction_regexp_replace_string")) {
                            if (redactColumn.getRegexpReplaceString() != null) {
                                ((OptionalActionControl)actionControl2).set(true);
                                list3 = ((OptionalActionControl)actionControl2).getChildControls();
                                if (list3 != null && (iterator = list3.iterator()) != null) {
                                    textBoxActionControl = (TextBoxActionControl)iterator.next();
                                    textBoxActionControl.set(redactColumn.getRegexpReplaceString());
                                    redactModel.setRegexpReplaceString(redactColumn.getRegexpReplaceString());
                                }
                            } else {
                                ((OptionalActionControl)actionControl2).set(false);
                                list3 = ((OptionalActionControl)actionControl2).getChildControls();
                                if (list3 != null && (iterator = list3.iterator()) != null) {
                                    textBoxActionControl = (TextBoxActionControl)iterator.next();
                                    booleanCheckBoxActionControl = (BooleanCheckBoxActionControl)iterator.next();
                                }
                            }
                        }
                        if (actionControl2.getName().equals("redaction_regexp_position")) {
                            ((SpinnerActionControl)actionControl2).set(Integer.valueOf(Integer.parseInt(redactColumn.getRegexpPosition())));
                            redactModel.setRegexpPosition(redactColumn.getRegexpPosition());
                        }
                        if (actionControl2.getName().equals("redaction_regexp_occurrence")) {
                            ((SpinnerActionControl)actionControl2).set(Integer.valueOf(Integer.parseInt(redactColumn.getRegexpOccurrence())));
                            redactModel.setRegexpOccurrence(redactColumn.getRegexpOccurrence());
                        }
                        if (!actionControl2.getName().equals("redaction_regexp_match_parameter")) continue;
                        if (redactColumn.getRegexpMatchParameters() != null) {
                            ((OptionalActionControl)actionControl2).set(true);
                            list3 = ((OptionalActionControl)actionControl2).getChildControls();
                            if (list3 == null || (iterator = list3.iterator()) == null) continue;
                            textBoxActionControl = (TextBoxActionControl)iterator.next();
                            textBoxActionControl.set(redactColumn.getRegexpMatchParameters());
                            redactModel.setRegexpMatchParameter(redactColumn.getRegexpMatchParameters());
                            continue;
                        }
                        ((OptionalActionControl)actionControl2).set(false);
                        list3 = ((OptionalActionControl)actionControl2).getChildControls();
                        if (list3 == null || (iterator = list3.iterator()) == null) continue;
                        textBoxActionControl = (TextBoxActionControl)iterator.next();
                        booleanCheckBoxActionControl = (BooleanCheckBoxActionControl)iterator.next();
                    }
                }
            }
        }
    }
}

