/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.specification;

import java.net.URL;
import java.nio.file.Path;
import oracle.ide.net.JarUtil;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.message.Scope;
import oracle.javatools.exports.specification.ExportLinkage;

public class SpecificationScope
extends Scope {
    private final ExportLinkage type;
    private final String key;
    private final URL file;

    public SpecificationScope(Scope scope, ExportLinkage type, String key, URL file, String description) {
        super(scope, description);
        if (scope == null) {
            throw new NullPointerException("scope == null");
        }
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        if (type == ExportLinkage.EMBEDDED && file == null) {
            throw new NullPointerException("file == null");
        }
        this.type = type;
        this.key = key;
        this.file = file;
    }

    public SpecificationScope(Scope scope, ExportLinkage type, String key) {
        this(scope, type, key, null, null);
        if (type != ExportLinkage.LIBRARY) {
            throw new IllegalStateException("type != LinkType.LIBRARY");
        }
    }

    public SpecificationScope(Scope scope, ExportLinkage type) {
        super(scope, null);
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        if (type == ExportLinkage.EMBEDDED) {
            throw new IllegalStateException("type == EMBEDDED");
        }
        if (type == ExportLinkage.LIBRARY) {
            throw new IllegalStateException("type == LIBRARY");
        }
        this.type = type;
        this.file = null;
        this.key = null;
    }

    public SpecificationScope(Scope scope, String description) {
        super(scope, description);
        this.type = null;
        this.file = null;
        this.key = null;
    }

    public SpecificationScope(String description) {
        super(null, description);
        this.type = null;
        this.file = null;
        this.key = null;
    }

    @Override
    public String toString(Path basePath) {
        StringBuilder builder = new StringBuilder();
        if (this.type != null) {
            switch (this.type) {
                case NONE: {
                    builder.append("none");
                    break;
                }
                case EMBEDDED: {
                    builder.append(Paths.relativize(JarUtil.getJarFileURL(this.file), basePath));
                    break;
                }
                case LIBRARY: {
                    if (this.file != null) {
                        builder.append(Paths.relativize(this.file, basePath));
                        break;
                    }
                    builder.append("library");
                    if (this.key == null) break;
                    builder.append('[').append(this.key).append(']');
                    break;
                }
                case ALL: {
                    builder.append("all");
                    break;
                }
                case NULL: {
                    builder.append("-");
                }
            }
            if (this.getDescription() != null) {
                builder.append(':').append(this.getDescription());
            }
        } else if (this.getDescription() != null) {
            builder.append(this.getDescription());
        }
        return builder.toString();
    }
}

