/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.report;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.report.IssuesReport;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ReportReader
extends DefaultHandler {
    private final Matcher pathPrefixMatcher;
    private final IssuesReport report;
    private Path path;
    private SAXParser parser;
    private Locator locator;
    private int locatorLine;
    private int locatorColumn;
    private Deque<String> stack;
    private List<DocumentModel> models;
    private Path workspace;
    private Path project;
    private Path directory;
    private Path file;
    private Map<String, String> ruleIds;
    private String ruleId;
    private String rule;
    private String variation;
    private DocumentModel model;
    private int line;
    private int column;
    private String message;
    private StringBuilder characters;

    public ReportReader(IssuesReport report) {
        this.report = report;
        String pattern = report.getPathPrefixPattern();
        this.pathPrefixMatcher = pattern != null ? Pattern.compile(pattern).matcher("") : null;
    }

    public void read(List<Path> paths) throws SAXException {
        for (Path path : paths) {
            this.read(path);
        }
    }

    public void read(List<Path> paths, Collection<SAXException> exceptions) {
        for (Path path : paths) {
            try {
                this.read(path);
            }
            catch (SAXException e) {
                exceptions.add(e);
            }
        }
    }

    public void read(Path path) throws SAXException {
        this.path = path;
        this.locator = null;
        this.locatorLine = 0;
        this.locatorColumn = 0;
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            if (this.parser == null) {
                this.parser = SAXParserFactory.newInstance().newSAXParser();
            }
            this.parser.parse((InputStream)new BufferedInputStream(stream), (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(String.format("Report file %s not read: %s", path, e), e);
        }
        catch (NoSuchFileException e) {
            throw new SAXException(String.format("Report file %s not found: %s", path, e), e);
        }
        catch (RuleNotFoundSAXException e) {
            return;
        }
        catch (LocatorSAXException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new LocatorSAXException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SAXException(String.format("Report file %s not read: %s", path, e), e);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.stack = new ArrayDeque<String>();
    }

    @Override
    public void endDocument() throws SAXException {
        this.stack = null;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (this.locator != null) {
            this.locatorLine = this.locator.getLineNumber();
            this.locatorColumn = this.locator.getColumnNumber();
        }
        switch (qualifiedName) {
            case "audit": {
                assert (this.stack.isEmpty());
                this.models = new ArrayList<DocumentModel>(1024);
                break;
            }
            case "model": {
                String modelId = attributes.getValue("id");
                if (modelId == null || modelId.isEmpty()) {
                    throw new LocatorSAXException("<model> id attribute required");
                }
                try {
                    int index = Integer.parseUnsignedInt(modelId.substring(1));
                    if (index != this.models.size()) {
                        throw new IllegalStateException("expected model id " + this.models.size() + "; got id " + index);
                    }
                    break;
                }
                catch (NumberFormatException e) {
                    throw new LocatorSAXException("model id \"" + modelId + "\" invalid");
                }
            }
            case "url": {
                if (!this.parents("file", "model")) break;
                this.characters = new StringBuilder();
                break;
            }
            case "rules": {
                this.ruleIds = new HashMap<String, String>();
                break;
            }
            case "rule": {
                this.ruleId = attributes.getValue("id");
                if (this.ruleId != null && !this.ruleId.isEmpty()) break;
                throw new LocatorSAXException("<rule> id attribute required");
            }
            case "name": {
                if (!this.parents("rule")) break;
                this.characters = new StringBuilder();
                break;
            }
            case "violation": {
                assert (this.models != null);
                String ruleId = attributes.getValue("rule");
                this.rule = this.ruleIds.get(ruleId);
                if (this.rule == null) {
                    throw new LocatorSAXException("violation rule id " + ruleId + " not mapped by <rules> element");
                }
                this.variation = attributes.getValue("variation");
                this.variation = this.variation != null ? this.variation.trim() : "";
                this.column = -1;
                this.line = -1;
                this.message = null;
                break;
            }
            case "location": {
                if (!this.parents("violation")) break;
                String modelIndex = attributes.getValue("model");
                if (modelIndex == null || modelIndex.isEmpty()) {
                    throw new LocatorSAXException("<location> model attribute required");
                }
                try {
                    int index = Integer.parseUnsignedInt(modelIndex.substring(1));
                    this.model = this.models.get(index);
                    assert (this.model != null) : "model " + index + " null" + this.at();
                    break;
                }
                catch (NumberFormatException e) {
                    throw new LocatorSAXException("model index \"" + modelIndex + "\" invalid");
                }
            }
            case "line-number": 
            case "column-offset": {
                if (!this.parents("location", "violation")) break;
                this.characters = new StringBuilder();
                break;
            }
            case "message": {
                if (!this.parents("violation")) break;
                this.characters = new StringBuilder();
            }
        }
        this.stack.push(qualifiedName);
    }

    private boolean parents(String ... names) {
        if (names.length == 1) {
            return names[0].equals(this.stack.peek());
        }
        Iterator<String> iterator = this.stack.iterator();
        for (String name : names) {
            if (iterator.hasNext() && name.equals(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void characters(char[] text, int offset, int length) throws SAXException {
        if (text != null && this.characters != null) {
            this.characters.append(text, offset, length);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        String top = this.stack.pop();
        assert (top.equals(qualifiedName));
        if (this.locator != null) {
            this.locatorLine = this.locator.getLineNumber();
            this.locatorColumn = this.locator.getColumnNumber();
        }
        switch (qualifiedName) {
            case "audit": {
                assert (this.stack.isEmpty());
                this.models = null;
                break;
            }
            case "url": {
                if (!this.parents("file", "model")) break;
                String text = this.characters.toString();
                if (!text.startsWith("file:")) {
                    throw new IllegalArgumentException("expected \"file:\" protocol URL, got \"" + text + '\"');
                }
                text = text.substring(5);
                if (this.pathPrefixMatcher != null) {
                    text = this.pathPrefixMatcher.reset(text).replaceFirst("");
                }
                Path path = Paths.get(text, new String[0]);
                if (text.endsWith(".jws")) {
                    assert (this.workspace == null) : "workspace " + this.workspace + " already set" + this.at();
                    this.workspace = path;
                    this.file = null;
                    this.directory = null;
                    this.project = null;
                } else if (text.endsWith(".jpr")) {
                    assert (this.workspace != null) : "workspace null for project " + path + this.at();
                    assert (!path.equals(this.project)) : "project " + path + " duplicated" + this.at();
                    this.project = path;
                    this.file = null;
                    this.directory = null;
                } else if (text.endsWith("/")) {
                    assert (this.workspace != null) : "workspace null for package " + path + this.at();
                    assert (!path.equals(this.directory)) : "directory " + path + " duplicated" + this.at();
                    this.directory = path;
                    this.file = null;
                } else {
                    assert (this.workspace != null) : "workspace null for file " + path + this.at();
                    assert (!path.equals(this.file)) : "file " + path + " duplicated" + this.at();
                    this.file = path;
                }
                this.models.add(new DocumentModel(this.workspace, this.project, this.directory, this.file));
                this.characters = null;
                break;
            }
            case "rules": {
                if (!this.ruleIds.isEmpty()) break;
                throw new RuleNotFoundSAXException("No violations found in " + this.path);
            }
            case "name": {
                if (!this.parents("rule")) break;
                String rule = this.characters.toString();
                this.ruleIds.put(this.ruleId, rule);
                this.ruleId = null;
                this.characters = null;
                break;
            }
            case "violation": {
                try {
                    this.report.issueReported(this.model.workspace, this.model.project, this.model.directory, this.model.file, this.line, this.column, this.rule, this.variation, this.message);
                }
                catch (Exception e) {
                    throw new LocatorSAXException("exception adding issue to report: " + e, e);
                }
                this.model = null;
                this.line = -1;
                this.column = -1;
                this.rule = null;
                this.variation = null;
                this.message = null;
                break;
            }
            case "line-number": {
                if (!this.parents("location", "violation")) break;
                try {
                    this.line = Integer.parseUnsignedInt(this.characters.toString());
                }
                catch (NumberFormatException e) {
                    throw new LocatorSAXException("line number \"" + this.characters + "\" invalid", e);
                }
                this.characters = null;
                break;
            }
            case "column-offset": {
                if (!this.parents("location", "violation")) break;
                try {
                    this.column = Integer.parseUnsignedInt(this.characters.toString()) + 1;
                }
                catch (NumberFormatException e) {
                    throw new LocatorSAXException("column offset \"" + this.characters + "\" invalid", e);
                }
                this.characters = null;
                break;
            }
            case "message": {
                if (!this.parents("violation")) break;
                this.message = this.characters.toString();
                this.characters = null;
            }
        }
    }

    private String at() {
        return " (" + this.path + ", line " + this.locatorLine + ", column " + this.locatorColumn + ')';
    }

    public static class DocumentModel
    implements Comparable<DocumentModel> {
        private final Path workspace;
        private final Path project;
        private final Path directory;
        private final Path file;

        public DocumentModel(Path workspace, Path project, Path directory, Path file) {
            assert (workspace != null) : "workspace == null";
            this.workspace = workspace;
            this.project = project;
            this.directory = directory;
            this.file = file;
        }

        public Path getWorkspace() {
            return this.workspace;
        }

        public Path getProject() {
            return this.project;
        }

        public Path getDirectory() {
            return this.directory;
        }

        public Path getFile() {
            return this.file;
        }

        @Override
        public int compareTo(DocumentModel that) {
            int comparison = this.workspace.compareTo(that.workspace);
            if (comparison != 0) {
                return comparison;
            }
            int n = this.project == null ? (that.project == null ? 0 : -1) : (comparison = that.project == null ? 1 : this.project.compareTo(that.project));
            if (comparison != 0) {
                return comparison;
            }
            int n2 = this.directory == null ? (that.directory == null ? 0 : -1) : (comparison = that.directory == null ? 1 : this.directory.compareTo(that.directory));
            if (comparison != 0) {
                return comparison;
            }
            return this.file == null ? (that.file == null ? 0 : -1) : (that.file == null ? 1 : this.file.compareTo(that.file));
        }

        public boolean equals(Object object) {
            if (!(object instanceof DocumentModel)) {
                return false;
            }
            DocumentModel that = (DocumentModel)object;
            if (!this.workspace.equals(that.workspace)) {
                return false;
            }
            if (this.project != null ? !this.project.equals(that.project) : that.project != null) {
                return false;
            }
            if (this.directory != null ? !this.directory.equals(that.directory) : that.directory != null) {
                return false;
            }
            return !(this.file != null ? !this.file.equals(that.file) : that.file != null);
        }

        public int hashCode() {
            int result = this.workspace.hashCode();
            result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
            result = 31 * result + (this.directory != null ? this.directory.hashCode() : 0);
            result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
            return result;
        }
    }

    private class RuleNotFoundSAXException
    extends SAXException {
        public RuleNotFoundSAXException(String message) {
            super(message + ReportReader.this.at());
        }
    }

    private class LocatorSAXException
    extends SAXException {
        public LocatorSAXException(String message) {
            super(message + ReportReader.this.at());
        }

        public LocatorSAXException(String message, Exception e) {
            super(message + ReportReader.this.at(), e);
        }
    }
}

