/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.report;

import java.util.Objects;
import oracle.javatools.exports.report.IssueModel;

public abstract class IssueProperty<T extends Comparable<T>> {
    private final String name;

    public IssueProperty(String name) {
        this.name = name.toUpperCase();
    }

    public abstract T getValue(IssueModel var1);

    public int compareValue(IssueModel left, IssueModel right) {
        T lv = this.getValue(left);
        T rv = this.getValue(right);
        if (lv == null) {
            return rv == null ? 0 : -1;
        }
        return rv == null ? 1 : lv.compareTo(rv);
    }

    public String getName() {
        return this.name;
    }

    public String toString(IssueModel issue) {
        T value = this.getValue(issue);
        return value == null ? "" : this.toString(value);
    }

    public String toString(T value) {
        return String.valueOf(value);
    }

    public String toString(IssueModel leftIssue, IssueModel rightIssue) {
        if (leftIssue != null && rightIssue != null) {
            T right;
            T left = this.getValue(leftIssue);
            if (Objects.equals(left, right = this.getValue(rightIssue))) {
                return left == null ? "" : this.toString(left);
            }
            return this.toString(left) + "<>" + this.toString(right);
        }
        if (leftIssue != null) {
            T left = this.getValue(leftIssue);
            return left == null ? "" : this.toString(left);
        }
        T right = this.getValue(rightIssue);
        return right == null ? "" : this.toString(right);
    }
}

