/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.report;

import java.nio.file.Path;

public class IssueModel
implements Comparable<IssueModel> {
    private final Path workspace;
    private final Path project;
    private final Path directory;
    private final Path file;
    private final int line;
    private final int column;
    private final String rule;
    private final String variation;
    private final String message;

    public IssueModel(Path workspace, Path project, Path directory, Path file, int line, int column, String rule, String variation, String message) {
        this.workspace = workspace;
        this.project = project;
        this.directory = directory;
        this.file = file;
        this.line = line;
        this.column = column;
        this.rule = rule;
        this.variation = variation;
        this.message = message;
    }

    public Path getWorkspace() {
        return this.workspace;
    }

    public Path getProject() {
        return this.project;
    }

    public Path getDirectory() {
        return this.directory;
    }

    public Path getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getRule() {
        return this.rule;
    }

    public String getVariation() {
        return this.variation;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public int compareTo(IssueModel that) {
        int comparison = this.workspace.compareTo(that.workspace);
        if (comparison != 0) {
            return comparison;
        }
        int n = this.project == null ? (that.project == null ? 0 : -1) : (comparison = that.project == null ? 1 : this.project.compareTo(that.project));
        if (comparison != 0) {
            return comparison;
        }
        int n2 = this.directory == null ? (that.directory == null ? 0 : -1) : (comparison = that.directory == null ? 1 : this.directory.compareTo(that.directory));
        if (comparison != 0) {
            return comparison;
        }
        int n3 = this.file == null ? (that.file == null ? 0 : -1) : (comparison = that.file == null ? 1 : this.file.compareTo(that.file));
        if (comparison != 0) {
            return comparison;
        }
        comparison = Integer.compare(this.line, that.line);
        if (comparison != 0) {
            return comparison;
        }
        comparison = Integer.compare(this.column, that.column);
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.rule.compareTo(that.rule);
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.variation.compareTo(that.variation);
        if (comparison != 0) {
            return comparison;
        }
        return this.message.compareTo(that.message);
    }

    public boolean equals(Object object) {
        if (!(object instanceof IssueModel)) {
            return false;
        }
        IssueModel that = (IssueModel)object;
        return this.workspace.equals(that.workspace) && (this.project != null ? this.project.equals(that.project) : that.project == null) && (this.directory != null ? this.directory.equals(that.directory) : that.directory == null) && (this.file != null ? this.file.equals(that.file) : that.file == null) && this.line == that.line && this.column == that.column && this.rule.equals(that.rule) && this.variation.equals(that.variation) && this.message.equals(that.message);
    }

    public int hashCode() {
        int result = this.workspace.hashCode();
        result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
        result = 31 * result + (this.directory != null ? this.directory.hashCode() : 0);
        result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
        result = 31 * result + this.line;
        result = 31 * result + this.column;
        result = 31 * result + this.rule.hashCode();
        result = 31 * result + this.variation.hashCode();
        result = 31 * result + this.message.hashCode();
        return result;
    }
}

