/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.name;

import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import oracle.javatools.exports.name.ElementName;
import oracle.javatools.exports.name.NameFormat;
import oracle.javatools.exports.name.PackageName;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.name.TypeOrMemberName;

public abstract class MemberName
extends TypeOrMemberName {
    public static final Comparator<MemberName> COMPARATOR = Comparator.naturalOrder();
    public static final Comparator<MemberName> UNQUALIFIED_COMPARATOR = MemberName::compareToUnqualified;
    private final TypeName parent;

    MemberName(TypeName parent) {
        this.parent = parent;
    }

    @Override
    public final int getLevel() {
        return 2;
    }

    @Override
    public final ElementName getParent() {
        return this.parent;
    }

    @Override
    public final PackageName getPackage() {
        return this.parent.getPackage();
    }

    @Override
    public TypeName getType() {
        return this.parent;
    }

    @Override
    public boolean isType() {
        return false;
    }

    @Override
    public boolean isMember() {
        return true;
    }

    public abstract int getArity();

    public abstract boolean isVariableArity();

    public abstract boolean isFixedArity();

    public abstract TypeName[] getParameters();

    public int getParametersLength(TypeName[] parameters, boolean varargs) {
        if (parameters.length == 0) {
            return 2;
        }
        int length = 2 + parameters.length - 1;
        for (TypeName parameter : parameters) {
            length += parameter.getQualifiedNameLength();
        }
        if (varargs) {
            ++length;
        }
        return length;
    }

    public abstract StringBuilder appendSourceName(StringBuilder var1);

    @Override
    public StringBuilder appendQualifiedSourceName(StringBuilder builder) {
        this.parent.appendQualifiedSourceNamePrefix(builder);
        return this.appendSourceName(builder);
    }

    @Override
    public void writeQualifiedSourceName(Writer writer) throws IOException {
        this.parent.writeQualifiedSourceName(writer);
        writer.write(46);
        this.writeSourceName(writer);
    }

    public abstract StringBuilder appendBinaryName(StringBuilder var1);

    @Override
    public StringBuilder appendQualifiedBinaryName(StringBuilder builder) {
        this.parent.appendQualifiedBinaryNamePrefix(builder);
        return this.appendBinaryName(builder);
    }

    @Override
    public void writeQualifiedBinaryName(Writer writer) throws IOException {
        this.parent.writeQualifiedBinaryName(writer);
        writer.write(47);
        this.writeBinaryName(writer);
    }

    public abstract StringBuilder appendHybridName(StringBuilder var1);

    public int getHybridParametersLength(TypeName[] parameters, boolean varargs) {
        if (parameters.length == 0) {
            return 2;
        }
        int length = 2 + parameters.length - 1;
        for (TypeName parameter : parameters) {
            length += parameter.getQualifiedHybridNameLength();
        }
        if (varargs) {
            ++length;
        }
        return length;
    }

    @Override
    public StringBuilder appendQualifiedHybridName(StringBuilder builder) {
        this.parent.appendQualifiedHybridNamePrefix(builder);
        return this.appendHybridName(builder);
    }

    @Override
    public void writeQualifiedHybridName(Writer writer) throws IOException {
        this.parent.writeQualifiedHybridName(writer);
        writer.write(47);
        this.writeHybridName(writer);
    }

    protected final StringBuilder appendParameters(StringBuilder builder, NameFormat format, TypeName[] parameters, boolean varargs) {
        builder.append('(');
        int last = parameters.length - 1;
        for (int i = 0; i <= last; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            if (!varargs || i != last) {
                parameters[i].appendQualifiedName(builder, format);
                continue;
            }
            parameters[i].getComponentType().appendQualifiedName(builder, format).append("...");
        }
        builder.append(')');
        return builder;
    }

    protected final void writeParameters(Writer writer, NameFormat format, TypeName[] parameters, boolean varargs) throws IOException {
        writer.write(40);
        int last = parameters.length - 1;
        for (int i = 0; i <= last; ++i) {
            if (i > 0) {
                writer.write(44);
            }
            TypeName parameterTypeName = parameters[i];
            if (!varargs || i != last) {
                parameterTypeName.writeQualifiedName(writer, format);
                continue;
            }
            parameterTypeName.getComponentType().writeQualifiedName(writer, format);
            writer.write("...");
        }
        writer.write(41);
    }

    @Override
    public final int compareTo(ElementName that) {
        switch (that.getLevel()) {
            case 0: {
                int comparison = this.getPackage().compareTo(that.getPackage());
                return comparison != 0 ? comparison : 1;
            }
            case 1: {
                int comparison = this.parent.compareTo(that);
                return comparison != 0 ? comparison : 1;
            }
            case 2: {
                int comparison = this.parent.compareTo(((MemberName)that).parent);
                return comparison != 0 ? comparison : this.compareToUnqualified((MemberName)that);
            }
        }
        throw new IllegalStateException("illegal level " + that.getLevel() + " in " + that);
    }

    @Override
    public final int compareTo(MemberName that) {
        int comparison = this.getType().compareTo(that.getType());
        return comparison != 0 ? comparison : this.compareToUnqualified(that);
    }

    public abstract int compareToUnqualified(MemberName var1);

    protected final int compareParameters(TypeName[] thisParameters, TypeName[] thatParameters, boolean thisVarargs, boolean thatVarargs) {
        if (thisParameters.length + thatParameters.length == 0) {
            return 0;
        }
        for (int i = 0; i < Math.min(thisParameters.length, thatParameters.length); ++i) {
            int comparison = this.compareParameter(thisParameters[i], thatParameters[i]);
            if (comparison == 0) continue;
            return comparison;
        }
        int comparison = thisParameters.length - thatParameters.length;
        if (comparison != 0) {
            comparison = comparison < 0 ? Character.compare(')', ',') : Character.compare(',', ')');
        }
        return comparison;
    }

    private int compareParameter(TypeName left, TypeName right) {
        if (left == right) {
            return 0;
        }
        PackageName leftPackage = left.getPackage();
        PackageName rightPackage = right.getPackage();
        if (leftPackage.isDefault()) {
            if (rightPackage.isDefault()) {
                return left.getBinaryName().compareTo(right.getBinaryName());
            }
            int comparison = left.getBinaryName().compareTo(rightPackage.getBinaryName());
            return comparison != 0 ? comparison : -1;
        }
        if (rightPackage.isDefault()) {
            int comparison = leftPackage.getBinaryName().compareTo(right.getBinaryName());
            return comparison != 0 ? comparison : 1;
        }
        return left.compareTo(right);
    }
}

