/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.name;

public enum ElementKind {
    PACKAGE("package", false),
    TYPE("type", false),
    CONSTRUCTOR("constructor", true),
    METHOD("method", true),
    FIELD("field", true);

    private final String lowerCase;
    private final boolean member;

    private ElementKind(String lowerCase, boolean member) {
        this.lowerCase = lowerCase;
        this.member = member;
    }

    public static ElementKind valueOfIgnoreCase(String string) {
        return ElementKind.valueOf(string.toUpperCase());
    }

    public boolean isType() {
        return this == TYPE;
    }

    public boolean isMember() {
        return this.member;
    }

    public boolean isPackage() {
        return this == PACKAGE;
    }

    public boolean isConstructor() {
        return this == CONSTRUCTOR;
    }

    public boolean isMethod() {
        return this == METHOD;
    }

    public boolean isField() {
        return this == FIELD;
    }

    public String toLowerCase() {
        return this.lowerCase;
    }

    public String toUpperCase() {
        return super.toString();
    }

    public String toString() {
        return this.lowerCase;
    }
}

